/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.inventory.container.ContainerField;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.FieldPlotResizeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindowField
extends ContainerScreen<ContainerField> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/scarecrow.png");
    private static final int X_OFFSET = 8;
    private static final int Y_OFFSET = 6;
    private static final int TEXT_COLOR = 0x404040;
    private static final int BUTTON_SIDE_LENGTH = 24;
    private final AbstractScarecrowTileEntity tileEntity;
    private final int[] radii = new int[4];

    public WindowField(ContainerField container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.tileEntity = container.getTileEntity();
    }

    protected void init() {
        super.init();
        int centerX = this.field_147003_i + this.field_146999_f / 2 + 1;
        int centerY = this.field_147009_r + this.field_147000_g / 2;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int xFromPolar = (int)Math.sin(Math.PI * (double)(4 - dir.func_176736_b()) / 2.0) * 24;
            int yFromPolar = (int)Math.cos(Math.PI * (double)(4 - dir.func_176736_b()) / 2.0) * 24;
            this.radii[dir.func_176736_b()] = this.tileEntity.getRadius(dir);
            DirectionalButton db = new DirectionalButton(centerX + xFromPolar - 12, centerY - 40 + yFromPolar - 12, 24, 24, String.valueOf(this.radii[dir.func_176736_b()]), dir);
            this.addButton((Widget)db);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (!this.tileEntity.getOwner().isEmpty()) {
            this.font.func_211126_b(LanguageHandler.format((String)"com.minecolonies.coremod.gui.field.worker", (Object[])new Object[]{this.tileEntity.getOwner()}), 8.0f, -12.0f, 0xFFFFFF);
        }
        this.font.func_211126_b(LanguageHandler.format((String)"block.minecolonies.blockhutfield", (Object[])new Object[0]), 8.0f, 6.0f, 0x404040);
        for (Widget widget : this.buttons) {
            if (!widget.isHovered()) continue;
            widget.renderToolTip(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int marginHorizontal = (this.width - this.field_146999_f) / 2;
        int marginVertical = (this.height - this.field_147000_g) / 2;
        this.blit(marginHorizontal, marginVertical, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void render(int x, int y, float z) {
        this.renderBackground();
        super.render(x, y, z);
        this.func_191948_b(x, y);
    }

    protected class DirectionalButton
    extends Button {
        public Direction direction;
        public int textureX;
        public int textureY;
        public int columns;

        public DirectionalButton(int x, int y, int width, int height, String text, Direction direction) {
            super(x, y, width, height, text, button -> {});
            this.textureX = 176;
            this.textureY = 0;
            this.columns = 2;
            this.direction = direction;
        }

        public void onPress() {
            int index = this.direction.func_176736_b();
            ((WindowField)WindowField.this).radii[index] = (WindowField.this.radii[index] + 1) % (ScarecrowTileEntity.getMaxRange() + 1);
            this.setMessage(String.valueOf(WindowField.this.radii[index]));
            Network.getNetwork().sendToServer(new FieldPlotResizeMessage(WindowField.this.radii[index], this.direction, WindowField.this.tileEntity.func_174877_v()));
        }

        public int getTextureXOffset() {
            return this.textureX + 24 * Math.floorDiv(this.direction.func_176736_b(), this.columns);
        }

        public int getTextureYOffset() {
            return this.textureY + 72 * (this.direction.func_176736_b() % this.columns);
        }

        public int getTextOffset(Direction.Axis axis) {
            switch (this.direction) {
                case NORTH: {
                    return axis == Direction.Axis.X ? 0 : 2;
                }
                case EAST: {
                    return axis == Direction.Axis.X ? -2 : 0;
                }
                case SOUTH: {
                    return axis == Direction.Axis.X ? 0 : -2;
                }
                case WEST: {
                    return axis == Direction.Axis.X ? 2 : 0;
                }
            }
            return 0;
        }

        public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            int i = this.getYImage(this.isHovered());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.blit(this.x, this.y, this.getTextureXOffset(), this.getTextureYOffset() + i * 24, this.width, this.height);
            this.renderBg(minecraft, p_renderButton_1_, p_renderButton_2_);
            int j = this.getFGColor();
            this.drawCenteredString(fontrenderer, this.getMessage(), this.x + this.width / 2 + this.getTextOffset(Direction.Axis.X), this.y + (this.height - 8) / 2 + this.getTextOffset(Direction.Axis.Y), j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (!WindowField.this.field_213127_e.func_70445_o().func_190926_b()) {
                return;
            }
            ArrayList lines = Lists.newArrayList((Object[])new String[]{LanguageHandler.format((String)("com.minecolonies.coremod.gui.field." + this.direction.func_176610_l()), (Object[])new Object[0]), TextFormatting.GRAY + "" + TextFormatting.ITALIC + LanguageHandler.format((String)this.getDirectionalTranslationKey(), (Object[])new Object[0])});
            WindowField.this.renderTooltip(lines, mouseX, mouseY);
        }

        public String getDirectionalTranslationKey() {
            Direction[] looks = Direction.func_196054_a((Entity)((WindowField)WindowField.this).field_213127_e.field_70458_d);
            Direction facing = looks[0].func_176740_k() == Direction.Axis.Y ? looks[1] : looks[0];
            switch (facing.func_176734_d().func_176736_b() - this.direction.func_176736_b()) {
                case -3: 
                case 1: {
                    return "com.minecolonies.coremod.gui.field.to_right";
                }
                case -2: 
                case 2: {
                    return "com.minecolonies.coremod.gui.field.opposite";
                }
                case -1: 
                case 3: {
                    return "com.minecolonies.coremod.gui.field.to_left";
                }
            }
            return "com.minecolonies.coremod.gui.field.near";
        }
    }
}

