/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class WindowFurnaceCrafting
extends ContainerScreen<ContainerCraftingFurnace> {
    private static final ResourceLocation CRAFTING_FURNACE = new ResourceLocation("minecolonies", "textures/gui/furnace.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private final ContainerCraftingFurnace container;
    private final AbstractBuildingSmelterCrafter.View building;

    public WindowFurnaceCrafting(ContainerCraftingFurnace container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingSmelterCrafter.View)IColonyManager.getInstance().getBuildingView(playerInventory.field_70458_d.field_71093_bK.func_186068_a(), container.getPos());
    }

    protected void init() {
        super.init();
        String buttonDisplay = this.building.canRecipeBeAdded() ? I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]) : LanguageHandler.format((String)"com.minecolonies.coremod.gui.recipe.full", (Object[])new Object[0]);
        Button doneButton = new Button(this.field_147003_i + 1, this.field_147009_r + 170, 150, 20, buttonDisplay, (Button.IPressable)new OnButtonPress());
        this.addButton((Widget)doneButton);
        if (!this.building.canRecipeBeAdded()) {
            doneButton.active = false;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(CRAFTING_FURNACE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void render(int x, int y, float z) {
        this.renderBackground();
        super.render(x, y, z);
        this.func_191948_b(x, y);
    }

    public class OnButtonPress
    implements Button.IPressable {
        public void onPress(Button button) {
            if (WindowFurnaceCrafting.this.building.canRecipeBeAdded()) {
                ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                input.add(((Slot)((WindowFurnaceCrafting)WindowFurnaceCrafting.this).container.field_75151_b.get(0)).func_75211_c());
                ItemStack primaryOutput = ((Slot)((WindowFurnaceCrafting)WindowFurnaceCrafting.this).container.field_75151_b.get(1)).func_75211_c().func_77946_l();
                if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(WindowFurnaceCrafting.this.building, input, 1, primaryOutput, (List<ItemStack>)ImmutableList.of(), false));
                }
            }
        }
    }
}

