/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractBuildingCrafter
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    public AbstractBuildingCrafter(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public boolean canBeGathered() {
        return super.canBeGathered() && this.getAssignedCitizen().stream().map(c -> c.getJob(AbstractJobCrafter.class)).filter(Objects::nonNull).allMatch(AbstractJobCrafter::hasTask);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        Collection supers = super.createResolvers().stream().filter(r -> !(r instanceof PrivateWorkerCraftingProductionResolver) && !(r instanceof PrivateWorkerCraftingRequestResolver)).collect(Collectors.toList());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> recipeOutputs = new HashMap<ItemStorage, Tuple>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueue()) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.func_76341_a()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.func_76340_b();
                if (recipeOutputs.containsKey(itemStorage)) {
                    amount += ((Integer)((Tuple)recipeOutputs.get(itemStorage)).func_76341_a()).intValue();
                }
                recipeOutputs.put(itemStorage, new Tuple((Object)amount, (Object)false));
            }
            ItemStorage output = new ItemStorage(((IRecipeStorage)recipeStorage.func_76341_a()).getPrimaryOutput());
            int amount = output.getAmount() * (Integer)recipeStorage.func_76340_b();
            if (recipeOutputs.containsKey(output)) {
                amount += ((Integer)((Tuple)recipeOutputs.get(output)).func_76341_a()).intValue();
            }
            recipeOutputs.put(output, new Tuple((Object)amount, (Object)false));
        }
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        toKeep.putAll(recipeOutputs.entrySet().stream().collect(Collectors.toMap(key -> stack -> stack.func_77969_a(((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        return toKeep;
    }

    @Override
    public Map<ItemStorage, Integer> reservedStacks() {
        HashMap<ItemStorage, Integer> recipeOutputs = new HashMap<ItemStorage, Integer>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueue()) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.func_76341_a()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.func_76340_b();
                if (recipeOutputs.containsKey(itemStorage)) {
                    amount += ((Integer)recipeOutputs.get(itemStorage)).intValue();
                }
                recipeOutputs.put(itemStorage, amount);
            }
        }
        return recipeOutputs;
    }

    private List<Tuple<IRecipeStorage, Integer>> getPendingRequestQueue() {
        ArrayList<Tuple<IRecipeStorage, Integer>> recipes = new ArrayList<Tuple<IRecipeStorage, Integer>>();
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            ArrayList assignedTasks = new ArrayList(citizen.getJob(AbstractJobCrafter.class).getAssignedTasks());
            assignedTasks.addAll(citizen.getJob(AbstractJobCrafter.class).getTaskQueue());
            for (IToken iToken : assignedTasks) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(iToken);
                IRecipeStorage recipeStorage = this.getFirstRecipe(((PublicCrafting)request.getRequest()).getStack());
                if (recipeStorage == null) continue;
                recipes.add((Tuple<IRecipeStorage, Integer>)new Tuple((Object)recipeStorage, (Object)((PublicCrafting)request.getRequest()).getCount()));
            }
        }
        return recipes;
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
        for (IToken token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) && !storage.getAlternateOutputs().stream().anyMatch(i -> stackPredicate.test((ItemStack)i))) continue;
            List<IItemHandler> handlers = this.getHandlers();
            IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
            if (!toTest.canFullFillRecipe(count, considerReservation ? this.reservedStacks() : Collections.emptyMap(), handlers.toArray(new IItemHandler[0]))) continue;
            return toTest;
        }
        return null;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    protected Optional<Boolean> canRecipeBeAddedBasedOnTags(IToken token) {
        return super.canRecipeBeAddedBasedOnTags(token);
    }

    @Override
    public Skill getCraftSpeedSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public Skill getRecipeImprovementSkill() {
        return this.getPrimarySkill();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }
    }
}

