/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.util.ChunkDataHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracksTower
extends AbstractBuildingGuards {
    private static final String TAG_POS = "pos";
    private static final String SCHEMATIC_NAME = "barrackstower";
    private static final int DEFENCE_BONUS = 0;
    private static final int OFFENCE_BONUS = 5;
    private BlockPos barracks = null;

    public BuildingBarracksTower(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getDefenceBonus() {
        return 0;
    }

    @Override
    public int getOffenceBonus() {
        return 5;
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        int buildingLevel = this.getBuildingLevel();
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.barracks);
        if (building != null && buildingLevel < this.getMaxBuildingLevel() && buildingLevel < building.getBuildingLevel()) {
            this.requestWorkOrder(buildingLevel + 1, builder, false);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.worker.needbarracks", new Object[0]));
        }
    }

    @Override
    public boolean canDeconstruct() {
        return false;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.barracksTower;
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        boolean assignalResult = super.assignCitizen(citizen);
        if (citizen != null && assignalResult) {
            IBuilding building = citizen.getHomeBuilding();
            if (building != null && !(building instanceof AbstractBuildingGuards)) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            citizen.setWorkBuilding(this);
        }
        return assignalResult;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        return 0;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        IBuilding barrack = this.colony.getBuildingManager().getBuilding(this.barracks);
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.barracks, barrack.getClaimRadius(newLevel));
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.barracks = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(TAG_POS));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.barracks != null) {
            compound.func_218657_a(TAG_POS, (INBT)NBTUtil.func_186859_a((BlockPos)this.barracks));
        }
        return compound;
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public void addBarracks(BlockPos pos) {
        this.barracks = pos;
    }

    public static class View
    extends AbstractBuildingGuards.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

