/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutCrusher;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.network.messages.server.colony.building.crusher.CrusherSetModeMessage;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingCrusher
extends AbstractBuildingCrafter {
    private static final double BUILDING_LEVEL_MULTIPLIER = 16.0;
    private static final String CRUSHER_DESC = "crusher";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Map<ItemStorage, IRecipeStorage> crusherRecipes = new HashMap<ItemStorage, IRecipeStorage>();
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage crusherMode = null;
    private boolean oneByOne = false;

    public BuildingCrusher(IColony c, BlockPos l) {
        super(c, l);
        this.loadCrusherMode();
    }

    private void loadCrusherMode() {
        this.crusherRecipes.clear();
        UnlockAbilityResearchEffect researchEffect = this.getColony().getResearchManager().getResearchEffects().getEffect("1:1 Crushing", UnlockAbilityResearchEffect.class);
        boolean oneOne = researchEffect != null && researchEffect.getEffect() != false;
        for (Map.Entry<ItemStorage, ItemStorage> mode : IColonyManager.getInstance().getCompatibilityManager().getCrusherModes().entrySet()) {
            if (this.crusherMode == null) {
                this.crusherMode = mode.getKey();
            }
            ItemStack input = mode.getKey().getItemStack();
            if (oneOne) {
                input.func_190920_e(1);
            }
            IRecipeStorage recipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(input), 2, mode.getValue().getItemStack(), ModBlocks.blockHutCrusher});
            this.crusherRecipes.put(mode.getKey(), recipe);
        }
    }

    public IRecipeStorage getCurrentRecipe() {
        return this.crusherRecipes.get(this.crusherMode);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CRUSHER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobCrusher(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return CRUSHER_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Stamina;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
        this.crusherMode = crusherMode;
        this.dailyQuantity = dailyQuantity;
    }

    public Tuple<ItemStorage, Integer> getCrusherMode() {
        return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 16.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        if (compound.func_150296_c().contains("Crushermode")) {
            this.crusherMode = new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Crushermode")));
        }
        this.oneByOne = compound.func_74767_n("1:1 Crushing");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        if (this.crusherMode != null) {
            CompoundNBT crusherModeNBT = new CompoundNBT();
            this.crusherMode.getItemStack().func_77955_b(crusherModeNBT);
            compound.func_218657_a("Crushermode", (INBT)crusherModeNBT);
        }
        compound.func_74757_a("1:1 Crushing", this.oneByOne);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        boolean oneOne;
        super.serializeToView(buf);
        UnlockAbilityResearchEffect researchEffect = this.getColony().getResearchManager().getResearchEffects().getEffect("1:1 Crushing", UnlockAbilityResearchEffect.class);
        boolean bl = oneOne = researchEffect != null && researchEffect.getEffect() != false;
        if (this.crusherRecipes.isEmpty() || oneOne && !this.oneByOne) {
            this.loadCrusherMode();
        }
        if (this.crusherMode == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_150788_a(this.crusherMode.getItemStack());
        }
        buf.writeInt(this.dailyQuantity);
        buf.writeInt(this.crusherRecipes.size());
        for (ItemStorage storage : this.crusherRecipes.keySet()) {
            buf.func_150788_a(storage.getItemStack());
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.crusher;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Crusher", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private int dailyQuantity = 0;
        private ItemStorage crusherMode;
        private final List<ItemStorage> crusherModes = new ArrayList<ItemStorage>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            if (buf.readBoolean()) {
                this.crusherMode = new ItemStorage(buf.func_150791_c());
            }
            this.dailyQuantity = buf.readInt();
            this.crusherModes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.crusherModes.add(new ItemStorage(buf.func_150791_c()));
            }
        }

        public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
            this.crusherMode = crusherMode;
            this.dailyQuantity = dailyQuantity;
            Network.getNetwork().sendToServer(new CrusherSetModeMessage(this, crusherMode, dailyQuantity));
        }

        public Tuple<ItemStorage, Integer> getCrusherMode() {
            return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
        }

        public List<ItemStorage> getCrusherModes() {
            return this.crusherModes;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrusher(this);
        }
    }
}

