/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobFletcher;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingFletcher
extends AbstractBuildingCrafter {
    private static final String FLETCHER = "fletcher";

    public BuildingFletcher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLETCHER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobFletcher(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return FLETCHER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Dexterity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getCraftSpeedSkill() {
        return this.getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return storage.getPrimaryOutput().func_77973_b() instanceof ArrowItem || storage.getPrimaryOutput().func_77973_b() instanceof DyeableArmorItem && ((DyeableArmorItem)storage.getPrimaryOutput().func_77973_b()).func_200880_d() == ArmorMaterial.LEATHER;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.fletcher;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Fletcher", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingFletcher.FLETCHER);
        }
    }
}

