/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.util.StudyItem;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuildingWorker {
    private static final String STUDENT = "student";
    private static final String LIBRARY_HUT_NAME = "library";
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Random random = new Random();
    private final List<StudyItem> studyItems = this.parseFromConfig();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
    }

    private List<StudyItem> parseFromConfig() {
        ArrayList<StudyItem> studyItemList = new ArrayList<StudyItem>();
        for (String entry : (List)MineColonies.getConfig().getCommon().configListStudyItems.get()) {
            try {
                String[] entries = entry.split(";");
                if (entries.length < 3) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entries[0]));
                int skillChance = Integer.parseInt(entries[1]);
                int breakChance = Integer.parseInt(entries[2]);
                if (item == null || skillChance < 100 || skillChance > 1000 || breakChance > 100 || breakChance < 0) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                studyItemList.add(new StudyItem(item, skillChance, breakChance));
                this.keepX.put(itemStack -> itemStack.func_77973_b() == item, new Tuple((Object)(breakChance < 5 ? 5 : breakChance), (Object)true));
            }
            catch (ClassCastException | NumberFormatException e) {
                Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry + " Exception:" + e.getMessage());
            }
        }
        return studyItemList;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Intelligence;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Intelligence;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return STUDENT;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobStudent(citizen);
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT furnaceTagList = compound.func_150295_c("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT bookcaseTagList = new ListNBT();
        for (BlockPos entry : this.bookCases) {
            CompoundNBT bookCompound = new CompoundNBT();
            bookCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.func_218657_a("bookcase", (INBT)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150342_X) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() == Blocks.field_150342_X) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    public List<StudyItem> getStudyItems() {
        return this.studyItems;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.library;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Library", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingLibrary.LIBRARY_HUT_NAME);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel() * 2;
        }
    }
}

