/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobMechanic;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.MinecartItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingMechanic
extends AbstractBuildingCrafter {
    private static final String MECHANIC = "mechanic";

    public BuildingMechanic(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MECHANIC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobMechanic(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return MECHANIC;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Agility;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return storage.getPrimaryOutput().func_77973_b() instanceof MinecartItem || storage.getPrimaryOutput().func_77973_b() instanceof BlockItem && ((BlockItem)storage.getPrimaryOutput().func_77973_b()).func_179223_d() instanceof HopperBlock;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.mechanic;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Mechanic", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingMechanic.MECHANIC);
        }
    }
}

