/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutShepherd;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHerder;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.network.messages.server.colony.building.shepherd.ShepherdSetDyeSheepsMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingShepherd
extends AbstractBuildingHerder {
    private static final String SHEPHERD = "shepherd";
    private static final String NBT_DYE_SHEEPS = "autoDye";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean dyeSheeps = false;

    public BuildingShepherd(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SHEPHERD;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return SHEPHERD;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobShepherd(citizen);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.dyeSheeps);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.shepherd;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.dyeSheeps = compound.func_74767_n(NBT_DYE_SHEEPS);
        if (!compound.func_150296_c().contains(NBT_DYE_SHEEPS)) {
            this.dyeSheeps = true;
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a(NBT_DYE_SHEEPS, this.dyeSheeps);
        return compound;
    }

    public boolean isDyeSheeps() {
        return this.dyeSheeps;
    }

    public void setDyeSheeps(boolean dyeSheeps) {
        this.dyeSheeps = dyeSheeps;
        this.markDirty();
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingHerder.View {
        private boolean dyeSheeps = false;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutShepherd(this);
        }

        public void setDyeSheeps(boolean dyeSheeps) {
            this.dyeSheeps = dyeSheeps;
            Network.getNetwork().sendToServer(new ShepherdSetDyeSheepsMessage(this));
        }

        public boolean isDyeSheeps() {
            return this.dyeSheeps;
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.dyeSheeps = buf.readBoolean();
        }
    }
}

