/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobStonemason;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingStonemason
extends AbstractBuildingCrafter {
    private static final String STONEMASON = "stonemason";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingStonemason(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONEMASON;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobStonemason(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return STONEMASON;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage iRecipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return false;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.stoneMason;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Stonemason", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingStonemason.STONEMASON);
        }
    }
}

