/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowTownHall;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingTownHall
extends AbstractBuilding
implements ITownHall {
    private static final String TOWN_HALL = "townhall";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final LinkedList<PermissionEvent> permissionEvents = new LinkedList();

    public BuildingTownHall(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TOWN_HALL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.townHall;
    }

    @Override
    public void addPermissionEvent(PermissionEvent event) {
        if (this.getBuildingLevel() >= 1 && !this.permissionEvents.contains(event)) {
            if (this.permissionEvents.size() >= 100) {
                this.permissionEvents.removeFirst();
            }
            this.permissionEvents.add(event);
            this.markDirty();
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(((Boolean)MineColonies.getConfig().getCommon().canPlayerUseAllyTHTeleport.get()).booleanValue());
        buf.writeInt(this.permissionEvents.size());
        for (PermissionEvent event : this.permissionEvents) {
            event.serialize(buf);
        }
        List<IColonyEventDescription> colonyEvents = this.colony.getEventDescriptionManager().getEventDescriptions();
        buf.writeInt(colonyEvents.size());
        for (IColonyEventDescription event : colonyEvents) {
            buf.func_180714_a(event.getEventTypeId().func_110623_a());
            event.serialize(buf);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
        super.onBuildingMove(oldBuilding);
        this.colony.getBuildingManager().setTownHall(this);
    }

    @Override
    public void setStyle(String style) {
        super.setStyle(style);
        this.colony.setStyle(style);
    }

    public static class View
    extends AbstractBuildingView
    implements ITownHallView {
        private final List<PermissionEvent> permissionEvents = new LinkedList<PermissionEvent>();
        private final List<IColonyEventDescription> colonyEvents = new LinkedList<IColonyEventDescription>();
        private boolean canPlayerUseTP = false;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowTownHall(this);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.canPlayerUseTP = buf.readBoolean();
            int permissionEventsSize = buf.readInt();
            for (int i = 0; i < permissionEventsSize; ++i) {
                this.permissionEvents.add(new PermissionEvent(buf));
            }
            this.colonyEvents.clear();
            int colonyEventsSize = buf.readInt();
            for (int i = 0; i < colonyEventsSize; ++i) {
                ResourceLocation eventTypeID = new ResourceLocation("minecolonies", buf.func_218666_n());
                ColonyEventDescriptionTypeRegistryEntry registryEntry = (ColonyEventDescriptionTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventDescriptionRegistry().getValue(eventTypeID);
                if (registryEntry == null) {
                    Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.func_110623_a());
                    continue;
                }
                this.colonyEvents.add(registryEntry.deserializeEventDescriptionFromPacketBuffer(buf));
            }
        }

        @Override
        public List<PermissionEvent> getPermissionEvents() {
            return new LinkedList<PermissionEvent>(this.permissionEvents);
        }

        @Override
        public List<IColonyEventDescription> getColonyEvents() {
            return new LinkedList<IColonyEventDescription>(this.colonyEvents);
        }

        @Override
        public boolean canPlayerUseTP() {
            return this.canPlayerUseTP;
        }
    }
}

