/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String BLOCK_TAG = "block";
    private static final String INPUT_TAG = "input";
    private static final String ALTOUTPUT_TAG = "alternate-output";
    private static final String SECOUTPUT_TAG = "secondary-output";
    private static final String SOURCE_TAG = "source";
    private static final String TYPE_TAG = "type";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public RecipeStorage getNewInstance(@NotNull IToken<?> token, @NotNull List<ItemStack> input, int gridSize, @NotNull ItemStack primaryOutput, Block intermediate, ResourceLocation source, ResourceLocation type, List<ItemStack> altOutputs, List<ItemStack> secOutputs) {
        return new RecipeStorage(token, input, gridSize, primaryOutput, intermediate, source, type, altOutputs, secOutputs);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT inputTagList = new ListNBT();
        for (ItemStack itemStack : recipeStorage.getInput()) {
            CompoundNBT neededRes = new CompoundNBT();
            itemStack.func_77955_b(neededRes);
            inputTagList.add((Object)neededRes);
        }
        compound.func_218657_a(INPUT_TAG, (INBT)inputTagList);
        recipeStorage.getPrimaryOutput().func_77955_b(compound);
        if (recipeStorage.getIntermediate() != null) {
            compound.func_218657_a(BLOCK_TAG, (INBT)NBTUtil.func_190009_a((BlockState)recipeStorage.getIntermediate().func_176223_P()));
        }
        compound.func_74768_a(TAG_GRID, recipeStorage.getGridSize());
        compound.func_218657_a("Token", (INBT)StandardFactoryController.getInstance().serialize(recipeStorage.getToken()));
        if (recipeStorage.getRecipeSource() != null) {
            compound.func_74778_a(SOURCE_TAG, recipeStorage.getRecipeSource().toString());
        }
        compound.func_74778_a(TYPE_TAG, recipeStorage.getRecipeType().getId().toString());
        ListNBT altOutputTagList = new ListNBT();
        for (ItemStack stack : recipeStorage.getAlternateOutputs()) {
            CompoundNBT neededRes = new CompoundNBT();
            stack.func_77955_b(neededRes);
            altOutputTagList.add((Object)neededRes);
        }
        compound.func_218657_a(ALTOUTPUT_TAG, (INBT)altOutputTagList);
        ListNBT listNBT = new ListNBT();
        for (ItemStack stack : recipeStorage.getSecondaryOutputs()) {
            CompoundNBT neededRes = new CompoundNBT();
            stack.func_77955_b(neededRes);
            listNBT.add((Object)neededRes);
        }
        compound.func_218657_a(SECOUTPUT_TAG, (INBT)listNBT);
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ListNBT inputTagList = nbt.func_150295_c(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.size(); ++i) {
            CompoundNBT inputTag = inputTagList.func_150305_b(i);
            input.add(ItemStack.func_199557_a((CompoundNBT)inputTag));
        }
        ItemStack primaryOutput = ItemStack.func_199557_a((CompoundNBT)nbt);
        Block intermediate = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(BLOCK_TAG)).func_177230_c();
        int gridSize = nbt.func_74762_e(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(nbt.func_74775_l("Token"));
        ResourceLocation source = nbt.func_74764_b(SOURCE_TAG) ? new ResourceLocation(nbt.func_74779_i(SOURCE_TAG)) : null;
        ResourceLocation type = nbt.func_74764_b(TYPE_TAG) ? new ResourceLocation(nbt.func_74779_i(TYPE_TAG).toLowerCase()) : ModRecipeTypes.CLASSIC_ID;
        ListNBT altOutputTagList = nbt.func_150295_c(ALTOUTPUT_TAG, 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < altOutputTagList.size(); ++i) {
            CompoundNBT altOutputTag = altOutputTagList.func_150305_b(i);
            altOutputs.add(ItemStack.func_199557_a((CompoundNBT)altOutputTag));
        }
        ListNBT secOutputTagList = nbt.func_150295_c(SECOUTPUT_TAG, 10);
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < secOutputTagList.size(); ++i) {
            CompoundNBT secOutputTag = secOutputTagList.func_150305_b(i);
            secOutputs.add(ItemStack.func_199557_a((CompoundNBT)secOutputTag));
        }
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate, source, type, altOutputs.isEmpty() ? null : altOutputs, secOutputs.isEmpty() ? null : secOutputs);
    }

    @Override
    public void serialize(IFactoryController controller, RecipeStorage input, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(input.getInput().size());
        input.getInput().forEach(stack -> packetBuffer.func_150788_a(stack));
        packetBuffer.func_150788_a(input.getPrimaryOutput());
        packetBuffer.writeBoolean(input.getIntermediate() != null);
        if (input.getIntermediate() != null) {
            packetBuffer.writeInt(Block.func_196246_j((BlockState)input.getIntermediate().func_176223_P()));
        }
        packetBuffer.writeInt(input.getGridSize());
        packetBuffer.func_192572_a(input.getRecipeType().getId());
        packetBuffer.writeInt(input.getAlternateOutputs().size());
        input.getAlternateOutputs().forEach(stack -> packetBuffer.func_150788_a(stack));
        packetBuffer.writeInt(input.getSecondaryOutputs().size());
        input.getSecondaryOutputs().forEach(stack -> packetBuffer.func_150788_a(stack));
        controller.serialize(packetBuffer, input.getToken());
    }

    @Override
    public RecipeStorage deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        int inputSize = buffer.readInt();
        for (int i = 0; i < inputSize; ++i) {
            input.add(buffer.func_150791_c());
        }
        ItemStack primaryOutput = buffer.func_150791_c();
        Block intermediate = buffer.readBoolean() ? Block.func_196257_b((int)buffer.readInt()).func_177230_c() : null;
        int gridSize = buffer.readInt();
        ResourceLocation type = buffer.func_192575_l();
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        int altOutputSize = buffer.readInt();
        for (int i = 0; i < altOutputSize; ++i) {
            altOutputs.add(buffer.func_150791_c());
        }
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        int secOutputSize = buffer.readInt();
        for (int i = 0; i < secOutputSize; ++i) {
            secOutputs.add(buffer.func_150791_c());
        }
        IToken token = (IToken)controller.deserialize(buffer);
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate, null, type, altOutputs.isEmpty() ? null : altOutputs, secOutputs.isEmpty() ? null : secOutputs);
    }

    @Override
    public short getSerializationId() {
        return 26;
    }
}

