/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemCrafterJobDataStore;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJobCrafter<AI extends AbstractEntityAIBasic<J, ? extends AbstractBuildingWorker>, J extends AbstractJobCrafter<AI, J>>
extends AbstractJob<AI, J> {
    private IToken<?> rsDataStoreToken;
    private int maxCraftingCount = 0;
    private int craftCounter = 0;
    private int progress = 0;

    public AbstractJobCrafter(ICitizenData entity) {
        super(entity);
        this.setupRsDataStore();
    }

    private void setupRsDataStore() {
        this.rsDataStoreToken = this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE).getId();
    }

    @Override
    @NotNull
    public IModelType getModel() {
        return BipedModelType.CRAFTER;
    }

    @Override
    public void serializeToView(PacketBuffer buffer) {
        super.serializeToView(buffer);
        StandardFactoryController.getInstance().serialize(buffer, this.rsDataStoreToken);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_218657_a("DataStoreToken", (INBT)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("maxCounter", this.maxCraftingCount);
        compound.func_74768_a("craftCounter", this.craftCounter);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
        if (compound.func_150296_c().contains("progress")) {
            this.progress = compound.func_74762_e("progress");
        }
        if (compound.func_150296_c().contains("maxCounter")) {
            this.progress = compound.func_74762_e("maxCounter");
        }
        if (compound.func_150296_c().contains("craftCounter")) {
            this.progress = compound.func_74762_e("craftCounter");
        }
    }

    private IRequestSystemCrafterJobDataStore getDataStore() {
        return this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE);
    }

    private LinkedList<IToken<?>> getTaskQueueFromDataStore() {
        return this.getDataStore().getQueue();
    }

    public List<IToken<?>> getAssignedTasksFromDataStore() {
        return this.getDataStore().getAssignedTasks();
    }

    public boolean hasTask() {
        return !this.getTaskQueueFromDataStore().isEmpty();
    }

    public <R extends PublicCrafting> IRequest<R> getCurrentTask() {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return null;
        }
        IRequest<?> request = this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
        while (request == null) {
            this.getTaskQueueFromDataStore().remove(this.getTaskQueueFromDataStore().peekFirst());
            request = this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
        }
        return request;
    }

    public void addRequest(@NotNull IToken<?> token) {
        this.getTaskQueueFromDataStore().add(token);
    }

    public void finishRequest(boolean successful) {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return;
        }
        IToken<?> current = this.getTaskQueueFromDataStore().getFirst();
        this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.RESOLVED : RequestState.FAILED);
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.getTaskQueueFromDataStore().contains(token)) {
            this.getTaskQueueFromDataStore().remove(token);
        } else if (this.getAssignedTasksFromDataStore().contains(token)) {
            this.getAssignedTasksFromDataStore().remove(token);
        }
    }

    public void onTaskBeingScheduled(@NotNull IToken<?> token) {
        this.getAssignedTasksFromDataStore().add(token);
    }

    public void onTaskBeingResolved(@NotNull IToken<?> token) {
        this.onTaskDeletion(token);
        this.addRequest(token);
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.getTaskQueueFromDataStore());
    }

    public List<IToken<?>> getAssignedTasks() {
        return ImmutableList.copyOf(this.getAssignedTasksFromDataStore());
    }

    public int getMaxCraftingCount() {
        return this.maxCraftingCount;
    }

    public void setMaxCraftingCount(int maxCraftingCount) {
        this.maxCraftingCount = maxCraftingCount;
    }

    public int getCraftCounter() {
        return this.craftCounter;
    }

    public void setCraftCounter(int craftCounter) {
        this.craftCounter = craftCounter;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void onRemoval() {
        this.cancelAssignedRequests();
        this.getColony().getRequestManager().getDataStoreManager().remove(this.rsDataStoreToken);
    }

    private void cancelAssignedRequests() {
        for (IToken<?> t : this.getTaskQueue()) {
            this.getColony().getRequestManager().updateRequestState(t, RequestState.FAILED);
        }
    }
}

