/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.huts.BlockHutTavern;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.blocks.huts.BlockHutWareHouse;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTavern;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingManager
implements IBuildingManager {
    @NotNull
    private final Map<BlockPos, IBuilding> buildings = new HashMap<BlockPos, IBuilding>();
    private final List<BlockPos> fields = new ArrayList<BlockPos>();
    private final List<IWareHouse> wareHouses = new ArrayList<IWareHouse>();
    @Nullable
    private ITownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isFieldsDirty = false;
    private final Colony colony;

    public BuildingManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        this.buildings.clear();
        ListNBT buildingTagList = compound.func_150295_c("buildings", 10);
        for (int i = 0; i < buildingTagList.size(); ++i) {
            CompoundNBT buildingCompound = buildingTagList.func_150305_b(i);
            IBuilding b = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
        }
        if (compound.func_150296_c().contains("newFields")) {
            ListNBT fieldTagList = compound.func_150295_c("newFields", 10);
            for (int i = 0; i < fieldTagList.size(); ++i) {
                this.addField(BlockPosUtil.read(fieldTagList.func_150305_b(i), "pos"));
            }
        }
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        ListNBT buildingTagList = new ListNBT();
        for (IBuilding b : this.buildings.values()) {
            CompoundNBT buildingCompound = b.serializeNBT();
            buildingTagList.add((Object)buildingCompound);
        }
        compound.func_218657_a("buildings", (INBT)buildingTagList);
        ListNBT fieldTagList = new ListNBT();
        for (BlockPos pos : this.fields) {
            CompoundNBT fieldCompound = new CompoundNBT();
            BlockPosUtil.write(fieldCompound, "pos", pos);
            fieldTagList.add((Object)fieldCompound);
        }
        compound.func_218657_a("newFields", (INBT)fieldTagList);
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.buildings.values().forEach(ISchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<ServerPlayerEntity> closeSubscribers, Set<ServerPlayerEntity> newSubscribers) {
        this.sendBuildingPackets(closeSubscribers, newSubscribers);
        this.sendFieldPackets(closeSubscribers, newSubscribers);
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        for (IBuilding building : this.buildings.values()) {
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), building.getPosition())) continue;
            building.onColonyTick(colony);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull IColony colony) {
        ArrayList<IBuilding> removedBuildings = new ArrayList<IBuilding>();
        ArrayList<IBuilding> tempBuildings = new ArrayList<IBuilding>(this.buildings.values());
        for (IBuilding building : tempBuildings) {
            BlockPos loc = building.getPosition();
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), loc) || building.isMatchingBlock(colony.getWorld().func_180495_p(loc).func_177230_c())) continue;
            removedBuildings.add(building);
        }
        ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.fields);
        for (BlockPos pos : tempFields) {
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), pos)) continue;
            if (colony.getWorld().func_175625_s(pos) instanceof ScarecrowTileEntity) {
                ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)colony.getWorld().func_175625_s(pos);
                if (scarecrow != null) continue;
                this.removeField(pos);
                continue;
            }
            this.removeField(pos);
        }
        if (!removedBuildings.isEmpty() && removedBuildings.size() >= this.buildings.values().size()) {
            Log.getLogger().warn("Colony:" + colony.getID() + " is removing all buildings at once. Did you just load a backup? If not there is a chance that colony data got corrupted and you want to restore a backup.");
        }
        removedBuildings.forEach(IBuilding::destroy);
    }

    @Override
    public IBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return this.buildings.get(buildingId);
        }
        return null;
    }

    @Override
    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos pos) {
        IWareHouse wareHouse = null;
        double dist = 0.0;
        for (IWareHouse building : this.wareHouses) {
            if (building.getBuildingLevel() <= 0 || building.getTileEntity() == null) continue;
            double tempDist = building.getPosition().func_177951_i((Vec3i)pos);
            if (wareHouse != null && !(tempDist < dist)) continue;
            dist = tempDist;
            wareHouse = building;
        }
        return wareHouse;
    }

    @Override
    public Map<BlockPos, IBuilding> getBuildings() {
        return Collections.unmodifiableMap(this.buildings);
    }

    @Override
    public ITownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public boolean hasWarehouse() {
        return !this.wareHouses.isEmpty();
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public List<BlockPos> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public void addNewField(AbstractScarecrowTileEntity tileEntity, BlockPos pos, World world) {
        this.addField(pos);
        this.markFieldsDirty();
    }

    @Override
    public <B extends IBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((IBuilding)type.cast(this.buildings.get(buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public ScarecrowTileEntity getFreeField(int owner, World world) {
        for (BlockPos pos : this.fields) {
            TileEntity field = world.func_175625_s(pos);
            if (!(field instanceof ScarecrowTileEntity) || ((ScarecrowTileEntity)field).isTaken()) continue;
            return (ScarecrowTileEntity)field;
        }
        return null;
    }

    @Override
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding tileEntity, World world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey(tileEntity.getPosition())) {
            IBuilding building = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                Log.getLogger().info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_195044_w().getClass(), tileEntity.getPosition()));
                building.setIsMirrored(tileEntity.isMirrored());
                if (!tileEntity.getStyle().isEmpty()) {
                    building.setStyle(tileEntity.getStyle());
                } else {
                    building.setStyle(this.colony.getStyle());
                }
                if (world != null && !(building instanceof IRSComponent)) {
                    building.onPlacement();
                    WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                    LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(world, building.getPosition(), workOrder.getStructureName(), new PlacementSettings(), true);
                    Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getPosition(), world, wrapper.getBluePrint(), workOrder.getRotation(world), workOrder.isMirrored());
                    building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
                    building.setHeight(wrapper.getBluePrint().getSizeY());
                    ConstructionTapeHelper.placeConstructionTape(building.getPosition(), corners, world);
                }
                ConstructionTapeHelper.placeConstructionTape(building.getPosition(), building.getCorners(), world);
                this.colony.getRequestManager().onProviderAddedToColony(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_195044_w().getClass(), tileEntity.getPosition()), (Throwable)new Exception());
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.colony.getPackageManager().updateSubscribers();
            return building;
        }
        return null;
    }

    public static int getRotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void removeBuilding(@NotNull IBuilding building, Set<ServerPlayerEntity> subscribers) {
        if (this.buildings.remove(building.getID()) != null) {
            for (ServerPlayerEntity player : subscribers) {
                Network.getNetwork().sendToPlayer(new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouses.remove(building);
        }
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
            building.cancelAllRequestsOfCitizen(citizen);
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        this.colony.getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public void removeField(BlockPos pos) {
        this.markFieldsDirty();
        this.fields.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public BlockPos getBestRestaurant(AbstractEntityCitizen citizen) {
        double distance = Double.MAX_VALUE;
        BlockPos goodCook = null;
        for (IBuilding building : citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values()) {
            double localDistance;
            if (!(building instanceof BuildingCook) || building.getBuildingLevel() <= 0 || !((localDistance = building.getPosition().func_177951_i((Vec3i)citizen.func_180425_c())) < distance)) continue;
            distance = localDistance;
            goodCook = building.getPosition();
        }
        return goodCook;
    }

    @Override
    public BlockPos getBestHospital(AbstractEntityCitizen citizen) {
        double distance = Double.MAX_VALUE;
        BlockPos goodHospital = null;
        for (IBuilding building : citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values()) {
            double localDistance;
            if (!(building instanceof BuildingHospital) || building.getBuildingLevel() <= 0 || !((localDistance = building.getPosition().func_177951_i((Vec3i)citizen.func_180425_c())) < distance)) continue;
            distance = localDistance;
            goodHospital = building.getPosition();
        }
        return goodHospital;
    }

    @Override
    public BlockPos getRandomBuilding(Predicate<IBuilding> filterPredicate) {
        ArrayList<IBuilding> allowedBuildings = new ArrayList<IBuilding>();
        for (IBuilding building : this.buildings.values()) {
            if (!filterPredicate.test(building)) continue;
            allowedBuildings.add(building);
        }
        if (allowedBuildings.isEmpty()) {
            return null;
        }
        Collections.shuffle(allowedBuildings);
        return ((IBuilding)allowedBuildings.get(0)).getPosition();
    }

    @Override
    public boolean hasGuardBuildingNear(IBuilding building) {
        if (building == null) {
            return true;
        }
        Chunk chunk = this.colony.getWorld().func_212866_a_(building.getPosition().func_177958_n() >> 4, building.getPosition().func_177952_p() >> 4);
        IColonyTagCapability closeCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (closeCap == null) {
            return false;
        }
        for (BlockPos buildingPos : closeCap.getAllClaimingBuildings().get(this.colony.getID())) {
            IBuilding guardbuilding = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (!(guardbuilding instanceof AbstractBuildingGuards) && !(guardbuilding instanceof BuildingBarracks)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void guardBuildingChangedAt(IBuilding guardBuilding, int newLevel) {
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (building.getPosition().func_177958_n() > guardBuilding.getPosition().func_177958_n() + 16 * guardBuilding.getClaimRadius(newLevel) || building.getPosition().func_177952_p() > guardBuilding.getPosition().func_177952_p() + 16 * guardBuilding.getClaimRadius(newLevel)) continue;
            if (newLevel > 0) {
                building.setGuardBuildingNear(true);
                continue;
            }
            building.setGuardBuildingNear(this.hasGuardBuildingNear(building));
        }
    }

    @Override
    public void setTownHall(@Nullable ITownHall building) {
        this.townHall = building;
    }

    @Override
    public List<IWareHouse> getWareHouses() {
        return this.wareHouses;
    }

    @Override
    public void removeWareHouse(IWareHouse wareHouse) {
        this.wareHouses.remove(wareHouse);
    }

    private void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    private void addBuilding(@NotNull IBuilding building) {
        this.buildings.put(building.getID(), building);
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (ITownHall)building;
        }
        if (building instanceof BuildingWareHouse) {
            this.wareHouses.add((IWareHouse)building);
        }
    }

    private void sendBuildingPackets(Set<ServerPlayerEntity> closeSubscribers, Set<ServerPlayerEntity> newSubscribers) {
        if (this.isBuildingsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isBuildingsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!building.isDirty() && newSubscribers.isEmpty()) continue;
                players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewBuildingViewMessage(building), (ServerPlayerEntity)player));
            }
        }
    }

    private void sendFieldPackets(Set<ServerPlayerEntity> closeSubscribers, Set<ServerPlayerEntity> newSubscribers) {
        if (this.isFieldsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isFieldsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingFarmer)) continue;
                players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewBuildingViewMessage(building), (ServerPlayerEntity)player));
            }
        }
    }

    private void addField(@NotNull BlockPos pos) {
        if (!this.fields.contains(pos)) {
            this.fields.add(pos);
        }
        this.colony.markDirty();
    }

    @Override
    public boolean canPlaceAt(Block block, BlockPos pos, PlayerEntity player) {
        if (block instanceof BlockHutWareHouse) {
            if (!(this.colony == null || ((Boolean)MineColonies.getConfig().getCommon().limitToOneWareHousePerColony.get()).booleanValue() && this.colony.hasWarehouse())) {
                return true;
            }
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.warehouse.limit", (Object[])new Object[0]);
            return false;
        }
        if (block instanceof BlockHutTownHall) {
            if (this.colony.hasTownHall()) {
                if (this.colony.getWorld() != null && !this.colony.getWorld().field_72995_K) {
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhuttownhall.messageplacedalready", (Object[])new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (block instanceof BlockHutTavern) {
            for (IBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingTavern)) continue;
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.tavern.limit", (Object[])new Object[0]);
                return false;
            }
        }
        return true;
    }
}

