/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.managers.EventManager;
import com.minecolonies.coremod.util.CreativeRaiderStructureHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EventStructureManager
implements IEventStructureManager {
    private static final String TAG_EVENT_STRUCTURE_MANAGER = "eventstructure_manager";
    public static final String STRUCTURE_BACKUP_FOLDER = "structbackup";
    private final Map<BlockPos, Integer> backupSchematics = new HashMap<BlockPos, Integer>();
    private final EventManager eventManager;
    private final IColony colony;

    public EventStructureManager(EventManager eventManager, IColony colony) {
        this.eventManager = eventManager;
        this.colony = colony;
    }

    @Override
    public boolean spawnTemporaryStructure(Blueprint structure, String schematicPath, BlockPos targetSpawnPoint, int eventID, int rotations, Mirror mirror) {
        TileEntity entity;
        CompoundNBT teData;
        if (this.eventManager.getEventByID(eventID) == null) {
            return false;
        }
        World world = this.colony.getWorld();
        int y = 3;
        BlockInfo info = structure.getBlockInfoAsMap().getOrDefault(structure.getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null && (teData = structure.getTileEntityData(targetSpawnPoint, structure.getPrimaryBlockOffset())) != null && teData.func_74764_b("blueprintDataProvider") && (entity = TileEntity.func_203403_c((CompoundNBT)info.getTileEntityData())) instanceof IBlueprintDataProvider) {
            for (Map.Entry entry : ((IBlueprintDataProvider)entity).getPositionedTags().entrySet()) {
                if (!((List)entry.getValue()).contains("groundlevel")) continue;
                y = ((BlockPos)entry.getKey()).func_177956_o();
            }
        }
        BlockPos spawnPos = targetSpawnPoint.func_177982_a(0, -y, 0);
        BlockPos zeroPos = targetSpawnPoint.func_177973_b((Vec3i)structure.getPrimaryBlockOffset()).func_177982_a(0, -y, 0);
        BlockPos cornerPos = new BlockPos(zeroPos.func_177958_n() + structure.getSizeX() - 1, zeroPos.func_177956_o() + structure.getSizeY(), zeroPos.func_177952_p() + structure.getSizeZ() - 1);
        BlockPos anchor = new BlockPos(zeroPos.func_177958_n() + structure.getSizeX() / 2, zeroPos.func_177956_o(), zeroPos.func_177952_p() + structure.getSizeZ() / 2);
        String backupPath = "schematicsstructbackup" + this.colony.getID() + this.colony.getDimension() + anchor;
        if (!ItemScanTool.saveStructureOnServer((World)world, (BlockPos)zeroPos, (BlockPos)cornerPos, (String)backupPath, (boolean)false)) {
            Log.getLogger().info("Failed to save schematics for event");
            return false;
        }
        this.backupSchematics.put(anchor, eventID);
        CreativeRaiderStructureHandler.loadAndPlaceStructureWithRotation(world, schematicPath, spawnPos, BlockPosUtil.getRotationFromRotations(rotations), mirror, true, this.colony.getID(), (IColonyRaidEvent)this.eventManager.getEventByID(eventID), null);
        return true;
    }

    @Override
    public void loadBackupForEvent(int eventID) {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.backupSchematics.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() != eventID) continue;
            String backupPath = String.valueOf(this.colony.getID()) + this.colony.getDimension() + entry.getKey();
            String fileName = new StructureName("cache", "backup", "schematicsstructbackup").toString() + backupPath;
            CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(this.colony.getWorld(), fileName, entry.getKey(), Rotation.NONE, Mirror.NONE, true, null);
            try {
                Structurize.proxy.getSchematicsFolder().toPath().resolve(fileName + ".blueprint").toFile().delete();
            }
            catch (Exception e) {
                Log.getLogger().info("Minor issue: Failed at deleteing a backup schematic at " + fileName, (Throwable)e);
            }
            iterator.remove();
        }
    }

    @Override
    public void readFromNBT(@NotNull CompoundNBT compound) {
        if (compound.func_74764_b(TAG_EVENT_STRUCTURE_MANAGER)) {
            this.backupSchematics.clear();
            CompoundNBT structureManagerCompound = compound.func_74775_l(TAG_EVENT_STRUCTURE_MANAGER);
            ListNBT schematicTags = structureManagerCompound.func_150295_c("ships", 10);
            for (INBT base : schematicTags) {
                CompoundNBT tagCompound = (CompoundNBT)base;
                BlockPos pos = BlockPosUtil.read(tagCompound, "pos");
                int eventID = tagCompound.func_74762_e("mc_event_id");
                if (this.eventManager.getEventByID(eventID) != null) {
                    this.backupSchematics.put(pos, eventID);
                    continue;
                }
                this.loadBackupForEvent(eventID);
                Log.getLogger().debug("Discarding schematic backup for event id:" + eventID + " seems the event went missing.");
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundNBT compound) {
        CompoundNBT structureManagerCompound = new CompoundNBT();
        ListNBT schematicTagList = new ListNBT();
        for (Map.Entry<BlockPos, Integer> entry : this.backupSchematics.entrySet()) {
            CompoundNBT entryCompound = new CompoundNBT();
            entryCompound.func_74768_a("mc_event_id", entry.getValue().intValue());
            BlockPosUtil.write(entryCompound, "pos", entry.getKey());
            schematicTagList.add((Object)entryCompound);
        }
        structureManagerCompound.func_218657_a("ships", (INBT)schematicTagList);
        compound.func_218657_a(TAG_EVENT_STRUCTURE_MANAGER, (INBT)structureManagerCompound);
    }
}

