/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.permissions;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Permissions
implements IPermissions {
    private static final String TAG_OWNERS = "owners";
    private static final String TAG_ID = "id";
    private static final String TAG_RANK = "rank";
    private static final String TAG_PERMISSIONS = "permissionMap";
    private static final String TAG_FLAGS = "flags";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_OWNER_ID = "ownerid";
    private static final String TAG_VERSION = "permissionVersion";
    @NotNull
    private static final Map<Rank, RankPair> promotionRanks = new EnumMap<Rank, RankPair>(Rank.class);
    @NotNull
    private final Colony colony;
    @NotNull
    private final Map<UUID, Player> players = new HashMap<UUID, Player>();
    @NotNull
    private final Map<Rank, Integer> permissionMap = new EnumMap<Rank, Integer>(Rank.class);
    private boolean dirty = false;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private static final int permissionsVersion = 2;

    public Permissions(@NotNull Colony colony) {
        this.permissionMap.put(Rank.OWNER, 0);
        this.setPermission(Rank.OWNER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OWNER, Action.PLACE_HUTS);
        this.setPermission(Rank.OWNER, Action.BREAK_HUTS);
        this.setPermission(Rank.OWNER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OWNER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OWNER, Action.SEND_MESSAGES);
        this.setPermission(Rank.OWNER, Action.EDIT_PERMISSIONS);
        this.setPermission(Rank.OWNER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OWNER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OWNER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OWNER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TOSS_ITEM);
        this.setPermission(Rank.OWNER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OWNER, Action.FILL_BUCKET);
        this.setPermission(Rank.OWNER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OWNER, Action.THROW_POTION);
        this.setPermission(Rank.OWNER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OWNER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OWNER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OWNER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TELEPORT_TO_COLONY);
        this.setPermission(Rank.OWNER, Action.RECEIVE_MESSAGES_FAR_AWAY);
        this.setPermission(Rank.OWNER, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY);
        this.setPermission(Rank.OWNER, Action.RALLY_GUARDS);
        this.permissionMap.put(Rank.OFFICER, 0);
        this.setPermission(Rank.OFFICER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OFFICER, Action.PLACE_HUTS);
        this.setPermission(Rank.OFFICER, Action.BREAK_HUTS);
        this.setPermission(Rank.OFFICER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OFFICER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OFFICER, Action.SEND_MESSAGES);
        this.setPermission(Rank.OFFICER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OFFICER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OFFICER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OFFICER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TOSS_ITEM);
        this.setPermission(Rank.OFFICER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OFFICER, Action.FILL_BUCKET);
        this.setPermission(Rank.OFFICER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.THROW_POTION);
        this.setPermission(Rank.OFFICER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OFFICER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OFFICER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TELEPORT_TO_COLONY);
        this.setPermission(Rank.OFFICER, Action.RECEIVE_MESSAGES_FAR_AWAY);
        this.setPermission(Rank.OFFICER, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY);
        this.setPermission(Rank.OFFICER, Action.RALLY_GUARDS);
        this.permissionMap.put(Rank.FRIEND, 0);
        this.setPermission(Rank.FRIEND, Action.ACCESS_HUTS);
        this.setPermission(Rank.FRIEND, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.FRIEND, Action.TOSS_ITEM);
        this.setPermission(Rank.FRIEND, Action.PICKUP_ITEM);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.THROW_POTION);
        this.setPermission(Rank.FRIEND, Action.SHOOT_ARROW);
        this.setPermission(Rank.FRIEND, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.FRIEND, Action.ATTACK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.FRIEND, Action.TELEPORT_TO_COLONY);
        this.permissionMap.put(Rank.NEUTRAL, 0);
        this.setPermission(Rank.NEUTRAL, Action.ACCESS_FREE_BLOCKS);
        this.permissionMap.put(Rank.HOSTILE, 0);
        this.setPermission(Rank.HOSTILE, Action.GUARDS_ATTACK);
        this.clearDirty();
        this.colony = colony;
    }

    @Override
    public final boolean setPermission(Rank rank, @NotNull Action action) {
        int flags = this.permissionMap.get((Object)rank);
        if (!Utils.testFlag(flags, action.getFlag())) {
            this.permissionMap.put(rank, Utils.setFlag(flags, action.getFlag()));
            this.markDirty();
            return true;
        }
        return false;
    }

    private void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.markDirty();
        }
    }

    private static void setPromotionRanks(Rank r, Rank p, Rank d) {
        promotionRanks.put(r, new RankPair(p, d));
    }

    public static Rank getPromotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).promote;
        }
        return rank;
    }

    public static Rank getDemotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).demote;
        }
        return rank;
    }

    @Override
    public void togglePermission(Rank rank, @NotNull Action action) {
        this.permissionMap.put(rank, Utils.toggleFlag(this.permissionMap.get((Object)rank), action.getFlag()));
        this.markDirty();
    }

    public void loadPermissions(@NotNull CompoundNBT compound) {
        this.players.clear();
        ListNBT ownerTagList = compound.func_150295_c(TAG_OWNERS, 10);
        for (int i = 0; i < ownerTagList.size(); ++i) {
            CompoundNBT ownerCompound = ownerTagList.func_150305_b(i);
            UUID id = UUID.fromString(ownerCompound.func_74779_i(TAG_ID));
            String name = "";
            if (ownerCompound.func_150296_c().contains("name")) {
                name = ownerCompound.func_74779_i("name");
            }
            Rank rank = Rank.valueOf(ownerCompound.func_74779_i(TAG_RANK));
            GameProfile player = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(id);
            if (player != null) {
                this.players.put(id, new Player(id, player.getName(), rank));
                continue;
            }
            if (name.isEmpty()) continue;
            this.players.put(id, new Player(id, name, rank));
        }
        if (compound.func_74762_e(TAG_VERSION) == 2) {
            this.permissionMap.clear();
            ListNBT permissionsTagList = compound.func_150295_c(TAG_PERMISSIONS, 10);
            for (int i = 0; i < permissionsTagList.size(); ++i) {
                CompoundNBT permissionsCompound = permissionsTagList.func_150305_b(i);
                Rank rank = Rank.valueOf(permissionsCompound.func_74779_i(TAG_RANK));
                ListNBT flagsTagList = permissionsCompound.func_150295_c(TAG_FLAGS, 8);
                int flags = 0;
                for (int j = 0; j < flagsTagList.size(); ++j) {
                    String flag = flagsTagList.func_150307_f(j);
                    flags = Utils.setFlag(flags, Action.valueOf(flag).getFlag());
                }
                this.permissionMap.put(rank, flags);
            }
            if (compound.func_150296_c().contains(TAG_OWNER)) {
                this.ownerName = compound.func_74779_i(TAG_OWNER);
            }
            if (compound.func_150296_c().contains(TAG_OWNER_ID)) {
                try {
                    this.ownerUUID = UUID.fromString(compound.func_74779_i(TAG_OWNER_ID));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this.restoreOwnerIfNull();
    }

    @Override
    public void restoreOwnerIfNull() {
        GameProfile player;
        Map.Entry<UUID, Player> owner = this.getOwnerEntry();
        if (owner == null && this.ownerUUID != null && (player = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(this.ownerUUID)) != null) {
            this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.getName(), Rank.OWNER));
        }
    }

    @Override
    @Nullable
    public Map.Entry<UUID, Player> getOwnerEntry() {
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            if (!entry.getValue().getRank().equals((Object)Rank.OWNER)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean setOwner(PlayerEntity player) {
        this.players.remove(this.getOwner());
        this.ownerName = player.func_200200_C_().func_150254_d();
        this.ownerUUID = player.func_110124_au();
        this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.func_200200_C_().func_150254_d(), Rank.OWNER));
        this.markDirty();
        return true;
    }

    @Override
    public void setOwnerAbandoned() {
        this.players.remove(this.getOwner());
        this.ownerName = "[abandoned]";
        this.ownerUUID = UUID.randomUUID();
        this.players.put(this.ownerUUID, new Player(this.ownerUUID, this.ownerName, Rank.OWNER));
        this.markDirty();
    }

    @Override
    @NotNull
    public UUID getOwner() {
        if (this.ownerUUID == null) {
            Map.Entry<UUID, Player> owner = this.getOwnerEntry();
            if (owner != null) {
                this.ownerUUID = owner.getKey();
            } else {
                this.restoreOwnerIfNull();
            }
        }
        return this.ownerUUID;
    }

    public void savePermissions(@NotNull CompoundNBT compound) {
        ListNBT ownerTagList = new ListNBT();
        for (Player player : this.players.values()) {
            CompoundNBT ownersCompound = new CompoundNBT();
            ownersCompound.func_74778_a(TAG_ID, player.getID().toString());
            ownersCompound.func_74778_a("name", player.getName());
            ownersCompound.func_74778_a(TAG_RANK, player.getRank().name());
            ownerTagList.add((Object)ownersCompound);
        }
        compound.func_218657_a(TAG_OWNERS, (INBT)ownerTagList);
        ListNBT permissionsTagList = new ListNBT();
        for (Map.Entry<Rank, Integer> entry : this.permissionMap.entrySet()) {
            CompoundNBT permissionsCompound = new CompoundNBT();
            permissionsCompound.func_74778_a(TAG_RANK, entry.getKey().name());
            ListNBT flagsTagList = new ListNBT();
            for (Action action : Action.values()) {
                if (!Utils.testFlag(entry.getValue(), action.getFlag())) continue;
                flagsTagList.add((Object)StringNBT.func_229705_a_((String)action.name()));
            }
            permissionsCompound.func_218657_a(TAG_FLAGS, (INBT)flagsTagList);
            permissionsTagList.add((Object)permissionsCompound);
        }
        compound.func_218657_a(TAG_PERMISSIONS, (INBT)permissionsTagList);
        if (!this.ownerName.isEmpty()) {
            compound.func_74778_a(TAG_OWNER, this.ownerName);
        }
        if (this.ownerUUID != null) {
            compound.func_74778_a(TAG_OWNER_ID, this.ownerUUID.toString());
        }
        compound.func_74768_a(TAG_VERSION, 2);
    }

    @Override
    @NotNull
    public Map<UUID, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    @Override
    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return rank == Rank.OWNER && action != Action.GUARDS_ATTACK || Utils.testFlag(this.permissionMap.get((Object)rank), action.getFlag());
    }

    @Override
    public Set<Player> getPlayersByRank(Rank rank) {
        return this.players.values().stream().filter(player -> player.getRank().equals((Object)rank)).collect(Collectors.toSet());
    }

    @Override
    public Set<Player> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return this.players.values().stream().filter(player -> ranks.contains((Object)player.getRank())).collect(Collectors.toSet());
    }

    @NotNull
    public Map<Rank, Integer> getPermissionMap() {
        return this.permissionMap;
    }

    @Override
    public boolean hasPermission(@NotNull PlayerEntity player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    @NotNull
    public Rank getRank(@NotNull PlayerEntity player) {
        return this.getRank(player.func_146103_bH().getId());
    }

    @Override
    public boolean removePermission(Rank rank, @NotNull Action action) {
        int flags = this.permissionMap.get((Object)rank);
        if (Utils.testFlag(flags, action.getFlag())) {
            this.permissionMap.put(rank, Utils.unsetFlag(flags, action.getFlag()));
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean setPlayerRank(UUID id, Rank rank, World world) {
        Player player = this.getPlayers().get(id);
        if (player == null) {
            GameProfile gameprofile = world.func_73046_m().func_152358_ax().func_152652_a(id);
            return gameprofile != null && this.addPlayer(gameprofile, rank);
        }
        player.setRank(rank);
        this.markDirty();
        return true;
    }

    @Override
    public boolean addPlayer(@NotNull UUID id, String name, Rank rank) {
        Player p = new Player(id, name, rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        this.markDirty();
        return true;
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        Player player = this.players.get(id);
        return player != null ? player.getRank() : Rank.NEUTRAL;
    }

    @Override
    public boolean addPlayer(@NotNull String player, Rank rank, World world) {
        ServerPlayerEntity playerEntity;
        if (player.isEmpty()) {
            return false;
        }
        GameProfile gameprofile = world.func_73046_m().func_152358_ax().func_152655_a(player);
        if (!world.func_201670_d() && gameprofile != null && (playerEntity = (ServerPlayerEntity)world.func_217371_b(gameprofile.getId())) != null) {
            if (rank == Rank.OFFICER) {
                this.colony.getPackageManager().addImportantColonyPlayer(playerEntity);
                this.colony.getPackageManager().updateSubscribers();
            } else {
                Chunk chunk = world.func_212866_a_(playerEntity.field_70176_ah, playerEntity.field_70164_aj);
                IColonyTagCapability colonyCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (colonyCap != null && colonyCap.getOwningColony() == this.colony.getID() && world.func_201675_m().func_186058_p().func_186068_a() == this.colony.getDimension()) {
                    this.colony.getPackageManager().addCloseSubscriber(playerEntity);
                    this.colony.getPackageManager().updateSubscribers();
                }
            }
        }
        return gameprofile != null && !this.ownerUUID.equals(gameprofile.getId()) && this.addPlayer(gameprofile, rank);
    }

    @Override
    public boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        Player p = new Player(gameprofile.getId(), gameprofile.getName(), rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        this.markDirty();
        return true;
    }

    @Override
    public boolean removePlayer(UUID id) {
        Player player = this.players.get(id);
        if (player != null && player.getRank() != Rank.OWNER && this.players.remove(id) != null) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        Map.Entry<UUID, Player> owner;
        if (this.ownerName.isEmpty() && (owner = this.getOwnerEntry()) != null) {
            this.ownerName = owner.getValue().getName();
        }
        return this.ownerName;
    }

    @Override
    public boolean isSubscriber(@NotNull PlayerEntity player) {
        return this.isSubscriber(player.func_146103_bH().getId());
    }

    private boolean isSubscriber(UUID player) {
        return this.getRank((UUID)player).isSubscriber;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void serializeViewNetworkData(@NotNull PacketBuffer buf, @NotNull Rank viewerRank) {
        buf.func_180714_a(viewerRank.name());
        buf.writeInt(this.players.size());
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            PacketUtils.writeUUID(buf, entry.getKey());
            buf.func_180714_a(entry.getValue().getName());
            buf.func_180714_a(entry.getValue().getRank().name());
        }
        buf.writeInt(this.permissionMap.size());
        for (Map.Entry<Object, Object> entry : this.permissionMap.entrySet()) {
            buf.func_180714_a(((Rank)((Object)entry.getKey())).name());
            buf.writeInt(((Integer)entry.getValue()).intValue());
        }
    }

    @Override
    public boolean isColonyMember(@NotNull PlayerEntity player) {
        return this.players.containsKey(player.func_146103_bH().getId());
    }

    static {
        Permissions.setPromotionRanks(Rank.OFFICER, Rank.OFFICER, Rank.FRIEND);
        Permissions.setPromotionRanks(Rank.FRIEND, Rank.OFFICER, Rank.NEUTRAL);
        Permissions.setPromotionRanks(Rank.NEUTRAL, Rank.FRIEND, Rank.HOSTILE);
        Permissions.setPromotionRanks(Rank.HOSTILE, Rank.NEUTRAL, Rank.HOSTILE);
    }

    private static class RankPair {
        private final Rank promote;
        private final Rank demote;

        RankPair(Rank p, Rank d) {
            this.promote = p;
            this.demote = d;
        }
    }
}

