/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.NBTUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.jetbrains.annotations.NotNull;

public class StandardRecipeManager
implements IRecipeManager {
    private static final String TAG_RECIPES = "recipes";
    private final BiMap<IToken<?>, IRecipeStorage> recipes = HashBiMap.create();
    private ImmutableMap<IToken<?>, IRecipeStorage> cache = null;
    private final Set<IToken<?>> usedRecipes = new HashSet();

    @Override
    public ImmutableMap<IToken<?>, IRecipeStorage> getRecipes() {
        if (this.cache == null) {
            this.cache = ImmutableMap.copyOf(this.recipes);
        }
        return this.cache;
    }

    @Override
    public IToken<?> addRecipe(IRecipeStorage storage) {
        this.recipes.put(storage.getToken(), (Object)storage);
        this.usedRecipes.add(storage.getToken());
        this.cache = null;
        return storage.getToken();
    }

    @Override
    public IToken<?> checkOrAddRecipe(IRecipeStorage storage) {
        IToken<?> token = this.getRecipeId(storage);
        if (token == null) {
            return this.addRecipe(storage);
        }
        this.usedRecipes.add(token);
        return token;
    }

    @Override
    public IToken<?> getRecipeId(IRecipeStorage storage) {
        for (Map.Entry tempStorage : this.recipes.entrySet()) {
            if (!((IRecipeStorage)tempStorage.getValue()).equals(storage)) continue;
            return (IToken)tempStorage.getKey();
        }
        return null;
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        ListNBT recipesTagList = this.recipes.entrySet().stream().filter(recipeEntry -> this.usedRecipes.contains(recipeEntry.getKey())).map(entry -> StandardFactoryController.getInstance().serialize(entry.getValue())).collect(NBTUtils.toListNBT());
        compound.func_218657_a(TAG_RECIPES, (INBT)recipesTagList);
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        ListNBT list = compound.func_150295_c(TAG_RECIPES, 10);
        for (int i = 0; i < list.size(); ++i) {
            IRecipeStorage recipe = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(list.func_150305_b(i));
            if (recipe == null) continue;
            this.recipes.put(recipe.getToken(), (Object)recipe);
        }
        this.cache = null;
    }

    @Override
    public void reset() {
        this.recipes.clear();
        this.usedRecipes.clear();
    }

    @Override
    public void registerUse(IToken<?> token) {
        this.usedRecipes.add(token);
    }
}

