/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class CommandColonyInfo
implements IMCCommand {
    private static final String ID_TEXT = "ID: ";
    private static final String NAME_TEXT = "Name: ";
    private static final String MAYOR_TEXT = "Mayor: ";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String CITIZENS = "Citizens: ";
    private static final String LAST_CONTACT_TEXT = "Last contact with Owner or Officer: %d hours ago!";
    private static final String IS_DELETABLE = "If true this colony cannot be deleted: ";
    private static final String CANNOT_BE_RAIDED = "This colony is unable to be raided";

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, ((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p().func_186068_a());
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSource)context.getSource()).func_197034_c(4) && !((Boolean)MineColonies.getConfig().getCommon().canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return 0;
        }
        BlockPos position = colony.getCenter();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()), true);
        String mayor = colony.getPermissions().getOwnerName();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(MAYOR_TEXT + mayor), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(CITIZENS + colony.getCitizenManager().getCitizens().size() + "/" + colony.getCitizenManager().getMaxCitizens()), true);
        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(String.format(LAST_CONTACT_TEXT, colony.getLastContactInHours())), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(IS_DELETABLE + !colony.canBeAutoDeleted()), true);
        if (!colony.getRaiderManager().canHaveRaiderEvents()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(CANNOT_BE_RAIDED), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

