/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;

public class CommandRTP
implements IMCCommand {
    private static final int STARTING_Y = 250;
    private static final double SAFETY_DROP = 6.0;
    private static final int FALL_DISTANCE = 5;

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        this.rtp((PlayerEntity)((CommandSource)context.getSource()).func_197022_f());
        return 1;
    }

    private int executeOtherPlayerRTP(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!this.checkPreCondition(context) || !IMCCommand.isPlayerOped((PlayerEntity)sender)) {
            return 0;
        }
        GameProfile profile = GameProfileArgument.func_197109_a(context, (String)"playername").stream().findFirst().orElse(null);
        if (profile == null || ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_177451_a(profile.getId()) == null) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.playernotfound", (Object[])new Object[]{profile != null ? profile.getName() : "null"});
            return 0;
        }
        this.rtp((PlayerEntity)((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_177451_a(profile.getId()));
        return 1;
    }

    @Override
    public boolean checkPreCondition(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!(sender instanceof PlayerEntity)) {
            return false;
        }
        if (!((Boolean)MineColonies.getConfig().getCommon().canPlayerUseRTPCommand.get()).booleanValue()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.rtp.notallowed", (Object[])new Object[0]);
            return false;
        }
        if (((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p().func_186068_a() != 0) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.rtp.wrongdim", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private void rtp(PlayerEntity player) {
        for (int attCounter = 0; attCounter <= (Integer)MineColonies.getConfig().getCommon().numberOfAttemptsForSafeTP.get(); ++attCounter) {
            BlockPos groundPosition;
            int x = CommandRTP.getRandCoordinate();
            int z = CommandRTP.getRandCoordinate();
            if ((long)player.func_130014_f_().func_175723_af().func_177722_l() < BlockPosUtil.getDistance2D(player.func_130014_f_().func_175694_M(), player.func_130014_f_().func_175694_M().func_177982_a(x, 0, z))) continue;
            BlockPos tpPos = new BlockPos(x, 250, z);
            IColony colony = IColonyManager.getInstance().getClosestColony(player.func_130014_f_(), tpPos);
            if (colony != null && BlockPosUtil.getDistance2D(colony.getCenter(), tpPos) < (long)((Integer)MineColonies.getConfig().getCommon().maxColonySize.get() * 32) || (groundPosition = BlockPosUtil.findLand(tpPos, player.func_130014_f_())) == null || !BlockPosUtil.isPositionSafe(player.func_130014_f_(), groundPosition.func_177977_b())) continue;
            player.func_70606_j(player.func_110138_aP());
            player.func_70634_a((double)groundPosition.func_177958_n(), (double)groundPosition.func_177956_o() + 6.0, (double)groundPosition.func_177952_p());
            player.func_70606_j(player.func_110138_aP());
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.command.rtp.success", (Object[])new Object[0]);
            player.field_70143_R = -5.0f;
            return;
        }
        LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.command.rtp.nopositionfound", (Object[])new Object[0]);
    }

    private static int getRandCoordinate() {
        Random rnd = new Random();
        int x = 0;
        while (x > -((Integer)MineColonies.getConfig().getCommon().minDistanceFromWorldSpawn.get()).intValue() && x < (Integer)MineColonies.getConfig().getCommon().minDistanceFromWorldSpawn.get()) {
            x = rnd.nextInt((Integer)MineColonies.getConfig().getCommon().maxDistanceFromWorldSpawn.get() * 2) - (Integer)MineColonies.getConfig().getCommon().maxDistanceFromWorldSpawn.get();
        }
        return x;
    }

    @Override
    public String getName() {
        return "rtp";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("playername", GameProfileArgument.func_197108_a()).executes(this::executeOtherPlayerRTP))).executes(this::checkPreConditionAndExecute);
    }
}

