/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter<?, J>, B extends AbstractBuildingWorker>
extends AbstractEntityAIInteract<J, B> {
    protected static final int HIT_DELAY = 10;
    public static final int PROGRESS_MULTIPLIER = 10;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    public IRequest<? extends PublicCrafting> currentRequest;
    protected IRecipeStorage currentRecipeStorage;

    protected int getActionRewardForCraftingSuccess() {
        return 1;
    }

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IAIState)AIWorkerState.QUERY_ITEMS, this::queryItems, 5), new AITarget((IAIState)AIWorkerState.GET_RECIPE, this::getRecipe, 5), new AITarget((IAIState)AIWorkerState.CRAFT, this::craft, 10));
        this.worker.func_98053_h(true);
    }

    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    protected IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        Object buildingWorker = this.getOwnBuilding();
        this.currentRecipeStorage = buildingWorker.getFirstFullFillableRecipe(stack -> stack.func_77969_a(((PublicCrafting)currentTask.getRequest()).getStack()), 1, false);
        if (this.currentRecipeStorage == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = currentTask;
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(this.currentRequest.getRequest().getCount());
        int currentCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack.func_77969_a(this.currentRecipeStorage.getPrimaryOutput()));
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().func_190916_E();
        int doneOpsCount = currentCount / countPerIteration;
        int progressOpsCount = inProgressCount / countPerIteration;
        int remainingOpsCount = this.currentRequest.getRequest().getCount() - doneOpsCount - progressOpsCount;
        List<ItemStorage> input = this.currentRecipeStorage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * remainingOpsCount);
            if (InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> itemStack.func_77969_a(inputStorage.getItemStack())) + InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.func_77969_a(inputStorage.getItemStack())) + this.getExtendedCount(inputStorage.getItemStack()) >= remaining) continue;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setCraftCounter(doneOpsCount);
        return AIWorkerState.QUERY_ITEMS;
    }

    protected int getExtendedCount(ItemStack stack) {
        return 0;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().func_190916_E();
        int progressOpsCount = inProgressCount / countPerIteration;
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(inputStorage.getItemStack());
            int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate);
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * ((AbstractJobCrafter)this.job).getMaxCraftingCount());
            if (invCount > 0 && invCount + (((AbstractJobCrafter)this.job).getCraftCounter() + progressOpsCount) * inputStorage.getAmount() >= remaining) continue;
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, remaining);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((AbstractJobCrafter)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() + 1);
        this.worker.func_184611_a(Hand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.getRandom().nextInt(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().func_77946_l());
        this.worker.func_184611_a(Hand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().func_77946_l());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition());
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getProgress() < this.getRequiredProgressForMakingRawMaterial()) return this.getState();
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (check != AIWorkerState.CRAFT) {
            this.currentRequest = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        if (!this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen())) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
        ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + 1);
        if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            ((AbstractBuildingWorker)this.getOwnBuilding()).improveRecipe(this.currentRecipeStorage, ((AbstractJobCrafter)this.job).getCraftCounter(), this.worker.getCitizenData());
            this.currentRecipeStorage = null;
            this.resetValues();
            if (!this.inventoryNeedsDump()) return AIWorkerState.START_WORKING;
            if (((AbstractJobCrafter)this.job).getMaxCraftingCount() != 0) return AIWorkerState.START_WORKING;
            if (((AbstractJobCrafter)this.job).getProgress() != 0) return AIWorkerState.START_WORKING;
            if (((AbstractJobCrafter)this.job).getCraftCounter() != 0) return AIWorkerState.START_WORKING;
            if (this.currentRequest == null) return AIWorkerState.START_WORKING;
            ((AbstractJobCrafter)this.job).finishRequest(true);
            this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setProgress(0);
        return AIWorkerState.GET_RECIPE;
    }

    public void resetValues() {
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(0);
        ((AbstractJobCrafter)this.job).setProgress(0);
        ((AbstractJobCrafter)this.job).setCraftCounter(0);
        this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
        this.worker.func_184611_a(Hand.OFF_HAND, ItemStackUtils.EMPTY);
    }

    @Override
    public IAIState afterDump() {
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
            if (this.currentRequest.getState() == RequestState.IN_PROGRESS) {
                ((AbstractJobCrafter)this.job).finishRequest(true);
            }
            this.currentRequest = null;
        }
        this.resetValues();
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        int jobModifier = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((IBuildingPublicCrafter)this.getOwnBuilding()).getCraftSpeedSkill()) / 2;
        return 10 / Math.min(jobModifier + 1, 50) * 3;
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return this.currentRequest == null;
    }
}

