/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.BlueprintIterator;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIInteract<J, B> {
    protected Tuple<StructurePlacer, BuildingStructureHandler<J, B>> structurePlacer;
    protected TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> DONT_TOUCH_PREDICATE = (info, worldPos, handler) -> {
        BlockState worldState = handler.getWorld().func_180495_p(worldPos);
        return worldState.func_177230_c() instanceof IBuilderUndestroyable || worldState.func_177230_c() == Blocks.field_150357_h || info.getBlockInfo().getState().func_177230_c() instanceof AbstractBlockHut && handler.getWorldPos().equals(worldPos);
    };
    protected BlockPos workFrom;
    private BlockPos blockToMine;

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget((IAIState)AIWorkerState.PICK_UP_RESIDUALS, this::pickUpResiduals, 20), new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::checkIfCanceled, AIWorkerState.IDLE, 1), new AITarget((IAIState)AIWorkerState.LOAD_STRUCTURE, this::loadRequirements, 5), new AITarget((IAIState)AIWorkerState.START_BUILDING, this::startBuilding, 1), new AITarget((IAIState)AIWorkerState.MINE_BLOCK, this::doMining, 10), new AITarget(AIWorkerState.IDLE, this::isThereAStructureToBuild, () -> AIWorkerState.START_BUILDING, 100), new AITarget((IAIState)AIWorkerState.BUILDING_STEP, this::structureStep, 5), new AITarget((IAIState)AIWorkerState.COMPLETE_BUILD, this::completeBuild, 5));
    }

    protected IAIState pickUpResiduals() {
        if (this.structurePlacer != null && this.structurePlacer.getB().getStage() != null) {
            return AIWorkerState.IDLE;
        }
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        this.workFrom = null;
        this.structurePlacer = null;
        return AIWorkerState.IDLE;
    }

    protected IAIState completeBuild() {
        this.incrementActionsDoneAndDecSaturation();
        this.executeSpecificCompleteActions();
        this.worker.getCitizenExperienceHandler().addExperience(8.0);
        return AIWorkerState.PICK_UP_RESIDUALS;
    }

    @NotNull
    protected IAIState startBuilding() {
        if (this.structurePlacer == null || !this.structurePlacer.getB().hasBluePrint()) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.BUILDING_STEP;
    }

    public IAIState afterStructureLoading() {
        return AIWorkerState.START_BUILDING;
    }

    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(currentBlock);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) < 12.0;
    }

    protected static boolean isDecoItem(Block block) {
        return ModTags.decorationItems.func_199685_a_((Object)block);
    }

    protected IAIState structureStep() {
        StructurePhasePlacementResult result;
        if (this.structurePlacer.getB().getStage() == null) {
            return AIWorkerState.PICK_UP_RESIDUALS;
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.building", new Object[0])});
        this.checkForExtraBuildingActions();
        BlockPos progress = this.getProgressPos() == null ? BlueprintIterator.NULL_POS : this.getProgressPos().getA();
        BlockPos worldPos = this.structurePlacer.getB().getProgressPosInWorld(progress);
        if (this.getProgressPos() != null) {
            this.structurePlacer.getB().setStage(this.getProgressPos().getB());
        }
        if (!this.walkToConstructionSite(worldPos)) {
            return this.getState();
        }
        StructurePlacer placer = this.structurePlacer.getA();
        switch (this.structurePlacer.getB().getStage()) {
            case BUILD_SOLID: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !info.getBlockInfo().getState().func_185904_a().func_76220_a() || AbstractEntityAIStructure.isDecoItem(info.getBlockInfo().getState().func_177230_c()))), false);
                break;
            }
            case CLEAR_WATER: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.WATER_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().func_180495_p(pos).func_204520_s().func_206888_e()), false);
                break;
            }
            case CLEAR_NON_SOLIDS: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !(info.getBlockInfo().getState().func_177230_c() instanceof AirBlock))), false);
                break;
            }
            case DECORATE: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getBlockInfo().getState().func_185904_a().func_76220_a() && !AbstractEntityAIStructure.isDecoItem(info.getBlockInfo().getState().func_177230_c()))), false);
                break;
            }
            case SPAWN: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                break;
            }
            case REMOVE_WATER: {
                placer.getIterator().setRemoving();
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.WATER_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> info.getBlockInfo().getState().func_204520_s().func_206888_e()), false);
                break;
            }
            case REMOVE: {
                placer.getIterator().setRemoving();
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().func_180495_p(pos).func_177230_c() instanceof AirBlock || info.getBlockInfo().getState().func_177230_c() instanceof AirBlock || !handler.getWorld().func_180495_p(pos).func_204520_s().func_206888_e() || info.getBlockInfo().getState().func_177230_c() == com.ldtteam.structurize.blocks.ModBlocks.blockSolidSubstitution || info.getBlockInfo().getState().func_177230_c() == com.ldtteam.structurize.blocks.ModBlocks.blockSubstitution || handler.getWorld().func_180495_p(pos).func_177230_c() instanceof IBuilderUndestroyable), true);
                break;
            }
            default: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().func_180495_p(pos).func_177230_c() instanceof IBuilderUndestroyable || handler.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150357_h || handler.getWorld().func_180495_p(pos).func_177230_c() instanceof AirBlock || !handler.getWorld().func_180495_p(pos).func_204520_s().func_206888_e()), false);
            }
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).nextStage();
            if (!this.structurePlacer.getB().nextStage()) {
                ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(null, null);
                return AIWorkerState.COMPLETE_BUILD;
            }
        }
        this.storeProgressPos(result.getIteratorPos(), this.structurePlacer.getB().getStage());
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.MISSING_ITEMS) {
            if (AbstractEntityAIStructure.hasListOfResInInvOrRequest(this, result.getBlockResult().getRequiredItems(), result.getBlockResult().getRequiredItems().size() > 1) == ItemCheckResult.RECALC) {
                ((AbstractJobStructure)this.job).getWorkOrder().setRequested(false);
                return AIWorkerState.LOAD_STRUCTURE;
            }
            return AIWorkerState.NEEDS_ITEM;
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.BREAK_BLOCK) {
            this.blockToMine = result.getBlockResult().getWorldPos();
            return AIWorkerState.MINE_BLOCK;
        }
        if ((Integer)MineColonies.getConfig().getCommon().builderBuildBlockDelay.get() > 0) {
            double decrease = 1.0;
            MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Block Place Speed", MultiplierModifierResearchEffect.class);
            if (effect != null) {
                decrease = 1.0 - effect.getEffect();
            }
            this.setDelay((int)((double)((Integer)MineColonies.getConfig().getCommon().builderBuildBlockDelay.get() * 10 / (this.getPlaceSpeedLevel() / 2 + 10)) * decrease));
        }
        return this.getState();
    }

    public abstract int getPlaceSpeedLevel();

    private IAIState doMining() {
        if (this.blockToMine == null || this.world.func_180495_p(this.blockToMine).func_177230_c() instanceof AirBlock) {
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.func_184609_a(Hand.MAIN_HAND);
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.BUILDING_STEP;
    }

    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        BuildingStructureHandler structure;
        IBuilding colonyBuilding = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(position);
        TileEntity entity = this.world.func_175625_s(position);
        if (removal) {
            structure = new BuildingStructureHandler(this.world, position, name, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.REMOVE_WATER, BuildingStructureHandler.Stage.REMOVE});
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setTotalStages(2);
        } else if (colonyBuilding != null && colonyBuilding.getBuildingLevel() > 0 || entity instanceof TileEntityDecorationController && ((TileEntityDecorationController)entity).getLevel() > 0) {
            structure = new BuildingStructureHandler(this.world, position, name, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.CLEAR_WATER, BuildingStructureHandler.Stage.CLEAR_NON_SOLIDS, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.SPAWN});
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setTotalStages(5);
        } else {
            structure = new BuildingStructureHandler(this.world, position, name, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.CLEAR, BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.CLEAR_WATER, BuildingStructureHandler.Stage.CLEAR_NON_SOLIDS, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.SPAWN});
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setTotalStages(6);
        }
        if (!structure.hasBluePrint()) {
            this.handleSpecificCancelActions();
            Log.getLogger().warn("Couldn't find structure with name: " + name + " aborting loading procedure");
            return;
        }
        ((AbstractJobStructure)this.job).setBlueprint(structure.getBluePrint());
        ((AbstractJobStructure)this.job).getBlueprint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotateTimes), isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, this.world);
        this.structurePlacer = new Tuple(new StructurePlacer(structure), structure);
        if (this.getProgressPos() != null) {
            structure.setStage(this.getProgressPos().getB());
        }
    }

    public static <J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder> ItemCheckResult hasListOfResInInvOrRequest(@NotNull AbstractEntityAIStructure<J, B> placer, List<ItemStack> itemList, boolean force) {
        for (ItemStack itemStack2 : itemList) {
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)placer.getInventory(), stack1 -> itemStack2.func_77969_a(stack1)) || ((AbstractBuildingStructureBuilder)placer.getOwnBuilding()).hasResourceInBucket(itemStack2)) continue;
            return ItemCheckResult.RECALC;
        }
        List<ItemStack> foundStacks = InventoryUtils.filterItemHandler((IItemHandler)placer.getWorker().getInventoryCitizen(), itemStack -> itemList.stream().anyMatch(targetStack -> targetStack.func_77969_a(itemStack)));
        if (force) {
            for (ItemStack foundStack : new ArrayList<ItemStack>(foundStacks)) {
                Optional<ItemStack> opt = itemList.stream().filter(targetStack -> targetStack.func_77969_a(foundStack)).findFirst();
                if (!opt.isPresent()) continue;
                ItemStack stack = opt.get();
                itemList.remove(stack);
                if (stack.func_190916_E() <= foundStack.func_190916_E()) continue;
                stack.func_190920_e(stack.func_190916_E() - foundStack.func_190916_E());
                itemList.add(stack);
            }
        } else {
            itemList.removeIf(itemStack -> ItemStackUtils.isEmpty(itemStack) != false || foundStacks.stream().anyMatch(target -> target.func_77969_a(itemStack)));
        }
        itemList.removeIf(itemstack -> itemstack.func_77973_b() instanceof BlockItem && AbstractEntityAIStructure.isBlockFree(((BlockItem)itemstack.func_77973_b()).func_179223_d()));
        HashMap<ItemStorage, Integer> hashMap = new HashMap<ItemStorage, Integer>();
        for (ItemStack stack : itemList) {
            ItemStorage tempStorage = new ItemStorage(stack.func_77946_l());
            if (hashMap.containsKey(tempStorage)) {
                int oldSize = (Integer)hashMap.get(tempStorage);
                tempStorage.setAmount(tempStorage.getAmount() + oldSize);
            }
            hashMap.put(tempStorage, tempStorage.getAmount());
        }
        Iterator<Object> iterator = hashMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry placedStack = (Map.Entry)iterator.next();
            if (ItemStackUtils.isEmpty(((ItemStorage)placedStack.getKey()).getItemStack()).booleanValue()) {
                return ItemCheckResult.FAIL;
            }
            ImmutableList requests = ((AbstractBuildingStructureBuilder)placer.getOwnBuilding()).getOpenRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(((ItemStorage)placedStack.getKey()).getItemStack()));
            ImmutableList completedRequests = ((AbstractBuildingStructureBuilder)placer.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(((ItemStorage)placedStack.getKey()).getItemStack()));
            if (requests.isEmpty() && completedRequests.isEmpty()) {
                Stack stackRequest = new Stack(((ItemStorage)placedStack.getKey()).getItemStack(), (Integer)placedStack.getValue(), 1);
                placer.getWorker().getCitizenData().createRequest(stackRequest);
                placer.registerBlockAsNeeded(((ItemStorage)placedStack.getKey()).getItemStack());
                return ItemCheckResult.FAIL;
            }
            for (IRequest request : requests) {
                if (!placer.worker.getCitizenJobHandler().getColonyJob().getAsyncRequests().contains(request.getId())) continue;
                placer.worker.getCitizenJobHandler().getColonyJob().markRequestSync((IToken<?>)request.getId());
            }
            for (IRequest request : completedRequests) {
                if (!placer.worker.getCitizenJobHandler().getColonyJob().getAsyncRequests().contains(request.getId())) continue;
                placer.worker.getCitizenJobHandler().getColonyJob().markRequestSync((IToken<?>)request.getId());
            }
            return ItemCheckResult.FAIL;
        }
        return ItemCheckResult.SUCCESS;
    }

    public IAIState loadRequirements() {
        return AIWorkerState.START_WORKING;
    }

    public boolean requestMaterials() {
        return true;
    }

    public void registerBlockAsNeeded(ItemStack stack) {
    }

    public void storeProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
    }

    @Override
    public void fillItemsList() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (!this.structurePlacer.getB().hasBluePrint()) {
            return;
        }
        Blueprint blueprint = this.structurePlacer.getB().getBluePrint();
        BlockPos leftCorner = this.structurePlacer.getB().getWorldPos().func_177973_b((Vec3i)blueprint.getPrimaryBlockOffset());
        this.searchForItems(new AxisAlignedBB(leftCorner, leftCorner.func_177982_a((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ())));
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        short length = this.structurePlacer.getB().getBluePrint().getSizeX();
        short width = this.structurePlacer.getB().getBluePrint().getSizeZ();
        int distance = Math.max(width, length) + 3;
        return this.getWorkingPosition(distance, targetPosition, 0);
    }

    public static boolean isBlockFree(@Nullable Block block) {
        return block == null || BlockUtils.isWater((BlockState)block.func_176223_P()) || block.func_203417_a(BlockTags.field_206952_E) || block == ModBlocks.blockDecorationPlaceholder;
    }

    protected boolean isAlreadyCleared() {
        return false;
    }

    private BlockPos getCurrentWorkingPosition() {
        return this.workFrom == null ? this.getWorkingPosition(this.structurePlacer.getB().getProgressPosInWorld(this.structurePlacer.getA().getIterator().getProgressPos())) : this.workFrom;
    }

    protected boolean isThereAStructureToBuild() {
        if (this.structurePlacer == null || !this.structurePlacer.getB().hasBluePrint()) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.waitingForBuild", new Object[0])});
            return false;
        }
        return true;
    }

    public void reduceNeededResources(ItemStack stack) {
    }

    public void checkForExtraBuildingActions() {
    }

    public void handleSpecificCancelActions() {
    }

    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        return stack;
    }

    public void resetCurrentStructure() {
        this.workFrom = null;
        this.structurePlacer = null;
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(null, null);
    }

    public AbstractEntityCitizen getWorker() {
        return this.worker;
    }

    public abstract Tuple<BlockPos, BuildingStructureHandler.Stage> getProgressPos();

    public abstract boolean shallReplaceSolidSubstitutionBlock(Block var1, BlockState var2);

    public abstract BlockState getSolidSubstitution(BlockPos var1);

    protected abstract void executeSpecificCompleteActions();

    protected abstract boolean checkIfCanceled();

    public static enum ItemCheckResult {
        FAIL,
        SUCCESS,
        RECALC;

    }
}

