/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.decorative.BlockConstructionTape;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.util.ColonyUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;

public final class ConstructionTapeHelper {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty CORNER = BooleanProperty.func_177716_a((String)"corner");
    public static final int MINHEIGHT = 1;
    public static final int MAXHEIGHT = 256;

    private ConstructionTapeHelper() {
    }

    public static void placeConstructionTape(@NotNull WorkOrderBuildDecoration workOrder, @NotNull World world) {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(workOrder.getBuildingLocation(), world, new LoadOnlyStructureHandler(world, workOrder.getBuildingLocation(), workOrder.getStructureName(), new PlacementSettings(), true).getBluePrint(), workOrder.getRotation(world), workOrder.isMirrored());
        ConstructionTapeHelper.placeConstructionTape(workOrder.getBuildingLocation(), corners, world);
    }

    public static void placeConstructionTape(BlockPos pos, Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners, @NotNull World world) {
        BlockPos working;
        if (!((Boolean)MineColonies.getConfig().getCommon().builderPlaceConstructionTape.get()).booleanValue()) {
            return;
        }
        BlockState constructionTape = ModBlocks.blockConstructionTape.func_176223_P();
        int x = Math.min((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b());
        int y = pos.func_177956_o();
        int z = Math.min((Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        int sizeX = Math.abs((Integer)((Tuple)corners.func_76341_a()).func_76340_b() - (Integer)((Tuple)corners.func_76341_a()).func_76341_a());
        int sizeZ = Math.abs((Integer)((Tuple)corners.func_76340_b()).func_76340_b() - (Integer)((Tuple)corners.func_76340_b()).func_76341_a());
        BlockPos place = new BlockPos(x, y, z);
        while (place.func_177958_n() < x + sizeX || place.func_177952_p() < z + sizeZ) {
            if (place.func_177958_n() < x + sizeX) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.func_177958_n(), y, z), world);
                world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(place.func_177958_n() == x)), (IBlockReader)world, working, Direction.SOUTH));
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.func_177958_n(), y, z + sizeZ), world);
                world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(place.func_177958_n() == x)), (IBlockReader)world, working, Direction.NORTH));
            }
            if (place.func_177952_p() < z + sizeZ) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x, y, place.func_177952_p()), world);
                world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(place.func_177952_p() == z)), (IBlockReader)world, working, Direction.EAST));
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, place.func_177952_p()), world);
                world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(place.func_177952_p() == z)), (IBlockReader)world, working, place.func_177952_p() == z ? Direction.SOUTH : Direction.WEST));
            }
            place = place.func_177968_d().func_177974_f();
        }
        working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, z + sizeZ), world);
        world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(true)), (IBlockReader)world, working, Direction.WEST));
    }

    public static BlockPos firstValidPosition(@NotNull BlockPos target, @NotNull World world) {
        Chunk chunk = world.func_175726_f(target);
        target = new BlockPos(target.func_177958_n(), chunk.func_76625_h() + 16, target.func_177952_p());
        while (target.func_177956_o() > 0) {
            if (world.func_180495_p(target = target.func_177977_b()).func_177230_c() instanceof LeavesBlock) {
                BlockPos seeker = new BlockPos((Vec3i)target.func_177977_b());
                while (seeker.func_177956_o() > 0) {
                    if (world.func_180495_p(seeker).func_185904_a().func_76222_j() || world.func_175623_d(seeker)) {
                        target = seeker;
                        break;
                    }
                    seeker = seeker.func_177977_b();
                }
            }
            if (world.func_180495_p(target).func_185904_a().func_76222_j() || world.func_180495_p(target).func_177230_c() instanceof FlowerBlock) continue;
            break;
        }
        return target.func_177984_a();
    }

    public static void removeConstructionTape(@NotNull WorkOrderBuildDecoration workOrder, @NotNull World world) {
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(world, workOrder.getBuildingLocation(), workOrder.getStructureName(), new PlacementSettings(), true);
        if (structure.hasBluePrint()) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(workOrder.getBuildingLocation(), world, structure.getBluePrint(), workOrder.getRotation(world), workOrder.isMirrored());
            ConstructionTapeHelper.removeConstructionTape(corners, world);
        }
    }

    public static void removeConstructionTape(Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners, @NotNull World world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        int x1 = (Integer)((Tuple)corners.func_76341_a()).func_76341_a();
        int x3 = (Integer)((Tuple)corners.func_76341_a()).func_76340_b();
        int z1 = (Integer)((Tuple)corners.func_76340_b()).func_76341_a();
        int z3 = (Integer)((Tuple)corners.func_76340_b()).func_76340_b();
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTape);
    }

    public static void removeTapeIfNecessary(@NotNull World world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner) {
        for (int y = 1; y <= 256; ++y) {
            BlockPos newBlock = new BlockPos(block.func_177958_n(), y, block.func_177952_p());
            if (world.func_180495_p(newBlock).func_177230_c() != tapeOrTapeCorner) continue;
            world.func_217377_a(newBlock, false);
            break;
        }
    }
}

