/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.crusher;

import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCrusher
extends AbstractEntityAICrafting<JobCrusher, BuildingCrusher> {
    private static final int TICK_DELAY = 40;
    private static final VisibleCitizenStatus CRUSHING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/crusher.png"), "com.minecolonies.gui.visiblestatus.crusher");

    public EntityAIWorkCrusher(@NotNull JobCrusher job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.CRUSH, this::crush, 40));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingCrusher> getExpectedBuildingClass() {
        return BuildingCrusher.class;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING) {
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return nextState;
        }
        return AIWorkerState.CRUSH;
    }

    protected IAIState crush() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        this.worker.getCitizenData().setVisibleStatus(CRUSHING);
        ((JobCrusher)this.job).setProgress(((JobCrusher)this.job).getProgress() + 40);
        BuildingCrusher crusherBuilding = (BuildingCrusher)this.getOwnBuilding();
        WorkerUtil.faceBlock(crusherBuilding.getPosition(), this.worker);
        if (this.currentRecipeStorage == null) {
            this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
        }
        if (this.getState() != AIWorkerState.CRAFT && crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b() || this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (((JobCrusher)this.job).getProgress() > 50 - Math.min(this.getSecondarySkillLevel() / 2 + 1, 50)) {
            ((JobCrusher)this.job).setProgress(0);
            if (check == AIWorkerState.CRAFT) {
                if (this.getState() != AIWorkerState.CRAFT) {
                    crusherBuilding.setCurrentDailyQuantity(crusherBuilding.getCurrentDailyQuantity() + 1);
                    if (crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b()) {
                        this.incrementActionsDoneAndDecSaturation();
                    }
                }
                if (this.currentRequest != null) {
                    this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
                }
                this.worker.func_184609_a(Hand.MAIN_HAND);
                ((JobCrusher)this.job).setCraftCounter(((JobCrusher)this.job).getCraftCounter() + 1);
                this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen());
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenExperienceHandler().addExperience(0.1);
            } else {
                if (this.getState() != AIWorkerState.CRAFT) {
                    this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
                    int requestQty = Math.min(((Integer)crusherBuilding.getCrusherMode().func_76340_b() - crusherBuilding.getCurrentDailyQuantity()) * 2, 64);
                    if (requestQty <= 0) {
                        return AIWorkerState.START_WORKING;
                    }
                    ItemStack stack = this.currentRecipeStorage.getInput().get(0).func_77946_l();
                    stack.func_190920_e(requestQty);
                    this.checkIfRequestForItemExistOrCreateAsynch(stack);
                    return AIWorkerState.START_WORKING;
                }
                return check;
            }
        }
        if (check == AIWorkerState.CRAFT) {
            Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(this.currentRecipeStorage.getInput().get(0).func_77946_l(), crusherBuilding.getID()), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(this.currentRecipeStorage.getPrimaryOutput().func_77946_l(), crusherBuilding.getID().func_177977_b()), (Entity)this.worker);
            SoundUtils.playSoundAtCitizen(this.world, ((BuildingCrusher)this.getOwnBuilding()).getID(), SoundEvents.field_187835_fT);
        }
        return this.getState();
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((JobCrusher)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((JobCrusher)this.job).setProgress(((JobCrusher)this.job).getProgress() + 1);
        this.worker.func_184611_a(Hand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.getRandom().nextInt(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().func_77946_l());
        this.worker.func_184611_a(Hand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().func_77946_l());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((BuildingCrusher)this.getOwnBuilding()).getPosition());
        this.currentRequest = ((JobCrusher)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.crush();
        if (check == this.getState()) {
            if (((JobCrusher)this.job).getCraftCounter() >= ((JobCrusher)this.job).getMaxCraftingCount()) {
                this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                this.currentRecipeStorage = null;
                this.resetValues();
                if (this.inventoryNeedsDump() && ((JobCrusher)this.job).getMaxCraftingCount() == 0 && ((JobCrusher)this.job).getProgress() == 0 && ((JobCrusher)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
                    ((JobCrusher)this.job).finishRequest(true);
                }
            }
        } else {
            this.currentRequest = null;
            ((JobCrusher)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
        }
        return this.getState();
    }
}

