/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.fisherman;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.entity.NewBobberEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFisherman
extends AbstractEntityAISkill<JobFisherman, BuildingFisherman> {
    private static final String RENDER_META_FISH = "fish";
    private static final String RENDER_META_FISHANDROD = "rodfish";
    private static final String RENDER_META_ROD = "rod";
    private static final int MAX_PONDS = 20;
    private static final int FISHING_DELAY = 25;
    private static final int CHANCE = 2;
    private static final int MIN_DISTANCE_TO_WATER = 3;
    private static final int MAX_FISHES_IN_INV = 10;
    private static final int MAX_ROTATIONS = 6;
    private static final int SEARCH_RANGE = 50;
    private static final double CHANCE_NEW_POND = 0.05;
    private static final int FISHING_TIMEOUT = 5;
    private static final int LEVEL_FOR_BONUS = 3;
    private static final int LURE_SPEED_DIVIDER = 15;
    private int executedRotations = 0;
    @Nullable
    private WaterPathResult pathResult;
    @Nullable
    private WaterPathResult lastPathResult;
    @Nullable
    private NewBobberEntity entityFishHook;

    public EntityAIWorkFisherman(@NotNull JobFisherman job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForFishing, 20), new AITarget((IAIState)AIWorkerState.FISHERMAN_CHECK_WATER, this::tryDifferentAngles, 1), new AITarget((IAIState)AIWorkerState.FISHERMAN_SEARCHING_WATER, this::findWater, 20), new AITarget((IAIState)AIWorkerState.FISHERMAN_WALKING_TO_WATER, this::getToWater, 20), new AITarget((IAIState)AIWorkerState.FISHERMAN_START_FISHING, this::doFishing, 20));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingFisherman> getExpectedBuildingClass() {
        return BuildingFisherman.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForFishing() {
        if (this.checkForToolOrWeapon(ToolType.FISHINGROD)) {
            this.playNeedRodSound();
            return this.getState();
        }
        return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
    }

    private void playNeedRodSound() {
        SoundUtils.playSoundAtCitizenWith(this.world, this.worker.func_180425_c(), EventType.MISSING_EQUIPMENT, this.worker.getCitizenData());
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    protected void updateRenderMetaData() {
        if (this.hasFish() && this.hasRodButNotEquipped()) {
            this.worker.setRenderMetadata(RENDER_META_FISHANDROD);
        } else if (this.hasRodButNotEquipped() && !this.hasFish()) {
            this.worker.setRenderMetadata(RENDER_META_ROD);
        } else {
            this.worker.setRenderMetadata(this.hasFish() ? RENDER_META_FISH : "");
        }
    }

    private boolean hasFish() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), item -> item.func_77973_b().func_206844_a(ItemTags.field_206964_G));
    }

    private boolean hasRodButNotEquipped() {
        return this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.field_151112_aM) && this.worker.func_184614_ca() != null && !(this.worker.func_184614_ca().func_77973_b() instanceof FishingRodItem);
    }

    private IAIState getToWater() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.goingtopond", new Object[0])});
        if (this.walkToWater()) {
            return this.getState();
        }
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private boolean walkToWater() {
        return ((JobFisherman)this.job).getWater() != null && this.walkToBlock(((JobFisherman)this.job).getWater().getB());
    }

    @NotNull
    private IAIState tryDifferentAngles() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.executedRotations >= 6) {
            ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
            ((JobFisherman)this.job).setWater(null);
            this.executedRotations = 0;
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.world.func_180495_p(this.worker.func_180425_c()).func_185904_a().func_76224_d()) {
            return AIWorkerState.START_WORKING;
        }
        WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
        ++this.executedRotations;
        return AIWorkerState.FISHERMAN_START_FISHING;
    }

    private IAIState findWater() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.searchingwater", new Object[0])});
        this.executedRotations = 0;
        if (((JobFisherman)this.job).getPonds().size() >= 20) {
            return this.setRandomWater();
        }
        return this.findNewWater();
    }

    private IAIState setRandomWater() {
        if (((JobFisherman)this.job).getPonds().isEmpty()) {
            if ((this.pathResult != null && this.pathResult.failedToReachDestination() && this.lastPathResult == null || this.lastPathResult != null && this.lastPathResult.isEmpty && !this.lastPathResult.isCancelled()) && this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.fisherman.messagewatertoofar", new Object[0]), ChatPriority.IMPORTANT));
            }
            if (this.pathResult == null || !this.pathResult.isInProgress()) {
                this.pathResult = this.worker.getNavigator().moveToWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            }
            return AIWorkerState.START_WORKING;
        }
        ((JobFisherman)this.job).setWater(((JobFisherman)this.job).getPonds().get(this.worker.getRandom().nextInt(((JobFisherman)this.job).getPonds().size())));
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private IAIState findNewWater() {
        if (this.pathResult == null) {
            this.pathResult = this.worker.getNavigator().moveToWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            return this.getState();
        }
        if (this.pathResult.failedToReachDestination()) {
            return this.setRandomWater();
        }
        if (this.pathResult.isPathReachingDestination()) {
            if (this.pathResult.pond != null) {
                ((JobFisherman)this.job).setWater(new Tuple<BlockPos, BlockPos>(this.pathResult.pond, this.pathResult.parent));
                ((JobFisherman)this.job).addToPonds(this.pathResult.pond, this.pathResult.parent);
            }
            this.lastPathResult = this.pathResult;
            this.pathResult = null;
            return AIWorkerState.FISHERMAN_CHECK_WATER;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIWorkerState.PREPARING;
        }
        return this.getState();
    }

    @Nullable
    private IAIState doFishing() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.fishing", new Object[0])});
        IAIState notReadyState = this.isReadyToFish();
        if (notReadyState != null) {
            return notReadyState;
        }
        if (this.caughtFish()) {
            this.playCaughtFishSound();
            if (((BuildingFisherman)this.getOwnBuilding()).getBuildingLevel() > 3) {
                double primarySkillFactor = (Double)this.worker.getCitizenData().getCitizenSkillHandler().getSkills().get((Object)((BuildingFisherman)this.getOwnBuilding()).getPrimarySkill()).func_76340_b() / 10.0;
                double rollResult = this.worker.getRandom().nextDouble() * 100.0;
                double spongeTarget = (Double)MineColonies.getConfig().getCommon().fisherSpongeChance.get() + primarySkillFactor;
                double shardTarget = spongeTarget + (Double)MineColonies.getConfig().getCommon().fisherPrismarineChance.get() + primarySkillFactor;
                double crystalTarget = shardTarget + (Double)MineColonies.getConfig().getCommon().fisherPrismarineChance.get() + primarySkillFactor;
                ItemStack bonusItemStack = null;
                if (rollResult < spongeTarget) {
                    bonusItemStack = new ItemStack((IItemProvider)Blocks.field_150360_v);
                } else if (rollResult < shardTarget) {
                    bonusItemStack = new ItemStack((IItemProvider)Items.field_179562_cC);
                } else if (rollResult < crystalTarget) {
                    bonusItemStack = new ItemStack((IItemProvider)Items.field_179563_cD);
                }
                if (bonusItemStack != null) {
                    InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), bonusItemStack);
                }
            }
            this.incrementActionsDoneAndDecSaturation();
            if (this.worker.getRandom().nextDouble() < 0.05) {
                ((JobFisherman)this.job).setWater(null);
                return AIWorkerState.FISHERMAN_SEARCHING_WATER;
            }
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        return this.throwOrRetrieveHook();
    }

    private void playCaughtFishSound() {
        SoundUtils.playSoundAtCitizenWith(this.world, this.worker.func_180425_c(), EventType.SUCCESS, this.worker.getCitizenData());
    }

    private IAIState throwOrRetrieveHook() {
        if (this.entityFishHook == null) {
            if (this.testRandomChance()) {
                return this.getState();
            }
            this.throwRod();
        } else {
            if (this.isFishHookStuck()) {
                this.retrieveRod();
                return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
            }
            this.entityFishHook.setInUse();
        }
        return this.getState();
    }

    private void throwRod() {
        if (!this.world.field_72995_K) {
            WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
            this.world.func_184133_a(null, this.worker.func_180425_c(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, (float)(0.4 / ((double)this.world.field_73012_v.nextFloat() * 0.4 + 0.8)));
            this.entityFishHook = (NewBobberEntity)ModEntities.FISHHOOK.func_200721_a(this.world);
            this.entityFishHook.setAngler((EntityCitizen)this.worker, EnchantmentHelper.func_191529_b((ItemStack)this.worker.func_184614_ca()), 5 + this.getPrimarySkillLevel() / 15 + EnchantmentHelper.func_191528_c((ItemStack)this.worker.func_184614_ca()));
            this.world.func_217376_c((Entity)this.entityFishHook);
        }
        this.worker.func_184609_a(this.worker.func_184600_cs());
    }

    private boolean isFishHookStuck() {
        return !this.entityFishHook.func_70090_H() && (this.entityFishHook.field_70122_E || this.entityFishHook.shouldStopFishing()) || !this.entityFishHook.field_70175_ag || !this.entityFishHook.func_70089_S();
    }

    private boolean testRandomChance() {
        this.setDelay(5);
        double chance = (double)this.worker.getRandom().nextInt(25) / ((double)this.getSecondarySkillLevel() / 2.0 + 1.0);
        return chance >= 2.0;
    }

    private IAIState isReadyToFish() {
        if (this.getRodSlot() == -1) {
            return AIWorkerState.PREPARING;
        }
        if (!Utils.isBlockInRange(this.world, Blocks.field_150355_j, (int)this.worker.func_226277_ct_(), (int)this.worker.func_226278_cu_(), (int)this.worker.func_226281_cx_(), 3)) {
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        if (this.worker.func_184614_ca() == null || !this.worker.func_184614_ca().func_77973_b().equals(Items.field_151112_aM)) {
            this.equipRod();
            return this.getState();
        }
        return null;
    }

    private void equipRod() {
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, this.getRodSlot());
    }

    private int getRodSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.FISHINGROD, 0, ((BuildingFisherman)this.getOwnBuilding()).getMaxToolLevel());
    }

    private boolean caughtFish() {
        if (this.entityFishHook == null) {
            return false;
        }
        if (!this.entityFishHook.isReadyToCatch()) {
            return false;
        }
        this.worker.func_98053_h(true);
        this.retrieveRod();
        return true;
    }

    private void retrieveRod() {
        if (this.entityFishHook != null) {
            this.worker.func_184609_a(this.worker.func_184600_cs());
            int i = this.entityFishHook.getDamage();
            this.entityFishHook.func_70106_y();
            this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, i);
            this.entityFishHook = null;
        }
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

