/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingArchery;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.entity.ai.citizen.trainingcamps.AbstractEntityAITraining;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIArcherTraining
extends AbstractEntityAITraining<JobArcherTraining, BuildingArchery> {
    private static final int XP_PER_SUCCESSFUL_SHOT = 1;
    private static final int BUILDING_LEVEL_TARGET_MULTIPLIER = 5;
    private static final double MIN_DISTANCE_FOR_SUCCESS = 2.0;
    private static final int RANGED_ATTACK_DELAY_BASE = 10;
    private static final double XP_BASE_RATE = 0.2;
    private static final int CHECK_SHOT_DELAY = 60;
    private static final VisibleCitizenStatus ARCHER_TRAIN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_uni.png"), "com.minecolonies.gui.visiblestatus.archer_uni");
    private BlockPos currentShootingTarget;
    private int targetCounter;
    private ArrowEntity arrowInProgress;

    public EntityAIArcherTraining(@NotNull JobArcherTraining job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COMBAT_TRAINING, this::findShootingStandPosition, 1), new AITarget((IAIState)AIWorkerState.ARCHER_SELECT_TARGET, this::selectTarget, 1), new AITarget((IAIState)AIWorkerState.ARCHER_CHECK_SHOT, this::checkShot, 1), new AITarget((IAIState)AIWorkerState.ARCHER_SHOOT, this::shoot, 1));
    }

    private IAIState selectTarget() {
        this.setDelay(5);
        BuildingArchery archeryBuilding = (BuildingArchery)this.getOwnBuilding();
        if (this.targetCounter >= archeryBuilding.getBuildingLevel() * 5) {
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        BlockPos targetPos = archeryBuilding.getRandomShootingTarget(this.worker.getRandom());
        if (targetPos == null) {
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenData().setVisibleStatus(ARCHER_TRAIN);
        this.currentShootingTarget = targetPos;
        ++this.targetCounter;
        return AIWorkerState.ARCHER_SHOOT;
    }

    private IAIState findShootingStandPosition() {
        this.setDelay(5);
        BuildingArchery archeryBuilding = (BuildingArchery)this.getOwnBuilding();
        BlockPos shootingPos = archeryBuilding.getRandomShootingStandPosition(this.worker.getRandom());
        if (shootingPos == null) {
            return AIWorkerState.DECIDE;
        }
        this.stateAfterPathing = AIWorkerState.ARCHER_SELECT_TARGET;
        this.currentPathingTarget = shootingPos;
        return AIWorkerState.GO_TO_TARGET;
    }

    protected IAIState shoot() {
        ArrowEntity arrow;
        this.setDelay(5);
        if (this.currentShootingTarget == null || !this.isSetup()) {
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return AIWorkerState.START_WORKING;
        }
        if (this.worker.func_184587_cr()) {
            WorkerUtil.faceBlock(this.currentShootingTarget, this.worker);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            arrow = (ArrowEntity)ModEntities.MC_NORMAL_ARROW.func_200721_a(this.world);
            arrow.func_70239_b(0.0);
            arrow.func_212361_a((Entity)this.worker);
            arrow.func_70107_b(this.worker.func_226277_ct_(), this.worker.func_226278_cu_() + 1.0, this.worker.func_226281_cx_());
            double xVector = (double)this.currentShootingTarget.func_177958_n() - this.worker.func_226277_ct_();
            double yVector = (double)this.currentShootingTarget.func_177956_o() - arrow.field_70163_u;
            double zVector = (double)this.currentShootingTarget.func_177952_p() - this.worker.func_226281_cx_();
            double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
            double chance = 15.0 / ((double)this.getPrimarySkillLevel() / 2.0 + 1.0);
            arrow.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
            this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            this.worker.field_70170_p.func_217376_c((Entity)arrow);
            double xDiff = (double)this.currentShootingTarget.func_177958_n() - this.worker.func_226277_ct_();
            double zDiff = (double)this.currentShootingTarget.func_177952_p() - this.worker.func_226281_cx_();
            double goToX = xDiff > 0.0 ? 0.01 : -0.01;
            double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
            this.worker.func_213315_a(MoverType.SELF, new Vec3d(goToX, 0.0, goToZ));
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            if (this.currentAttackDelay <= 0) {
                this.worker.func_184598_c(Hand.MAIN_HAND);
            }
            return AIWorkerState.ARCHER_SHOOT;
        }
        this.worker.func_184602_cy();
        this.incrementActionsDoneAndDecSaturation();
        this.arrowInProgress = arrow;
        this.currentAttackDelay = 10;
        this.setDelay(60);
        return AIWorkerState.ARCHER_CHECK_SHOT;
    }

    private IAIState checkShot() {
        Vec3d vec3d = new Vec3d((Vec3i)this.currentShootingTarget);
        if (this.arrowInProgress.func_195048_a(vec3d) < 2.0) {
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        } else {
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.ARCHER_SELECT_TARGET;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.BOW)) {
            this.setDelay(60);
            return false;
        }
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.BOW, 0, ((BuildingArchery)this.getOwnBuilding()).getMaxToolLevel());
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, bowSlot);
        return true;
    }

    @Override
    public Class<BuildingArchery> getExpectedBuildingClass() {
        return BuildingArchery.class;
    }
}

