/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class EntityAIEatTask
extends Goal {
    private static final int MINUTES_WAITING_TIME = 2;
    private static final int MIN_DISTANCE_TO_RESTAURANT = 10;
    private static final int PLACE_TO_EAT_DISTANCE = 5;
    private static final int REQUIRED_TIME_TO_EAT = 5;
    private static final int GET_YOURSELF_SATURATION = 30;
    private final EntityCitizen citizen;
    private final TickRateStateMachine<EatingState> stateMachine;
    private int waitingTicks = 0;
    private int foodSlot = -1;
    private Vec3d eatPos = null;
    private BlockPos restaurantPos;
    private int timeOutWalking = 0;

    public EntityAIEatTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<EatingState>(EatingState.IDLE, e -> Log.getLogger().warn("Eating AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.IDLE, this::shouldEat, () -> EatingState.CHECK_FOR_FOOD, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.CHECK_FOR_FOOD, () -> true, this::getFood, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_HUT, () -> true, this::goToHut, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.EAT, () -> true, this::eat, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.SEARCH_RESTAURANT, () -> true, this::searchRestaurant, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_RESTAURANT, () -> true, this::goToRestaurant, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.WAIT_FOR_FOOD, () -> true, this::waitForFood, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_EAT_POS, () -> true, this::goToEatingPlace, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GET_FOOD_YOURSELF, () -> true, this::getFoodYourself, 20));
    }

    private EatingState getFood() {
        if (this.hasFood()) {
            return EatingState.EAT;
        }
        return EatingState.GO_TO_HUT;
    }

    public boolean shouldEat() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        if (this.citizen.getCitizenDiseaseHandler().isSick() && this.citizen.getCitizenSleepHandler().isAsleep()) {
            return false;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null || !this.citizen.isOkayToEat()) {
            return false;
        }
        return citizenData.getSaturation() <= 3.0;
    }

    public boolean func_75250_a() {
        this.stateMachine.tick();
        return this.stateMachine.getState() != EatingState.IDLE;
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    private boolean canEat(ICitizenData citizenData, ItemStack stack) {
        return citizenData.getWorkBuilding() == null || citizenData.getWorkBuilding().canEat(stack);
    }

    private EatingState eat() {
        if (!this.hasFood()) {
            return EatingState.CHECK_FOR_FOOD;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        ItemStack stack = citizenData.getInventory().getStackInSlot(this.foodSlot);
        if (!ItemStackUtils.CAN_EAT.test(stack) || !this.canEat(citizenData, stack)) {
            return EatingState.CHECK_FOR_FOOD;
        }
        this.citizen.func_184611_a(Hand.MAIN_HAND, stack);
        this.citizen.func_184609_a(Hand.MAIN_HAND);
        this.citizen.func_184185_a(SoundEvents.field_187537_bA, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.getRandom()));
        Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(this.citizen.func_184614_ca(), this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v, this.citizen.field_70125_A, this.citizen.field_70177_z, this.citizen.func_70047_e()), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 5) {
            return EatingState.EAT;
        }
        Food itemFood = stack.func_77973_b().func_219967_s();
        double satIncrease = itemFood.func_221466_a();
        AdditionModifierResearchEffect satLimitDecrease = this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Saturation", AdditionModifierResearchEffect.class);
        if (satLimitDecrease != null) {
            satIncrease *= 1.0 + satLimitDecrease.getEffect();
        }
        citizenData.increaseSaturation(satIncrease / 2.0);
        citizenData.getInventory().extractItem(this.foodSlot, 1, false);
        IColony citizenColony = this.citizen.getCitizenColonyHandler().getColony();
        if (citizenColony != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(citizenColony, playerMP -> AdvancementTriggers.CITIZEN_EAT_FOOD.trigger((ServerPlayerEntity)playerMP, stack));
        }
        citizenData.markDirty();
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        if (citizenData.getSaturation() < 10.0 && !stack.func_190926_b()) {
            this.waitingTicks = 0;
            return EatingState.EAT;
        }
        return EatingState.IDLE;
    }

    private EatingState getFoodYourself() {
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        IBuilding cookBuilding = colony.getBuildingManager().getBuilding(this.restaurantPos);
        if (cookBuilding instanceof BuildingCook) {
            InventoryUtils.transferFoodUpToSaturation(cookBuilding, (IItemHandler)this.citizen.getInventoryCitizen(), 30, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack));
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToEatingPlace() {
        if (this.eatPos == null || this.citizen.isWorkerAtSiteWithMove(new BlockPos(this.eatPos), 10) || this.timeOutWalking++ > 400) {
            this.timeOutWalking = 0;
            return EatingState.EAT;
        }
        return EatingState.GO_TO_EAT_POS;
    }

    private Vec3d findPlaceToEat() {
        return RandomPositionGenerator.func_191377_b((CreatureEntity)this.citizen, (int)5, (int)0);
    }

    private EatingState waitForFood() {
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        this.restaurantPos = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (BlockPosUtil.getDistance2D(this.restaurantPos, this.citizen.func_180425_c()) > 10L) {
            return EatingState.GO_TO_RESTAURANT;
        }
        if (this.hasFood()) {
            this.eatPos = this.findPlaceToEat();
            if (this.eatPos != null) {
                return EatingState.GO_TO_EAT_POS;
            }
            return EatingState.EAT;
        }
        ++this.waitingTicks;
        if (this.waitingTicks > 120) {
            this.waitingTicks = 0;
            return EatingState.GET_FOOD_YOURSELF;
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToHut() {
        IBuildingWorker buildingWorker = this.citizen.getCitizenData().getWorkBuilding();
        if (buildingWorker == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (this.citizen.isWorkerAtSiteWithMove(buildingWorker.getPosition(), 10)) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)buildingWorker, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack));
            if (slot != -1 && InventoryUtils.transferFoodUpToSaturation(buildingWorker, (IItemHandler)this.citizen.getInventoryCitizen(), 30, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack))) {
                return EatingState.EAT;
            }
            return EatingState.SEARCH_RESTAURANT;
        }
        return EatingState.GO_TO_HUT;
    }

    private EatingState goToRestaurant() {
        if (this.citizen.isWorkerAtSiteWithMove(this.restaurantPos, 10)) {
            return EatingState.WAIT_FOR_FOOD;
        }
        return EatingState.SEARCH_RESTAURANT;
    }

    private EatingState searchRestaurant() {
        IJob<?> job;
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        this.restaurantPos = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.citizen.getInventoryCitizen(), ItemStackUtils.ISCOOKABLE)) {
            citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.wrongfood", new Object[0]), ChatPriority.PENDING));
        }
        if ((job = this.citizen.getCitizenJobHandler().getColonyJob()) != null && job.isActive()) {
            job.setActive(false);
        }
        if (this.restaurantPos == null) {
            citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.norestaurant", new Object[0]), ChatPriority.BLOCKING));
            return EatingState.CHECK_FOR_FOOD;
        }
        return EatingState.GO_TO_RESTAURANT;
    }

    private boolean hasFood() {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack));
        if (slot != -1) {
            this.foodSlot = slot;
            return true;
        }
        return false;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.foodSlot = -1;
        this.citizen.func_184597_cx();
        this.citizen.func_184602_cy();
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        this.restaurantPos = null;
        this.eatPos = null;
    }

    public void func_75251_c() {
        this.reset();
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    public void func_75249_e() {
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.EAT);
    }

    public static enum EatingState implements IState
    {
        IDLE,
        CHECK_FOR_FOOD,
        GO_TO_HUT,
        SEARCH_RESTAURANT,
        GO_TO_RESTAURANT,
        WAIT_FOR_FOOD,
        GET_FOOD_YOURSELF,
        GO_TO_EAT_POS,
        EAT;

    }
}

