/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.VisitorData;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTavern;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.citizen.VisitorCitizen;
import com.minecolonies.coremod.util.NamedDamageSource;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.NotNull;

public class EntityAIVisitor
extends Goal {
    private static final int COMBAT_UPDATE_RATE = 20;
    private final VisitorCitizen citizen;
    private final ITickRateStateMachine<VisitorState> stateMachine;
    private BuildingTavern tavern;
    private int actionTimeoutCounter = 0;
    private Entity target = null;

    public EntityAIVisitor(@NotNull AbstractEntityCitizen entity) {
        this.citizen = (VisitorCitizen)entity;
        this.stateMachine = new TickRateStateMachine<VisitorState>(VisitorState.INIT, this::onException);
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.INIT, this::isEntityLoaded, () -> VisitorState.IDLE, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.IDLE, () -> true, this::decide, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::wander, () -> VisitorState.IDLE, 200));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::shouldFight, () -> VisitorState.COMBAT, 200));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::sit, () -> VisitorState.IDLE, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::shouldFight, () -> VisitorState.COMBAT, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.COMBAT, this::doFight, () -> VisitorState.IDLE, 20));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.IDLE, this::reduceTime, this.stateMachine::getState, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::reduceTime, this.stateMachine::getState, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::reduceTime, this.stateMachine::getState, 50));
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
    }

    private boolean reduceTime() {
        this.citizen.getCitizenData().decreaseSaturation(0.02);
        this.citizen.getCitizenData().markDirty();
        if (this.citizen.getCitizenData().getSaturation() <= 0.0) {
            this.citizen.getCitizenColonyHandler().getColony().getVisitorManager().removeCivilian(this.citizen.getCitizenData());
            if (this.tavern != null) {
                this.tavern.removeCitizen(this.citizen.getCivilianID());
            }
            return true;
        }
        return false;
    }

    private boolean doFight() {
        if (this.target == null || !this.target.func_70089_S() || (this.actionTimeoutCounter -= 20) <= 0) {
            this.target = null;
            this.citizen.func_70604_c(null);
            this.citizen.func_70624_b(null);
            return true;
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.target.func_180425_c(), 2) && this.citizen.func_70685_l(this.target)) {
            this.citizen.func_184609_a(Hand.MAIN_HAND);
            this.target.func_70097_a((DamageSource)new NamedDamageSource(this.citizen.func_200200_C_().func_150254_d(), (Entity)this.citizen), 10.0f);
        }
        return false;
    }

    private boolean wander() {
        if ((this.actionTimeoutCounter -= 50) <= 0) {
            return true;
        }
        this.citizen.getNavigator().moveToRandomPos(10.0, 0.6);
        return false;
    }

    private boolean shouldFight() {
        if (this.getTarget() != null) {
            this.actionTimeoutCounter = 600;
            return true;
        }
        return false;
    }

    private VisitorState decide() {
        if (this.shouldFight()) {
            return VisitorState.COMBAT;
        }
        int random = this.citizen.getRandom().nextInt(5);
        if (this.tavern != null && (random == 0 || random == 1 && !this.citizen.getCitizenColonyHandler().getColony().isDay())) {
            BlockPos pos = this.tavern.getFreeSitPosition();
            if (pos != null) {
                ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(pos);
                this.citizen.isWorkerAtSiteWithMove(pos, 1);
                this.actionTimeoutCounter = this.citizen.getRandom().nextInt(2500) + 3000;
                return VisitorState.SITTING;
            }
        } else if (random == 2) {
            this.citizen.getNavigator().moveToRandomPos(10.0, 0.6);
            this.actionTimeoutCounter = this.citizen.getCitizenColonyHandler().getColony().isDay() ? this.citizen.getRandom().nextInt(1000) + 1000 : 300;
            return VisitorState.WANDERING;
        }
        return VisitorState.IDLE;
    }

    private boolean sit() {
        if ((this.actionTimeoutCounter -= 50) <= 0) {
            ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.field_177992_a);
            return true;
        }
        BlockPos moveTo = ((VisitorData)this.citizen.getCitizenData()).getSittingPosition();
        if (this.citizen.isWorkerAtSiteWithMove(moveTo, 1) && this.citizen.func_184187_bx() == null) {
            SittingEntity entity = (SittingEntity)ModEntities.SITTINGENTITY.func_200721_a(this.citizen.field_70170_p);
            entity.func_70107_b((double)moveTo.func_177958_n() + 0.5, (double)moveTo.func_177956_o() - 0.4, (double)moveTo.func_177952_p() + 0.5);
            entity.setMaxLifeTime(this.actionTimeoutCounter);
            this.citizen.field_70170_p.func_217376_c((Entity)entity);
            this.citizen.func_184220_m(entity);
            this.citizen.getNavigator().func_75499_g();
        }
        return false;
    }

    private boolean isEntityLoaded() {
        if (this.citizen.getCitizenColonyHandler().getColony() == null || this.citizen.getCitizenData() == null || this.citizen.getCitizenData().getHomeBuilding() == null) {
            return false;
        }
        IBuilding building = this.citizen.getCitizenData().getHomeBuilding();
        if (building instanceof BuildingTavern) {
            this.tavern = (BuildingTavern)building;
        }
        ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.field_177992_a);
        return WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, this.citizen.func_180425_c());
    }

    private Entity getTarget() {
        if (this.target == null) {
            this.target = this.citizen.func_70638_az();
            if (this.target == null) {
                this.target = this.citizen.func_70643_av();
            }
        }
        return this.target;
    }

    private void onException(RuntimeException e) {
        Log.getLogger().warn("Visitor AI of:" + this.citizen.func_200200_C_() + " threw an Exception:", (Throwable)e);
    }

    public boolean func_75250_a() {
        return true;
    }

    public boolean func_75253_b() {
        this.stateMachine.tick();
        return true;
    }

    private void resetLogic() {
        ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.field_177992_a);
    }

    public void func_75251_c() {
        this.stateMachine.reset();
        this.resetLogic();
    }

    public static enum VisitorState implements IState
    {
        INIT,
        IDLE,
        SLEEPING,
        SITTING,
        COMBAT,
        WANDERING;

    }
}

