/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingStructureHandler<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractStructureHandler {
    private static final double XP_EACH_BLOCK = 0.05;
    private final AbstractEntityAIStructure<J, B> structureAI;
    private final Stage[] stages;
    private IBuilding building;
    private int stage;

    public BuildingStructureHandler(World world, BlockPos worldPos, String structureName, PlacementSettings settings, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, structureName, settings);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    public BuildingStructureHandler(World world, BlockPos worldPos, Blueprint blueprint, PlacementSettings settings, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, blueprint, settings);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    @Nullable
    public Stage getStage() {
        if (this.stage >= this.stages.length) {
            return null;
        }
        return this.stages[this.stage];
    }

    public boolean nextStage() {
        return ++this.stage < this.stages.length;
    }

    public void setStage(Stage stage) {
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] != stage) continue;
            this.stage = i;
            return;
        }
    }

    public void prePlacementLogic(BlockPos worldPos, BlockState blockState) {
        WorkerUtil.faceBlock(worldPos, this.structureAI.getWorker());
        ItemStack item = BlockUtils.getItemStackFromBlockState((BlockState)blockState);
        this.structureAI.getWorker().func_184201_a(EquipmentSlotType.MAINHAND, item == null ? ItemStackUtils.EMPTY : item);
        if (MathHelper.func_76128_c((double)this.structureAI.getWorker().func_226277_ct_()) == worldPos.func_177958_n() && MathHelper.func_76130_a((int)(worldPos.func_177956_o() - (int)this.structureAI.getWorker().func_226278_cu_())) <= 1 && MathHelper.func_76128_c((double)this.structureAI.getWorker().func_226281_cx_()) == worldPos.func_177952_p() && this.structureAI.getWorker().getNavigator().func_75500_f()) {
            this.structureAI.getWorker().getNavigator().moveAwayFromXYZ(worldPos, 4.1, 1.0);
        }
        this.structureAI.getWorker().func_184609_a(Hand.MAIN_HAND);
    }

    @Nullable
    public IItemHandler getInventory() {
        return this.structureAI.getWorker().getInventoryCitizen();
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockState state = this.getBluePrint().getBlockState(pos);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        if (this.building != null) {
            this.building.registerBlockPosition(this.getBluePrint().getBlockState(pos), worldPos, this.getWorld());
        }
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
            }
        }
        if (state.func_177230_c() == ModBlocks.blockWayPoint) {
            this.structureAI.getWorker().getCitizenColonyHandler().getColony().addWayPoint(worldPos, state);
        }
    }

    public void triggerEntitySuccess(BlockPos blockPos, List<ItemStack> list, boolean placement) {
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
            }
        }
    }

    public boolean hasRequiredItems(@NotNull List<ItemStack> requiredItems) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : requiredItems) {
            for (ToolType toolType : ToolType.values()) {
                if (!ItemStackUtils.isTool(stack, toolType) || !this.structureAI.checkForToolOrWeapon(toolType)) continue;
                return false;
            }
            itemList.add(this.structureAI.getTotalAmount(stack));
        }
        return AbstractEntityAIStructure.hasListOfResInInvOrRequest(this.structureAI, itemList, itemList.size() > 1) == AbstractEntityAIStructure.ItemCheckResult.SUCCESS;
    }

    public boolean isCreative() {
        return (Boolean)MineColonies.getConfig().getCommon().builderInfiniteResources.get();
    }

    public int getStepsPerCall() {
        return 1;
    }

    public int getMaxBlocksCheckedPerCall() {
        return 250;
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.func_190926_b() || itemStack.func_77973_b().func_206844_a(ItemTags.field_206963_E) || itemStack.func_77973_b() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).func_77973_b();
    }

    public boolean allowReplace() {
        return this.getStage() != null && this.getStage() != Stage.CLEAR;
    }

    public ItemStack getHeldItem() {
        return this.structureAI.getWorker().func_184614_ca();
    }

    public BlockState getSolidBlockForPos(BlockPos blockPos) {
        return this.structureAI.getSolidSubstitution(blockPos);
    }

    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !blockState.func_185904_a().func_76220_a() || this.structureAI.shallReplaceSolidSubstitutionBlock(blockState.func_177230_c(), blockState);
    }

    public boolean fancyPlacement() {
        return true;
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        if (block1 == Blocks.field_150457_bL || block2 == Blocks.field_150457_bL) {
            return block1 == block2;
        }
        return block1 == Blocks.field_196658_i && block2 == Blocks.field_150346_d || block2 == Blocks.field_196658_i && block1 == Blocks.field_150346_d;
    }

    public static enum Stage {
        CLEAR,
        BUILD_SOLID,
        CLEAR_WATER,
        CLEAR_NON_SOLIDS,
        DECORATE,
        SPAWN,
        REMOVE,
        REMOVE_WATER;

    }
}

