/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenDiedEvent;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIEatTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIMournCitizen;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISickTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISleep;
import com.minecolonies.coremod.entity.citizen.CitizenColonyHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenStatusHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.MovementHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.Unpooled;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen {
    private static final int CALL_HELP_CD = 100;
    private static final float GUARD_BLOCK_DAMAGE = 0.5f;
    private static final double MAX_SPEED_FACTOR = 0.5;
    private static final int CALL_TO_HELP_AMOUNT = 2;
    private final ICitizenStatusHandler citizenStatusHandler;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    private ICitizenData citizenData;
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenChatHandler citizenChatHandler;
    private ICitizenItemHandler citizenItemHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private ICitizenDiseaseHandler citizenDiseaseHandler;
    private PathResult moveAwayPath;
    private boolean mourning = false;
    private boolean hidingFromRain = false;
    private boolean child = false;
    private boolean currentlyFleeing = false;
    private int callForHelpCooldown = 0;
    private float lastDistanceWalked = 0.0f;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private String cachedTeamName;
    private ITickRateStateMachine<EntityState> entityStatemachine = new TickRateStateMachine<EntityState>(EntityState.INIT, e -> Log.getLogger().warn(e));
    private DesiredActivity desiredActivity = DesiredActivity.IDLE;

    public EntityCitizen(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
        this.field_70714_bg = new CustomGoalSelector(this.field_70714_bg);
        this.field_70715_bh = new CustomGoalSelector(this.field_70715_bh);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenChatHandler = new CitizenChatHandler(this);
        this.citizenStatusHandler = new CitizenStatusHandler(this);
        this.citizenItemHandler = new CitizenItemHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new CitizenColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
        this.field_70765_h = new MovementHandler((MobEntity)this);
        this.func_110163_bv();
        this.func_174805_g((Boolean)MineColonies.getConfig().getCommon().alwaysRenderNameTag.get());
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INIT, () -> true, this::initialize, 40));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, () -> {
            this.citizenColonyHandler.updateColonyClient();
            return false;
        }, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::refreshCitizenDataView, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateSaturation, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateVisualData, () -> null, 200));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onServerUpdateHandlers, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onTickDecrements, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::determineDesiredActivity, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INACTIVE, () -> ((EntityCitizen)this).func_70089_S(), () -> EntityState.INIT, 100));
    }

    private boolean shouldBeInactive() {
        if (this.citizenData == null && this.citizenDataView == null) {
            return true;
        }
        return !this.func_70089_S();
    }

    private EntityState initialize() {
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a())) != null) {
                this.cachedTeamName = colonyView.getTeamName();
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                if (this.citizenDataView != null) {
                    this.initTasks();
                    return EntityState.ACTIVE_CLIENT;
                }
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.citizenData != null && this.func_70089_S() && this.citizenColonyHandler.getColony() != null) {
                this.initTasks();
                return EntityState.ACTIVE_SERVER;
            }
        }
        return null;
    }

    private void initTasks() {
        int priority = 0;
        this.field_70714_bg.func_75776_a(priority, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAICitizenAvoidEntity(this, MonsterEntity.class, 5.0f, 0.8, 1.1));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAIEatTask(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAISickTask(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAISleep(this));
        this.field_70714_bg.func_75776_a(priority, (Goal)new EntityAIInteractToggleAble((MobEntity)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, EntityCitizen.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAICitizenWander(this, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAIMournCitizen(this, 0.6));
    }

    public boolean func_184645_a(PlayerEntity player, @NotNull Hand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return false;
        }
        if (!ItemStackUtils.isEmpty(player.func_184586_b(hand)).booleanValue() && player.func_184586_b(hand).func_77973_b() instanceof NameTagItem) {
            return super.func_184645_a(player, hand);
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K && iColonyView != null) {
            if (player.func_225608_bj_()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.func_200200_C_().func_150254_d(), this.func_145782_y()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        return true;
    }

    public String func_195047_I_() {
        return this.func_200200_C_().func_150254_d() + " (" + this.getCivilianID() + ")";
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("status", this.citizenStatusHandler.getStatus().ordinal());
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.func_74768_a("colony", this.citizenColonyHandler.getColony().getID());
            compound.func_74768_a("citizen", this.citizenData.getId());
        }
        compound.func_74757_a("mourning", this.mourning);
        this.citizenDiseaseHandler.write(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.citizenStatusHandler.setStatus(Status.values()[compound.func_74762_e("status")]);
        this.citizenColonyHandler.setColonyId(compound.func_74762_e("colony"));
        this.citizenId = compound.func_74762_e("citizen");
        if (compound.func_150296_c().contains("mourning")) {
            this.mourning = compound.func_74767_n("mourning");
        }
        this.citizenDiseaseHandler.read(compound);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.entityStatemachine.tick();
    }

    public boolean refreshCitizenDataView() {
        IColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a())) != null) {
            this.citizenDataView = colonyView.getCitizen(this.citizenId);
            this.getNavigator().getPathingOptions().setCanUseRails(this.canPathOnRails());
        }
        return false;
    }

    private boolean onTickDecrements() {
        this.decrementCallForHelpCooldown();
        this.decreaseWalkingSaturation();
        return false;
    }

    private boolean onServerUpdateHandlers() {
        this.citizenExperienceHandler.gatherXp();
        this.citizenItemHandler.pickupItems();
        this.citizenData.setLastPosition(this.func_180425_c());
        this.citizenDiseaseHandler.tick();
        this.onLivingSoundUpdate();
        return false;
    }

    private boolean updateVisualData() {
        ItemStack hat = this.func_184582_a(EquipmentSlotType.HEAD);
        if (LocalDate.now(Clock.systemDefaultZone()).getMonth() == Month.DECEMBER && ((Boolean)MineColonies.getConfig().getCommon().holidayFeatures.get()).booleanValue() && !(this.getCitizenJobHandler().getColonyJob() instanceof JobStudent)) {
            if (hat.func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.santaHat));
            }
        } else if (!hat.func_190926_b() && hat.func_77973_b() == ModItems.santaHat) {
            this.func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
        }
        this.func_174805_g((Boolean)MineColonies.getConfig().getCommon().alwaysRenderNameTag.get());
        if (!this.citizenColonyHandler.getColony().getStyle().equals(this.func_184212_Q().func_187225_a(DATA_STYLE))) {
            this.func_184212_Q().func_187227_b(DATA_STYLE, (Object)this.citizenColonyHandler.getColony().getStyle());
        }
        if (!this.citizenData.getTextureSuffix().equals(this.func_184212_Q().func_187225_a(DATA_TEXTURE_SUFFIX))) {
            this.func_184212_Q().func_187227_b(DATA_TEXTURE_SUFFIX, (Object)this.citizenData.getTextureSuffix());
        }
        return false;
    }

    private boolean updateSaturation() {
        this.checkHeal();
        if (this.citizenData.getSaturation() <= 0.0) {
            if (this.func_70660_b(Effects.field_76421_d) == null) {
                this.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
            }
        } else {
            this.func_195063_d(Effects.field_76421_d);
        }
        return false;
    }

    private void decrementCallForHelpCooldown() {
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
    }

    public boolean canPathOnRails() {
        if (this.field_70170_p.field_72995_K) {
            UnlockAbilityResearchEffect effect;
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
            if (colonyView != null && (effect = colonyView.getResearchManager().getResearchEffects().getEffect("Rails", UnlockAbilityResearchEffect.class)) != null) {
                return effect.getEffect();
            }
            return false;
        }
        UnlockAbilityResearchEffect effect = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Rails", UnlockAbilityResearchEffect.class);
        if (effect != null) {
            return effect.getEffect();
        }
        return false;
    }

    private void decreaseWalkingSaturation() {
        if (this.field_70140_Q - this.lastDistanceWalked > 25.0f) {
            this.lastDistanceWalked = this.field_70140_Q;
            this.decreaseSaturationForContinuousAction();
        }
    }

    private void checkHeal() {
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            double limitDecrease = 0.0;
            AdditionModifierResearchEffect satLimitDecrease = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Healing Saturation Limit", AdditionModifierResearchEffect.class);
            if (satLimitDecrease != null) {
                limitDecrease = satLimitDecrease.getEffect();
            }
            double healAmount = 1.0;
            if (this.citizenData.getSaturation() >= 10.0 - limitDecrease) {
                healAmount += 1.0;
            } else if (this.citizenData.getSaturation() < 3.0) {
                healAmount = 0.0;
                return;
            }
            AdditionModifierResearchEffect healEffect = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Regeneration", AdditionModifierResearchEffect.class);
            if (healEffect != null) {
                healAmount *= 1.0 + healEffect.getEffect();
            }
            this.func_70691_i((float)healAmount);
            if (healAmount > 0.1) {
                this.citizenData.markDirty();
            }
        }
    }

    private void onLivingSoundUpdate() {
        if (WorldUtil.isDayTime(this.field_70170_p)) {
            SoundUtils.playRandomSound(this.field_70170_p, this.func_180425_c(), this.citizenData);
        }
    }

    public boolean func_70631_g_() {
        return this.child;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.field_70180_af.func_187214_a(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        if (this.citizenJobHandler.getColonyJob() != null && ((Boolean)MineColonies.getConfig().getCommon().enableInDevelopmentFeatures.get()).booleanValue()) {
            this.func_200203_b((ITextComponent)new StringTextComponent(this.citizenData.getName() + " (" + (Object)((Object)this.citizenStatusHandler.getStatus()) + ")[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]"));
        }
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Override
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null) {
            this.citizenData = (ICitizenData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @Override
    public void setCitizensize(@NotNull float width, @NotNull float height) {
        this.field_213325_aI = new EntitySize(width, height, false);
    }

    @Override
    public void setIsChild(boolean isChild) {
        if (isChild && !this.child) {
            this.field_70714_bg.func_75776_a(50, (Goal)new EntityAICitizenChild(this));
            this.setCitizensize(0.3f, 0.9f);
        } else {
            if (!isChild && this.child) {
                this.getCitizenJobHandler().setModelDependingOnJob(this.citizenJobHandler.getColonyJob());
            }
            this.setCitizensize(0.6f, 1.8f);
        }
        this.child = isChild;
        this.func_184212_Q().func_187227_b(DATA_IS_CHILD, (Object)isChild);
        this.markDirty();
    }

    @Override
    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(this.field_70170_p, this.func_180425_c(), EventType.DANGER, this.getCitizenData());
        }
    }

    @Override
    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    @Override
    public ICitizenStatusHandler getCitizenStatusHandler() {
        return this.citizenStatusHandler;
    }

    @Override
    public ICitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void setCitizenDiseaseHandler(ICitizenDiseaseHandler citizenDiseaseHandler) {
        this.citizenDiseaseHandler = citizenDiseaseHandler;
    }

    @Override
    public boolean isOkayToEat() {
        return !this.getCitizenSleepHandler().isAsleep() && this.getDesiredActivity() != DesiredActivity.SLEEP && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().canAIBeInterrupted());
    }

    @Override
    public boolean shouldBeFed() {
        return this.getCitizenData() != null && this.getCitizenData().getSaturation() <= 5.0 && !this.getCitizenData().justAte();
    }

    @Override
    public boolean isIdlingAtJob() {
        return this.isOkayToEat() && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().isIdling());
    }

    private boolean determineDesiredActivity() {
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        if (this.getCitizenColonyHandler().getColony().getRaiderManager().isRaided()) {
            this.setVisibleStatusIfNone(VisibleCitizenStatus.RAIDED);
            this.desiredActivity = DesiredActivity.SLEEP;
            return false;
        }
        if (this.getCitizenColonyHandler().getColony().isMourning() && this.mourning) {
            this.setVisibleStatusIfNone(VisibleCitizenStatus.MOURNING);
            this.desiredActivity = DesiredActivity.MOURN;
            return false;
        }
        if (!WorldUtil.isPastTime(CompatibilityUtils.getWorldFromCitizen(this), 10600)) {
            if (this.desiredActivity == DesiredActivity.SLEEP) {
                this.setVisibleStatusIfNone(VisibleCitizenStatus.SLEEP);
                return false;
            }
            if (this.citizenSleepHandler.shouldGoSleep()) {
                this.citizenData.onGoSleep();
                this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() * 2.0);
                this.citizenData.markDirty();
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.sleeping", new Object[0])});
                this.desiredActivity = DesiredActivity.SLEEP;
                return false;
            }
        }
        if (this.citizenSleepHandler.isAsleep() && !this.citizenDiseaseHandler.isSick()) {
            this.citizenSleepHandler.onWakeUp();
        }
        if (CompatibilityUtils.getWorldFromCitizen(this).func_72896_J() && !this.shouldWorkWhileRaining()) {
            this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.waiting", new Object[0]), new TranslationTextComponent("com.minecolonies.coremod.status.rainStop", new Object[0])});
            this.setVisibleStatusIfNone(VisibleCitizenStatus.BAD_WEATHER);
            this.desiredActivity = DesiredActivity.IDLE;
            return false;
        }
        if (this.func_70631_g_() && this.getCitizenJobHandler().getColonyJob() instanceof JobPupil && this.field_70170_p.func_72820_D() % 24000L > 6000L) {
            this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
            this.desiredActivity = DesiredActivity.IDLE;
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
        this.desiredActivity = DesiredActivity.IDLE;
        return false;
    }

    private void setVisibleStatusIfNone(VisibleCitizenStatus status) {
        if (this.getCitizenData().getStatus() == null) {
            this.getCitizenData().setVisibleStatus(status);
        }
    }

    @Override
    @NotNull
    public DesiredActivity getDesiredActivity() {
        return this.desiredActivity;
    }

    private boolean shouldWorkWhileRaining() {
        UnlockAbilityResearchEffect effect = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Working in Rain", UnlockAbilityResearchEffect.class);
        if (effect != null) {
            return effect.getEffect();
        }
        return (Boolean)MineColonies.getConfig().getCommon().workersAlwaysWorkInRain.get() != false || this.citizenColonyHandler.getWorkBuilding() != null && this.citizenColonyHandler.getWorkBuilding().canWorkDuringTheRain();
    }

    @Override
    public boolean isMourning() {
        return this.mourning;
    }

    @Override
    public void setMourning(boolean mourning) {
        this.mourning = mourning;
    }

    @Override
    public float getRotationYaw() {
        return this.field_70177_z;
    }

    @Override
    public float getRotationPitch() {
        return this.field_70125_A;
    }

    @Override
    public boolean isDead() {
        return !this.func_70089_S();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
        this.citizenSleepHandler = citizenSleepHandler;
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenItemHandler(ICitizenItemHandler citizenItemHandler) {
        this.citizenItemHandler = citizenItemHandler;
    }

    @Override
    public void setCitizenChatHandler(ICitizenChatHandler citizenChatHandler) {
        this.citizenChatHandler = citizenChatHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    public boolean func_70097_a(@NotNull DamageSource damageSource, float damage) {
        if (this.handleInWallDamage(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.func_76346_g();
        if (this.handleSourceEntityForDamage(sourceEntity)) {
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null && this.getCitizenJobHandler().getColonyJob().ignoresDamage(damageSource)) {
            return false;
        }
        return this.handleDamagePerformed(damageSource, damage, sourceEntity);
    }

    private boolean handleInWallDamage(@NotNull DamageSource damageSource) {
        if (damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l())) {
            TeleportHelper.teleportCitizen(this, this.field_70170_p, this.func_180425_c().func_177982_a(0, 1, 0));
            return true;
        }
        return damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l()) && this.citizenSleepHandler.isAsleep() || Compatibility.isDynTreePresent() && damageSource.field_76373_n.equals(Compatibility.getDynamicTreeDamage()) || this.func_190530_aW();
    }

    private boolean handleSourceEntityForDamage(Entity sourceEntity) {
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return true;
            }
            IColony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColony();
            if (attackerColony != null && this.citizenColonyHandler.getColony() != null) {
                IPermissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColony().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), Rank.HOSTILE);
            }
        }
        if (sourceEntity instanceof ServerPlayerEntity) {
            if (this.citizenColonyHandler.getColony().getRaiderManager().isRaided()) {
                return false;
            }
            if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                return !IGuardBuilding.checkIfGuardShouldTakeDamage(this, (PlayerEntity)sourceEntity);
            }
        }
        return false;
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
        if ((pos.field_72450_a != 0.0 || pos.field_72449_c != 0.0) && this.getCitizenData() != null && this.getCitizenData().isAsleep()) {
            this.getCitizenSleepHandler().onWakeUp();
        }
        super.func_213315_a(typeIn, pos);
    }

    public float func_70689_ay() {
        return (float)Math.min(0.5, (double)super.func_70689_ay());
    }

    private boolean handleDamagePerformed(@NotNull DamageSource damageSource, float damage, Entity sourceEntity) {
        float damageInc = Math.min(damage, this.func_110138_aP() * 0.2f);
        if (!this.field_70170_p.field_72995_K) {
            this.performMoveAway(sourceEntity);
        }
        this.func_130011_c(damageSource.func_76346_g());
        if (!this.field_70170_p.field_72995_K && this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenData != null) {
            MultiplierModifierResearchEffect effect;
            if (this.citizenJobHandler.getColonyJob() instanceof JobKnight && (effect = this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffect("Block Attacks", MultiplierModifierResearchEffect.class)) != null && this.getRandom().nextDouble() < effect.getEffect()) {
                return false;
            }
            if (this.citizenData.getWorkBuilding() instanceof AbstractBuildingGuards && ((AbstractBuildingGuards)this.citizenData.getWorkBuilding()).shallRetrieveOnLowHealth() && (double)this.func_110143_aJ() < (double)((int)this.func_110138_aP()) * 0.2 && (effect = this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffect("Fleeing Damage", MultiplierModifierResearchEffect.class)) != null) {
                damageInc = (float)((double)damageInc * (1.0 - effect.getEffect()));
            }
        }
        boolean result = super.func_70097_a(damageSource, damageInc);
        if (damageSource.func_82725_o() || damageSource.func_76347_k()) {
            return result;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.citizenItemHandler.updateArmorDamage(damageInc);
            if (this.citizenData != null) {
                this.getCitizenData().getCitizenHappinessHandler().getModifier("damage").reset();
            }
        }
        return result;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        this.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.avoiding", new Object[0])});
        if (!(attacker instanceof LivingEntity)) {
            if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
                this.moveAwayPath = this.getNavigator().moveAwayFromLivingEntity((Entity)this, 5.0, 1.1);
            }
            return;
        }
        this.currentlyFleeing = true;
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.callForHelp(attacker, 90000);
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.moveAwayPath = this.getNavigator().moveAwayFromLivingEntity(attacker, 15.0, 1.1);
        }
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof LivingEntity) || !((Boolean)MineColonies.getConfig().getCommon().citizenCallForHelp.get()).booleanValue() || this.callForHelpCooldown != 0) {
            return;
        }
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenJobHandler.getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return;
        }
        this.callForHelpCooldown = 100;
        ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
        for (ICitizenData entry : this.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens()) {
            if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || entry.getId() == this.citizenData.getId() || BlockPosUtil.getDistanceSquared(entry.getEntity().get().func_180425_c(), this.func_180425_c()) >= (long)guardHelpRange || entry.getJob().getWorkerAI() == null || !((AbstractEntityAIGuard)((Object)entry.getJob().getWorkerAI())).canHelp()) continue;
            possibleGuards.add(entry.getEntity().get());
        }
        Collections.sort(possibleGuards, Comparator.comparingInt(guard -> (int)this.func_180425_c().func_177951_i((Vec3i)guard.func_180425_c())));
        for (int i = 0; i < possibleGuards.size() && i <= 2; ++i) {
            ((AbstractEntityAIGuard)((Object)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI())).startHelpCitizen(this, (LivingEntity)attacker);
        }
    }

    protected void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (!this.field_70170_p.field_72995_K && entity instanceof AbstractEntityCitizen) {
            this.getCitizenDiseaseHandler().onCollission((AbstractEntityCitizen)entity);
        }
    }

    public void func_70645_a(@NotNull DamageSource damageSource) {
        this.currentlyFleeing = false;
        if (this.citizenColonyHandler.getColony() != null && this.getCitizenData() != null) {
            this.citizenColonyHandler.getColony().getRaiderManager().onLostCitizen(this.getCitizenData());
            this.citizenExperienceHandler.dropExperience();
            this.func_70106_y();
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColony().getCitizenManager().updateModifier("death");
            }
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            this.citizenChatHandler.notifyDeath(damageSource);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) && damageSource != DamageSource.field_76368_d) {
                this.citizenColonyHandler.getColony().setNeedToMourn(true, this.citizenData.getName());
            }
            if (this.citizenData.getJob() != null) {
                this.citizenData.getJob().onRemoval();
            }
            this.citizenColonyHandler.getColony().getCitizenManager().removeCivilian(this.getCitizenData());
            InventoryUtils.dropItemHandler((IItemHandler)this.citizenData.getInventory(), this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            String deathCause = damageSource.func_151519_b((LivingEntity)this).func_150255_a(new Style()).func_150254_d().replaceFirst(this.func_145748_c_().func_150254_d(), "Citizen");
            this.citizenColonyHandler.getColony().getEventDescriptionManager().addEventDescription(new CitizenDiedEvent(this.func_180425_c(), this.citizenData.getName(), deathCause));
        }
        super.func_70645_a(damageSource);
    }

    private void triggerDeathAchievement(DamageSource source, IJob<?> job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    protected void func_213337_cE() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }

    public int func_70658_aO() {
        MultiplierModifierResearchEffect effect;
        if (this.citizenJobHandler.getColonyJob() instanceof JobKnight) {
            MultiplierModifierResearchEffect effect2 = this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffect("Melee Armour", MultiplierModifierResearchEffect.class);
            if (effect2 != null) {
                return (int)((double)super.func_70658_aO() * (1.0 + effect2.getEffect()));
            }
        } else if (this.citizenJobHandler.getColonyJob() instanceof JobRanger && (effect = this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffect("Archer Armour", MultiplierModifierResearchEffect.class)) != null) {
            return (int)((double)super.func_70658_aO() * (1.0 + effect.getEffect()));
        }
        return super.func_70658_aO();
    }

    protected void func_184590_k(float damage) {
        if (this.func_184586_b(this.func_184600_cs()).func_77973_b() instanceof ShieldItem) {
            if (this.func_110143_aJ() > damage * 0.5f) {
                float blockDamage = CombatRules.func_189427_a((float)(damage * 0.5f), (float)this.func_70658_aO(), (float)((float)this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                this.func_70606_j(this.func_110143_aJ() - Math.max(0.5f, blockDamage));
            }
            this.citizenItemHandler.damageItemInHand(this.func_184600_cs(), (int)(damage * 0.5f));
        }
        super.func_184590_k(damage);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ICitizenData data = this.getCitizenData();
            if (data == null) {
                return super.getCapability(capability, facing);
            }
            InventoryCitizen inv = data.getInventory();
            return LazyOptional.of(() -> inv);
        }
        return super.getCapability(capability, facing);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)obj;
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public void func_70106_y() {
        this.citizenColonyHandler.onCitizenRemoved();
        super.func_70106_y();
    }

    public Team func_96124_cp() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K && this.cachedTeamName == null) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return this.field_70170_p.func_96441_U().func_96508_e(this.cachedTeamName);
        }
        if (this.getCitizenColonyHandler().getColony() != null) {
            return this.getCitizenColonyHandler().getColony().getTeam();
        }
        return null;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColony() != null && name != null) {
            if (!name.func_150254_d().contains(this.citizenData.getName()) && (Integer)MineColonies.getConfig().getCommon().allowGlobalNameChanges.get() >= 0) {
                if ((Integer)MineColonies.getConfig().getCommon().allowGlobalNameChanges.get() == 0 && ((List)MineColonies.getConfig().getCommon().specialPermGroup.get()).stream().noneMatch(owner -> owner.equals(this.citizenColonyHandler.getColony().getPermissions().getOwnerName()))) {
                    LanguageHandler.sendPlayersMessage(this.citizenColonyHandler.getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.citizen.rename.notallowed", (Object[])new Object[0]);
                    return;
                }
                if (this.citizenColonyHandler.getColony() != null) {
                    for (ICitizenData citizen : this.citizenColonyHandler.getColony().getCitizenManager().getCitizens()) {
                        if (!citizen.getName().equals(name.func_150254_d())) continue;
                        LanguageHandler.sendPlayersMessage(this.citizenColonyHandler.getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.citizen.rename.same", (Object[])new Object[0]);
                        return;
                    }
                    this.citizenData.setName(name.func_150254_d());
                    this.citizenData.markDirty();
                    super.func_200203_b(name);
                }
                return;
            }
            super.func_200203_b(name);
        }
    }

    public void func_70656_aK() {
        super.func_70656_aK();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
    }

    public boolean func_213392_I() {
        return true;
    }

    @NotNull
    public BlockPos func_213384_dI() {
        IBuilding homeBuilding = this.citizenColonyHandler.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getPosition();
        }
        if (this.citizenColonyHandler.getColony() != null && this.citizenColonyHandler.getColony().getBuildingManager().getTownHall() != null) {
            return this.citizenColonyHandler.getColony().getBuildingManager().getTownHall().getPosition();
        }
        return super.func_213384_dI();
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        if (entity instanceof SittingEntity || force) {
            return super.func_184205_a(entity, force);
        }
        return false;
    }

    @Override
    public boolean isCurrentlyFleeing() {
        return this.currentlyFleeing;
    }

    @Override
    public void setFleeingState(boolean fleeing) {
        this.currentlyFleeing = fleeing;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150787_b(this.citizenColonyHandler.getColonyId());
        buffer.func_150787_b(this.citizenId);
        return new ContainerCitizenInventory(id, inv, buffer);
    }

    @Override
    public void setTexture() {
        super.setTexture();
    }

    @Override
    public void updatePose(Pose pose) {
        this.func_213301_b(pose);
    }

    private static enum EntityState implements IState
    {
        INIT,
        ACTIVE_SERVER,
        ACTIVE_CLIENT,
        INACTIVE;

    }
}

