/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            if (job != null) {
                TranslationTextComponent component = new TranslationTextComponent("block.blockhuttownhall.messageworkerdead", new Object[]{new TranslationTextComponent(job.getName().toLowerCase(), new Object[0]), this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, new TranslationTextComponent(damageSource.field_76373_n, new Object[0])});
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), (String)"", (Object[])new Object[]{component});
            } else {
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), (String)"", (Object[])new Object[]{new TranslationTextComponent("block.blockhuttownhall.messagecolonistdead", new Object[]{this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, new TranslationTextComponent(damageSource.field_76373_n, new Object[0])})});
            }
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        String key = keyIn.toLowerCase(Locale.US);
        if (msg == null) {
            return;
        }
        TranslationTextComponent requiredItem = msg.length == 0 ? new TranslationTextComponent(key, new Object[0]) : new TranslationTextComponent(key, msg);
        StringTextComponent citizenDescription = new StringTextComponent(this.citizen.func_200201_e().func_150254_d());
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            StringTextComponent colonyDescription = new StringTextComponent(" at " + this.citizen.getCitizenColonyHandler().getColony().getName() + ": ");
            ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>(this.citizen.getCitizenColonyHandler().getColony().getMessagePlayerEntities());
            PlayerEntity owner = ServerUtils.getPlayerFromUUID(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.getCitizenColonyHandler().getColony().getPermissions().getOwner());
            if (owner != null) {
                players.remove(owner);
                LanguageHandler.sendPlayerMessage((PlayerEntity)owner, (String)(this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName()), (Object[])new Object[]{" ", citizenDescription, requiredItem});
            }
            LanguageHandler.sendPlayersMessage(players, (String)(this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName()), (Object[])new Object[]{" ", citizenDescription, colonyDescription, requiredItem});
        }
    }
}

