/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.PathingConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.entity.pathfinding.ChunkCache;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.util.WorkerUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.ScaffoldingBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path> {
    @Nullable
    public static Set<Node> lastDebugNodesVisited;
    @Nullable
    public static Set<Node> lastDebugNodesNotVisited;
    @Nullable
    public static Set<Node> lastDebugNodesPath;
    @NotNull
    protected final BlockPos start;
    @NotNull
    protected final IWorldReader world;
    protected final PathResult result;
    private final int maxRange;
    private final Queue<Node> nodesOpen = new PriorityQueue<Node>(500);
    private final Map<Integer, Node> nodesVisited = new HashMap<Integer, Node>();
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<Node> debugNodesVisited = null;
    @Nullable
    protected Set<Node> debugNodesNotVisited = null;
    @Nullable
    protected Set<Node> debugNodesPath = null;
    private boolean allowJumpPointSearchTypeWalk;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    private boolean xzRestricted = false;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    protected WeakReference<LivingEntity> entity;

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.func_177958_n(), end.func_177958_n()) - range / 2;
        int minZ = Math.min(start.func_177952_p(), end.func_177952_p()) - range / 2;
        int maxX = Math.max(start.func_177958_n(), end.func_177958_n()) + range / 2;
        int maxZ = Math.max(start.func_177952_p(), end.func_177952_p()) + range / 2;
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 256, maxZ), range);
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (((Boolean)MineColonies.getConfig().getCommon().pathfindingDebugDraw.get()).booleanValue()) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(World world, BlockPos startRestriction, BlockPos endRestriction, PathResult result, LivingEntity entity) {
        this.minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        this.minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        this.maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        this.maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        this.xzRestricted = true;
        int range = (int)Math.sqrt(Math.pow(this.maxX - this.minX, 2.0) + Math.pow(this.maxZ - this.minZ, 2.0)) * 2;
        this.world = new ChunkCache(world, new BlockPos(this.minX, 0, this.minZ), new BlockPos(this.maxX, 256, this.maxZ), range);
        this.start = new BlockPos((this.minX + this.maxX) / 2, (startRestriction.func_177956_o() + endRestriction.func_177956_o()) / 2, (this.minZ + this.maxZ) / 2);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().pathfindingDebugDraw.get()).booleanValue()) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    private static boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder() && (dPos.func_177956_o() >= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0);
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        BlockPos.Mutable pos = new BlockPos.Mutable(MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226278_cu_()), MathHelper.func_76128_c((double)entity.func_226281_cx_()));
        BlockState bs = CompatibilityUtils.getWorldFromEntity((Entity)entity).func_180495_p((BlockPos)pos);
        VoxelShape collisionShape = bs.func_196952_d((IBlockReader)entity.field_70170_p, (BlockPos)pos);
        if (bs.func_185904_a().func_76230_c() && collisionShape.func_197758_c(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.func_226277_ct_() % 1.0);
            double relPosZ = Math.abs(entity.func_226281_cx_() % 1.0);
            for (AxisAlignedBB box : collisionShape.func_197756_d()) {
                if (!(relPosX >= box.field_72340_a) || !(relPosX <= box.field_72336_d) || !(relPosZ >= box.field_72339_c) || !(relPosZ <= box.field_72334_f) || !(box.field_72337_e > 0.0)) continue;
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                bs = CompatibilityUtils.getWorldFromEntity((Entity)entity).func_180495_p((BlockPos)pos);
                break;
            }
        }
        Block b = bs.func_177230_c();
        if (entity.func_70090_H()) {
            while (bs.func_185904_a().func_76224_d()) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                bs = CompatibilityUtils.getWorldFromEntity((Entity)entity).func_180495_p((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.func_185904_a().func_76220_a()) {
            double dX = entity.func_226277_ct_() - Math.floor(entity.func_226277_ct_());
            double dZ = entity.func_226281_cx_() - Math.floor(entity.func_226281_cx_());
            if (dX < 0.25) {
                pos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            } else if (dX > 0.75) {
                pos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            if (dZ < 0.25) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            } else if (dZ > 0.75) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos.func_185334_h();
    }

    private static void setLadderFacing(@NotNull IWorldReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof VineBlock) {
            if (((Boolean)state.func_177229_b((IProperty)VineBlock.field_176279_N)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.func_177229_b((IProperty)VineBlock.field_176280_O)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.func_177229_b((IProperty)VineBlock.field_176273_b)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.func_177229_b((IProperty)VineBlock.field_176278_M)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (state.func_177230_c() instanceof ScaffoldingBlock) {
            p.setLadderFacing(Direction.UP);
        } else {
            p.setLadderFacing((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a));
        }
    }

    private static boolean onALadder(@NotNull Node node, @Nullable Node nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.func_177958_n() == pos.func_177958_n() && nextInPath.pos.func_177952_p() == pos.func_177952_p();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.func_177958_n() & 0xFFF) << 20 | (pos.func_177956_o() & 0xFF) << 12 | pos.func_177952_p() & 0xFFF;
    }

    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.func_177958_n() * dPos.func_177958_n() + dPos.func_177956_o() * dPos.func_177956_o() + dPos.func_177952_p() * dPos.func_177952_p());
        if (!(dPos.func_177956_o() == 0 || dPos.func_177958_n() == 0 && dPos.func_177952_p() == 0 || Math.abs(dPos.func_177956_o()) <= 1 && this.world.func_180495_p(blockPos).func_177230_c() instanceof StairsBlock)) {
            cost *= this.pathingOptions.jumpDropCost * (double)Math.abs(dPos.func_177956_o());
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    private static boolean nodeClosed(@Nullable Node node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(@NotNull IWorldReader world, @NotNull BlockPos pos, @Nullable Node node) {
        return node == null ? world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() : node.isSwimming();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        Node bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > (Integer)MineColonies.getConfig().getCommon().pathfindingMaxNodes.get() || this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            if (this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (nodeResultScore < bestNodeResultScore) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.xzRestricted && (currentNode.pos.func_177958_n() < this.minX || currentNode.pos.func_177958_n() > this.maxX || currentNode.pos.func_177952_p() < this.minZ || currentNode.pos.func_177952_p() > this.maxZ)) continue;
            this.walkCurrentNode(currentNode);
        }
        Path path = this.finalizePath(bestNode);
        this.handleDebugDraw();
        return path;
    }

    private void handleDebugOptions(Node currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        if ((Integer)MineColonies.getConfig().getCommon().pathfindingDebugVerbosity.get() == 2) {
            Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.func_177958_n(), currentNode.pos.func_177956_o(), currentNode.pos.func_177952_p(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(Node currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(Node node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(@NotNull Node currentNode) {
        BlockPos dPos = PathingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.func_177973_b((Vec3i)currentNode.parent.pos);
        }
        if (AbstractPathJob.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.func_177952_p() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.func_177958_n() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_EAST);
        }
        if (dPos.func_177952_p() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.func_177958_n() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_WEST);
        }
    }

    private boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return (dPos.func_177956_o() <= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0) && this.isLadder(currentNode.pos.func_177977_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = PathingConstants.debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    @NotNull
    private Node getAndSetupStartNode() {
        Node startNode = new Node(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.world.func_180495_p(this.start.func_177977_b()).func_185904_a().func_76224_d()) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.func_180495_p(this.start).func_177230_c() instanceof AbstractRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    @NotNull
    private Path finalizePath(Node targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        Node node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        PathPoint[] points = new PathPoint[pathLength];
        points[0] = new PathPointExtended(node.pos);
        Node nextInPath = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.func_177971_a((Vec3i)PathingConstants.BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= (Integer)MineColonies.getConfig().getCommon().minimumRailsToPath.get()) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.func_177956_o() > pos.func_177956_o()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected BlockPos getPathTargetPos(Node finalNode) {
        return finalNode.pos;
    }

    private void doDebugPrinting(@NotNull PathPoint[] points) {
        if ((Integer)MineColonies.getConfig().getCommon().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info("Path found:");
            for (PathPoint p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.field_75839_a, p.field_75837_b, p.field_75838_c));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(Node var1);

    protected abstract double getNodeResultScore(Node var1);

    protected final boolean walk(@NotNull Node parent, @NotNull BlockPos dPos) {
        int nodeKey;
        Node node;
        BlockPos pos = parent.pos.func_177971_a((Vec3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < 0) {
            return false;
        }
        if (pos.func_177956_o() != newY) {
            dPos = dPos.func_177982_a(0, newY - pos.func_177956_o(), 0);
            pos = new BlockPos(pos.func_177958_n(), newY, pos.func_177952_p());
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        boolean onRoad = WorkerUtil.isPathBlock(this.world.func_180495_p(pos.func_177977_b()).func_177230_c());
        boolean onRails = this.pathingOptions.canUseRails() && this.world.func_180495_p(pos).func_177230_c() instanceof AbstractRailBlock;
        boolean railsExit = !onRails && parent != null && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRoad, onRails, railsExit, swimStart, pos);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(@NotNull Node parent, @NotNull BlockPos dPos, @NotNull Node node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private Node createNode(Node parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        Node node = new Node(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(@NotNull Node parent, @NotNull Node node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.func_177984_a(), this.world.func_180495_p(pos.func_177984_a()));
        }
        BlockState target = this.world.func_180495_p(pos);
        if (!this.isPassable(target, pos)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        BlockState below = this.world.func_180495_p(pos.func_177977_b());
        SurfaceType walkability = this.isWalkableSurface(below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.func_177956_o();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -1;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable Node parent, @NotNull BlockPos pos, @NotNull BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (below.func_185904_a().func_76224_d()) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.func_177230_c(), pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable Node parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || isSwimming) {
            return -1;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.world.func_180495_p(pos.func_177979_c(i));
            if (this.isWalkableSurface(below, pos) == SurfaceType.WALKABLE && i <= 4 || below.func_185904_a().func_76224_d()) {
                return pos.func_177956_o() - i + 1;
            }
            if (below.func_185904_a() == Material.field_151579_a) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.func_177956_o();
        }
        if (this.pathingOptions.canSwim() && below.func_185904_a() == Material.field_151586_h) {
            return pos.func_177956_o();
        }
        return -1;
    }

    private int handleTargetNotPassable(@Nullable Node parent, @NotNull BlockPos pos, @NotNull BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || this.isWalkableSurface(target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.func_177981_b(2), false)) {
            bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            bb2 = this.world.func_180495_p(pos.func_177981_b(2)).func_196952_d((IBlockReader)this.world, pos.func_177981_b(2));
            if ((double)pos.func_177981_b(2).func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        if (!this.isPassable(parent.pos.func_177981_b(2), false)) {
            bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            bb2 = this.world.func_180495_p(parent.pos.func_177981_b(2)).func_196952_d((IBlockReader)this.world, parent.pos.func_177981_b(2));
            if ((double)parent.pos.func_177981_b(2).func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        BlockState parentBelow = this.world.func_180495_p(parent.pos.func_177977_b());
        VoxelShape parentBB = parentBelow.func_196952_d((IBlockReader)this.world, parent.pos.func_177977_b());
        double parentY = parentBB.func_197758_c(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.func_177977_b().func_177956_o();
        double targetMaxY = target.func_196952_d((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.Y) + (double)pos.func_177956_o();
        if (targetMaxY - parentMaxY < 1.3) {
            return pos.func_177956_o() + 1;
        }
        if (target.func_177230_c() instanceof StairsBlock && parentY - 0.5 < 1.3 && target.func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM && BlockPosUtil.getXZFacing(parent.pos, pos) == target.func_177229_b((IProperty)StairsBlock.field_176309_a)) {
            return pos.func_177956_o() + 1;
        }
        return -1;
    }

    private boolean checkHeadBlock(@Nullable Node parent, @NotNull BlockPos pos) {
        BlockPos localPos = pos;
        VoxelShape bb = this.world.func_180495_p(localPos).func_196952_d((IBlockReader)this.world, localPos);
        if (bb.func_197758_c(Direction.Axis.Y) < 1.0) {
            localPos = pos.func_177984_a();
        }
        if (!this.isPassable(pos.func_177984_a(), true)) {
            VoxelShape bb1 = this.world.func_180495_p(pos.func_177977_b()).func_196952_d((IBlockReader)this.world, pos.func_177977_b());
            VoxelShape bb2 = this.world.func_180495_p(pos.func_177984_a()).func_196952_d((IBlockReader)this.world, pos.func_177984_a());
            if ((double)pos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177977_b().func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.world.func_180495_p(parent.pos.func_177977_b()).func_196952_d((IBlockReader)this.world, pos.func_177977_b());
                if ((double)pos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)parent.pos.func_177977_b().func_177956_o() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState hereState = this.world.func_180495_p(localPos.func_177977_b());
            VoxelShape bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            VoxelShape bb2 = this.world.func_180495_p(localPos.func_177984_a()).func_196952_d((IBlockReader)this.world, localPos.func_177984_a());
            if ((double)localPos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return hereState.func_185904_a().func_76224_d() && !this.isPassable(pos, false);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.func_197766_b() ? (double)def : bb.func_197762_b(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.func_197766_b() ? (double)def : bb.func_197758_c(Direction.Axis.Y);
    }

    protected boolean isPassable(@NotNull BlockState block, BlockPos pos) {
        if (block.func_185904_a() != Material.field_151579_a) {
            if (block.func_185904_a().func_76230_c()) {
                return this.pathingOptions.canEnterDoors() && (block.func_177230_c() instanceof DoorBlock || block.func_177230_c() instanceof FenceGateBlock || block.func_177230_c() instanceof TrapDoorBlock && !(this.world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof TrapDoorBlock)) || block.func_177230_c() instanceof AbstractBlockMinecoloniesConstructionTape || block.func_177230_c() instanceof PressurePlateBlock || block.func_177230_c() instanceof BlockDecorationController || block.func_177230_c() instanceof AbstractSignBlock || this.isLadder(block.func_177230_c(), pos) || block.func_177230_c() instanceof AbstractBannerBlock;
            }
            if (block.func_177230_c() instanceof FireBlock) {
                return false;
            }
            VoxelShape shape = block.func_196952_d((IBlockReader)this.world, pos);
            return this.isLadder(block.func_177230_c(), pos) || (shape.func_197766_b() || shape.func_197758_c(Direction.Axis.Y) <= 0.1) && !block.func_185904_a().func_76224_d() && (block.func_177230_c() != Blocks.field_150433_aE || (Integer)block.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) && block.func_177230_c() != Blocks.field_222434_lW;
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos, boolean head) {
        BlockState state = this.world.func_180495_p(pos);
        VoxelShape shape = state.func_196952_d((IBlockReader)this.world, pos);
        if (shape.func_197766_b() || shape.func_197758_c(Direction.Axis.Y) <= 0.1) {
            return !head || !(state.func_177230_c() instanceof CarpetBlock) && !(state.func_177230_c() instanceof BlockFloatingCarpet) || this.isLadder(state.func_177230_c(), pos);
        }
        return this.isPassable(state, pos);
    }

    @NotNull
    protected SurfaceType isWalkableSurface(@NotNull BlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof AbstractBlockMinecoloniesDefault || block instanceof AbstractBlockBarrel || block instanceof BambooBlock || blockState.func_196954_c((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.Y) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        IFluidState fluid = this.world.func_204610_c(pos);
        if (!(fluid == null || fluid.func_206888_e() || fluid.func_206886_c() != Fluids.field_204547_b && fluid.func_206886_c() != Fluids.field_207213_d)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (block instanceof AbstractBlockMinecoloniesConstructionTape || block instanceof AbstractSignBlock) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.func_185904_a().func_76220_a() || blockState.func_177230_c() == Blocks.field_150433_aE && (Integer)blockState.func_177229_b((IProperty)SnowBlock.field_176315_a) > 1 || block instanceof BlockFloatingCarpet || block instanceof CarpetBlock) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.world.func_180495_p(pos), this.world, pos, (LivingEntity)this.entity.get());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.func_180495_p(pos).func_177230_c(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    private static enum SurfaceType {
        WALKABLE,
        DROPABLE,
        NOT_PASSABLE;

    }
}

