/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    @NotNull
    protected final BlockPos avoid;
    protected final int avoidDistance;

    public PathJobMoveAwayFromLocation(World world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range, LivingEntity entity) {
        super(world, start, avoid, range, entity);
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getCommon().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.avoid.func_177958_n(), this.avoid.func_177956_o(), this.avoid.func_177952_p()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return -this.avoid.func_177951_i((Vec3i)pos);
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return Math.sqrt(this.avoid.func_177951_i((Vec3i)n.pos)) > (double)this.avoidDistance;
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return -this.avoid.func_177951_i((Vec3i)n.pos);
    }
}

