/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.entity.pathfinding.RandomPathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobRandomPos
extends AbstractPathJob {
    @NotNull
    protected final BlockPos destination;
    protected final int distance;
    private static Random random = new Random();

    public PathJobRandomPos(World world, @NotNull BlockPos start, int distance, int range, LivingEntity entity) {
        super(world, start, start, range, new RandomPathResult(), entity);
        this.distance = distance;
        Tuple<Direction, Direction> dir = BlockPosUtil.getRandomDirectionTuple(random);
        this.destination = start.func_177967_a((Direction)dir.func_76341_a(), distance).func_177967_a((Direction)dir.func_76340_b(), distance);
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getCommon().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] in the direction of [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        return super.search();
    }

    @Override
    @NotNull
    public RandomPathResult getResult() {
        return (RandomPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vec3i)new BlockPos(pos.func_177958_n(), this.destination.func_177956_o(), pos.func_177952_p())));
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (Math.sqrt(this.start.func_177951_i((Vec3i)n.pos)) > (double)this.distance) {
            this.getResult().randomPos = n.pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.destination.func_177951_i((Vec3i)n.pos);
    }
}

