/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Log;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.StructureClientHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RenderUtils;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.EmptyView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final double PREVIEW_RANGE = 25.0;
    private static Blueprint wayPointTemplate;
    private static Blueprint partolPointTemplate;
    private static Map<BlockPos, Triple<Blueprint, BlockPos, BlockPos>> blueprintCache;
    public static final RenderTypeBuffers renderBuffers;
    private static final IRenderTypeBuffer.Impl renderBuffer;
    private static final Supplier<IVertexBuilder> linesWithCullAndDepth;
    private static final Supplier<IVertexBuilder> linesWithoutCullAndDepth;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        if (((Boolean)MineColonies.getConfig().getCommon().pathfindingDebugDraw.get()).booleanValue()) {
            Pathfinding.debugDraw(event.getPartialTicks(), event.getMatrixStack());
        }
        Blueprint structure = Settings.instance.getActiveStructure();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            ClientEventHandler.handleRenderStructure(event, world, (PlayerEntity)player);
        }
        if (player.func_184614_ca().func_77973_b() == com.minecolonies.api.items.ModItems.scepterGuard) {
            ClientEventHandler.handleRenderScepterGuard(event, world, (PlayerEntity)player);
        } else if (player.func_184614_ca().func_77973_b() == com.minecolonies.api.items.ModItems.bannerRallyGuards) {
            ClientEventHandler.handleRenderBannerRallyGuards(event, world, (PlayerEntity)player);
        } else if (player.func_184614_ca().func_77973_b() == ModItems.buildTool) {
            ClientEventHandler.handleRenderBuildTool(event, world, (PlayerEntity)player);
        }
        renderBuffer.func_228461_a_();
    }

    private static void handleRenderBuildTool(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        if (Settings.instance.getActiveStructure() == null) {
            return;
        }
        IColonyView colony = IColonyManager.getInstance().getClosestColonyView((World)world, player.func_180425_c());
        if (colony == null) {
            return;
        }
        BlockPos activePosition = Settings.instance.getPosition();
        HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>> newCache = new HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>>();
        for (IBuildingView iBuildingView : colony.getBuildings()) {
            Blueprint blueprint;
            BlockPos currentPosition;
            if (iBuildingView instanceof PostBox.View || iBuildingView instanceof EmptyView || !activePosition.func_218141_a((Vec3i)(currentPosition = iBuildingView.getPosition()), 25.0)) continue;
            if (blueprintCache.containsKey(currentPosition)) {
                newCache.put(currentPosition, blueprintCache.get(currentPosition));
                continue;
            }
            StructureName sn = new StructureName("schematics", iBuildingView.getStyle(), iBuildingView.getSchematicName() + iBuildingView.getBuildingMaxLevel());
            String structureName = sn.toString();
            String md5 = Structures.getMD5((String)structureName);
            LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler((World)world, iBuildingView.getID(), structureName, new PlacementSettings(), true);
            if (!wrapper.hasBluePrint() || !wrapper.isCorrectMD5(md5)) {
                Log.getLogger().debug("Blueprint error, requesting" + structureName + " from server.");
                if (ServerLifecycleHooks.getCurrentServer() == null) {
                    Network.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName));
                    continue;
                }
            }
            if ((blueprint = wrapper.getBluePrint()) == null) continue;
            Mirror mirror = iBuildingView.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE;
            TileEntity tileEntity = world.func_175625_s(currentPosition);
            if (tileEntity instanceof TileEntityColonyBuilding) {
                mirror = ((TileEntityColonyBuilding)tileEntity).isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE;
            }
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(iBuildingView.getRotation()), mirror, (World)world);
            BlockPos primaryOffset = blueprint.getPrimaryBlockOffset();
            BlockPos pos = currentPosition.func_177973_b((Vec3i)primaryOffset);
            BlockPos size = new BlockPos((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ());
            BlockPos renderSize = pos.func_177971_a((Vec3i)size).func_177973_b((Vec3i)new BlockPos(1, 1, 1));
            if (iBuildingView.getBuildingLevel() < iBuildingView.getBuildingMaxLevel()) {
                newCache.put(currentPosition, (Triple<Blueprint, BlockPos, BlockPos>)new Triple((Object)blueprint, (Object)pos, (Object)renderSize));
                continue;
            }
            newCache.put(currentPosition, (Triple<Blueprint, BlockPos, BlockPos>)new Triple(null, (Object)pos, (Object)renderSize));
        }
        blueprintCache = newCache;
        for (Map.Entry entry : blueprintCache.entrySet()) {
            Triple buildingData = (Triple)entry.getValue();
            BlockPos position = (BlockPos)entry.getKey();
            if (buildingData.a != null) {
                StructureClientHandler.renderStructureAtPos((Blueprint)((Blueprint)buildingData.a), (float)event.getPartialTicks(), (BlockPos)position, (MatrixStack)event.getMatrixStack());
            }
            RenderUtils.renderBox((BlockPos)((BlockPos)buildingData.b), (BlockPos)((BlockPos)buildingData.c), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (double)0.002, (MatrixStack)event.getMatrixStack(), (IVertexBuilder)linesWithCullAndDepth.get());
        }
    }

    private static void handleRenderStructure(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        IColonyView tempView;
        PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
        if (Settings.instance.getStructureName() != null && Settings.instance.getStructureName().contains("infrastructure") && (tempView = IColonyManager.getInstance().getClosestColonyView((World)world, player.func_180425_c())) != null) {
            if (wayPointTemplate == null) {
                wayPointTemplate = new LoadOnlyStructureHandler((World)world, BlockPos.field_177992_a, "schematics/infrastructure/waypoint", settings, true).getBluePrint();
            }
            StructureClientHandler.renderStructureAtPosList((Blueprint)(Settings.instance.getActiveStructure().hashCode() == wayPointTemplate.hashCode() ? Settings.instance.getActiveStructure() : wayPointTemplate), (float)event.getPartialTicks(), new ArrayList<BlockPos>(tempView.getWayPoints().keySet()), (MatrixStack)event.getMatrixStack());
        }
    }

    private static void handleRenderScepterGuard(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        IColonyView colony = IColonyManager.getInstance().getColonyView(compound.func_74762_e("id"), player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
        if (colony == null) {
            return;
        }
        BlockPos guardTower = BlockPosUtil.read(compound, "pos");
        IBuildingView hut = colony.getBuilding(guardTower);
        if (partolPointTemplate == null) {
            partolPointTemplate = new LoadOnlyStructureHandler((World)world, hut.getPosition(), "schematics/infrastructure/patrolpoint", settings, true).getBluePrint();
        }
        if (hut instanceof AbstractBuildingGuards.View) {
            StructureClientHandler.renderStructureAtPosList((Blueprint)partolPointTemplate, (float)event.getPartialTicks(), ((AbstractBuildingGuards.View)hut).getPatrolTargets().stream().map(BlockPos::func_177984_a).collect(Collectors.toList()), (MatrixStack)event.getMatrixStack());
        }
    }

    private static void handleRenderBannerRallyGuards(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        ImmutableList<ILocation> guardTowers = ItemBannerRallyGuards.getGuardTowerLocations(stack);
        for (ILocation guardTower : guardTowers) {
            if (world.func_201675_m().func_186058_p().func_186068_a() != guardTower.getDimension()) continue;
            RenderUtils.renderBox((BlockPos)guardTower.getInDimensionLocation(), (BlockPos)guardTower.getInDimensionLocation(), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (double)0.002, (MatrixStack)event.getMatrixStack(), (IVertexBuilder)linesWithCullAndDepth.get());
        }
    }

    static {
        blueprintCache = new HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>>();
        renderBuffers = new RenderTypeBuffers();
        renderBuffer = renderBuffers.func_228487_b_();
        linesWithCullAndDepth = () -> renderBuffer.getBuffer(RenderType.func_228659_m_());
        linesWithoutCullAndDepth = () -> renderBuffer.getBuffer(RenderUtils.LINES_GLINT);
    }
}

