/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.render.MRenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class DebugRendererChunkBorder {
    private static Tuple<Integer, Integer> center = new Tuple<Integer, Integer>(0, 0);
    private static Map<Tuple<Integer, Integer>, Integer> colonies = new HashMap<Tuple<Integer, Integer>, Integer>();

    @SubscribeEvent
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() != ModItems.buildTool) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        IColonyView view = IColonyManager.getInstance().getClosestColonyView((World)world, player.func_180425_c());
        if (view == null) {
            return;
        }
        if (!center.equals(new Tuple<Integer, Integer>(player.field_70176_ah, player.field_70164_aj))) {
            center = new Tuple<Integer, Integer>(player.field_70176_ah, player.field_70164_aj);
            colonies.clear();
            int range = (Integer)MineColonies.getConfig().getCommon().maxColonySize.get();
            for (int incX = -range; incX <= range; ++incX) {
                for (int incZ = -range; incZ <= range; ++incZ) {
                    Chunk chunk = world.func_212866_a_(player.field_70176_ah + incX, player.field_70164_aj + incZ);
                    IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                    if (cap == null) continue;
                    colonies.put(new Tuple<Integer, Integer>(incX, incZ), cap.getOwningColony());
                }
            }
        }
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder bufferbuilder = buffer.getBuffer(MRenderTypes.customLineRenderer());
        Vec3d currView = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        float lowerYLimit = (float)(5.0 - currView.field_72448_b);
        float upperYLimit = (float)(255.0 - currView.field_72448_b);
        double lowerYLimitSmaller = Math.max((double)lowerYLimit, currView.field_72448_b - 30.0 - currView.field_72448_b);
        float chunkCoordX = (float)((double)(player.field_70176_ah << 4) - currView.field_72450_a);
        float chunkCoordZ = (float)((double)(player.field_70164_aj << 4) - currView.field_72449_c);
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        for (Map.Entry<Tuple<Integer, Integer>, Integer> c : colonies.entrySet()) {
            int x = c.getKey().getA();
            int z = c.getKey().getB();
            int incX = x * 16;
            int incZ = z * 16;
            if (c.getValue().intValue() != view.getID()) continue;
            boolean north = false;
            boolean south = false;
            boolean east = false;
            boolean west = false;
            if (!c.getValue().equals(colonies.get(new Tuple<Integer, Integer>(x, z - 1))) && colonies.containsKey(new Tuple<Integer, Integer>(x, z - 1))) {
                north = true;
            }
            if (!c.getValue().equals(colonies.get(new Tuple<Integer, Integer>(x, z + 1))) && colonies.containsKey(new Tuple<Integer, Integer>(x, z + 1))) {
                south = true;
            }
            if (!c.getValue().equals(colonies.get(new Tuple<Integer, Integer>(x + 1, z))) && colonies.containsKey(new Tuple<Integer, Integer>(x + 1, z))) {
                east = true;
            }
            if (!c.getValue().equals(colonies.get(new Tuple<Integer, Integer>(x - 1, z))) && colonies.containsKey(new Tuple<Integer, Integer>(x - 1, z))) {
                west = true;
            }
            float levels = lowerYLimit;
            while (levels <= upperYLimit) {
                if (north) {
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, levels, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + 16.0f + (float)incX, levels, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (south) {
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + 16.0f + (float)incX, levels, chunkCoordZ + 16.0f + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, levels, chunkCoordZ + 16.0f + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (east) {
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + 16.0f + (float)incX, levels, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + 16.0f + (float)incX, levels, chunkCoordZ + 16.0f + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (west) {
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, levels, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, levels, chunkCoordZ + 16.0f + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if ((double)levels > lowerYLimitSmaller) {
                    double addition = (double)upperYLimit / currView.field_72448_b / ((double)upperYLimit / currView.field_72448_b - (double)levels / currView.field_72448_b) * 10.0;
                    levels = (float)((double)levels + (addition > 1.0 ? addition : 1.0));
                    continue;
                }
                levels += 5.0f;
            }
            if (north) {
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, lowerYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, upperYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, lowerYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, upperYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (south) {
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, lowerYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, upperYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, lowerYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, upperYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (east) {
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, lowerYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, upperYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, lowerYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX + 16.0f, upperYLimit, chunkCoordZ + (float)incZ).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (!west) continue;
            bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, lowerYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, upperYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, lowerYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, chunkCoordX + (float)incX, upperYLimit, chunkCoordZ + (float)incZ + 16.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        }
        stack.func_227865_b_();
        buffer.func_228461_a_();
    }
}

