/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IRSComponentBlock;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenary;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesChunkCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldColonyManagerCapabilityProvider;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.loot.SupplyLoot;
import com.minecolonies.coremod.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkRangeCapabilityMessage;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        SupplyLoot.getInstance().addLootToEvent(event);
    }

    @SubscribeEvent
    public static void onEntityAdded(@NotNull EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && ((Boolean)MineColonies.getConfig().getCommon().mobAttackCitizens.get()).booleanValue() && event.getEntity() instanceof IMob && !(event.getEntity() instanceof LlamaEntity) && !(event.getEntity() instanceof EndermanEntity)) {
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), EntityCitizen.class, true));
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), EntityMercenary.class, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P) {
            ClientWorld world = mc.field_71441_e;
            ClientPlayerEntity player = mc.field_71439_g;
            IColony colony = IColonyManager.getInstance().getIColony((World)world, player.func_180425_c());
            if (colony == null) {
                if (!IColonyManager.getInstance().isTooCloseToColony((World)world, player.func_180425_c())) {
                    event.getLeft().add(LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.noCloseColony", (Object[])new Object[0]));
                    return;
                }
                colony = IColonyManager.getInstance().getClosestIColony((World)world, player.func_180425_c());
                if (colony == null) {
                    return;
                }
                event.getLeft().add(LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.nextColony", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c())), IColonyManager.getInstance().getMinimumDistanceBetweenTownHalls()}));
                return;
            }
            event.getLeft().add(colony.getName() + " : " + LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c()))}));
        }
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesChunk(@NotNull AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("minecolonies", "closecolony"), (ICapabilityProvider)new MinecoloniesChunkCapabilityProvider());
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("minecolonies", "chunkupdate"), (ICapabilityProvider)new MinecoloniesWorldCapabilityProvider());
        event.addCapability(new ResourceLocation("minecolonies", "colonymanager"), (ICapabilityProvider)new MinecoloniesWorldColonyManagerCapabilityProvider());
    }

    @SubscribeEvent
    public static void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ChunkDataHelper.loadChunk((Chunk)event.getChunk(), (World)((ServerWorld)event.getWorld()));
        } else if (event.getWorld() instanceof ClientWorld && event.getChunk() instanceof Chunk) {
            ChunkClientDataHelper.applyLate((Chunk)event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            ChunkDataHelper.unloadChunk((Chunk)event.getChunk(), (World)((ServerWorld)event.getWorld()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && !event.isCanceled()) {
            IColony oldColony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Chunk oldChunk = player.field_70170_p.func_212866_a_(player.field_70176_ah, player.field_70164_aj);
            IColonyTagCapability oldCloseColonies = (IColonyTagCapability)oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null);
            if (oldCloseColonies != null && oldCloseColonies.getOwningColony() != 0 && (oldColony = IColonyManager.getInstance().getColonyByWorld(oldCloseColonies.getOwningColony(), player.field_70170_p)) != null) {
                oldColony.removeVisitingPlayer((PlayerEntity)player);
                oldColony.getPackageManager().removeCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            IColony newColony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            Chunk newChunk = player.field_70170_p.func_212866_a_(player.field_70176_ah, player.field_70164_aj);
            IColonyTagCapability newCloseColonies = (IColonyTagCapability)newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null);
            if (newCloseColonies != null && (newColony = IColonyManager.getInstance().getColonyByWorld(newCloseColonies.getOwningColony(), player.field_70170_p)) != null) {
                newColony.addVisitingPlayer((PlayerEntity)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(@NotNull EntityEvent.EnteringChunk event) {
        Entity entity = event.getEntity();
        BlockPos pos = entity.func_180425_c();
        if (event.getOldChunkX() == 0 && event.getOldChunkZ() == 0 && pos.func_177951_i((Vec3i)BlockPos.field_177992_a) > 10000.0) {
            return;
        }
        if (entity instanceof ServerPlayerEntity) {
            IColony newColony;
            IColony oldColony;
            World world = entity.func_130014_f_();
            Chunk newChunk = world.func_212866_a_(event.getNewChunkX(), event.getNewChunkZ());
            ChunkDataHelper.loadChunk(newChunk, entity.field_70170_p);
            Network.getNetwork().sendToPlayer(new UpdateChunkRangeCapabilityMessage(world, event.getNewChunkX(), event.getNewChunkZ(), 8, true), (ServerPlayerEntity)event.getEntity());
            IColonyTagCapability newCloseColonies = (IColonyTagCapability)newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null);
            Network.getNetwork().sendToPlayer(new UpdateChunkCapabilityMessage(newCloseColonies, newChunk.func_76632_l().field_77276_a, newChunk.func_76632_l().field_77275_b), (ServerPlayerEntity)entity);
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            Chunk oldChunk = world.func_212866_a_(event.getOldChunkX(), event.getOldChunkZ());
            IColonyTagCapability oldCloseColonies = (IColonyTagCapability)oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null);
            if (newCloseColonies.getOwningColony() != oldCloseColonies.getOwningColony() && (oldColony = IColonyManager.getInstance().getColonyByWorld(oldCloseColonies.getOwningColony(), world)) != null) {
                oldColony.removeVisitingPlayer((PlayerEntity)player);
                oldColony.getPackageManager().removeCloseSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != 0 && (newColony = IColonyManager.getInstance().getColonyByWorld(newCloseColonies.getOwningColony(), world)) != null && !newColony.getPackageManager().getCloseSubscribers().contains(player)) {
                newColony.addVisitingPlayer((PlayerEntity)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != 0) {
                for (Map.Entry<Integer, Set<BlockPos>> entry : newCloseColonies.getAllClaimingBuildings().entrySet()) {
                    IColony newColony2 = IColonyManager.getInstance().getColonyByWorld(entry.getKey(), world);
                    if (newColony2 == null) continue;
                    for (BlockPos buildingPos : entry.getValue()) {
                        IBuilding building = newColony2.getBuildingManager().getBuilding(buildingPos);
                        if (building == null) continue;
                        building.onPlayerEnterNearby((PlayerEntity)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            IColony colony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            for (IColony colony2 : IColonyManager.getInstance().getAllColonies()) {
                if (!colony2.getPermissions().hasPermission((PlayerEntity)player, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY) && !colony2.getPermissions().hasPermission((PlayerEntity)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
                colony2.getPackageManager().addImportantColonyPlayer(player);
            }
            Chunk chunk = (Chunk)player.field_70170_p.func_217349_x(player.func_180425_c());
            IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null);
            if (cap != null && cap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(cap.getOwningColony(), player.field_71093_bK.func_186068_a())) != null) {
                colony.addVisitingPlayer((PlayerEntity)player);
                colony.getPackageManager().addCloseSubscriber(player);
            }
            int size = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBannerRallyGuards)) continue;
                ItemBannerRallyGuards.broadcastPlayerToRally(stack, (World)player.func_71121_q(), (PlayerEntity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getPackageManager().removeCloseSubscriber(player);
                colony.getPackageManager().removeImportantColonyPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunkEntity(@NotNull EntityEvent.EnteringChunk event) {
        if (((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue() && event.getEntity() instanceof EntityCitizen) {
            IColony colony;
            World world;
            Chunk chunk;
            IColonyTagCapability chunkCapability;
            if (event.getEntity().field_70170_p == null || !WorldUtil.isEntityChunkLoaded((IWorld)event.getEntity().field_70170_p, new ChunkPos(event.getNewChunkX(), event.getNewChunkZ())) || !WorldUtil.isEntityChunkLoaded((IWorld)event.getEntity().field_70170_p, new ChunkPos(event.getOldChunkX(), event.getOldChunkZ()))) {
                return;
            }
            EntityCitizen entityCitizen = (EntityCitizen)event.getEntity();
            if (entityCitizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && (chunkCapability = (IColonyTagCapability)(chunk = (world = entityCitizen.func_130014_f_()).func_212866_a_(event.getNewChunkX(), event.getNewChunkZ())).getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)) != null && chunkCapability.getOwningColony() != 0 && entityCitizen.getCitizenColonyHandler().getColonyId() != chunkCapability.getOwningColony() && (colony = IColonyManager.getInstance().getColonyByWorld(chunkCapability.getOwningColony(), entityCitizen.field_70170_p)) != null) {
                colony.addGuardToAttackers(entityCitizen, ((IGuardBuilding)entityCitizen.getCitizenColonyHandler().getWorkBuilding()).getPlayerToFollowOrRally());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() instanceof SpawnerBlock) {
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)event.getWorld().func_175625_s(event.getPos());
            IColony colony = IColonyManager.getInstance().getColonyByDimension(spawner.func_145881_a().field_98282_f.func_185277_b().func_74762_e("colony"), event.getWorld().func_201675_m().func_186058_p().func_186068_a());
            if (colony != null) {
                colony.getEventManager().onTileEntityBreak(spawner.func_145881_a().field_98282_f.func_185277_b().func_74762_e("mc_event_id"), (TileEntity)spawner);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Block block;
        IColony colony;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockPos bedBlockPos = event.getPos();
        if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
            IColony colony2 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony2 != null && !colony2.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
            }
            return;
        }
        if ("pmardle".equalsIgnoreCase(event.getPlayer().func_200200_C_().func_150254_d()) && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof SilverfishBlock) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)event.getPlayer(), (String)"Stop that you twat!!!", (Object[])new Object[0]);
            event.setCanceled(true);
        }
        if (world.func_180495_p(event.getPos()).func_177230_c().isBed(world.func_180495_p(event.getPos()), (IBlockReader)world, event.getPos(), (Entity)player) && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, bedBlockPos)) != null && world.func_180495_p(event.getPos()).func_206869_a().contains(BedBlock.field_176472_a)) {
            List<ICitizenData> citizenList = colony.getCitizenManager().getCitizens();
            if (world.func_180495_p(event.getPos()).isBedFoot((IWorldReader)world, event.getPos())) {
                bedBlockPos = bedBlockPos.func_177972_a((Direction)world.func_180495_p(event.getPos()).func_177229_b((IProperty)BedBlock.field_185512_D));
            }
            for (ICitizenData citizen : citizenList) {
                if (!citizen.getBedPos().equals((Object)bedBlockPos) || !citizen.isAsleep()) continue;
                event.setCanceled(true);
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.bed.occupied", (Object[])new Object[0]);
            }
        }
        EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        if (!event.isCanceled() && event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b() instanceof BlockItem && (block = ((BlockItem)event.getItemStack().func_77973_b()).func_179223_d().getBlock()) instanceof AbstractBlockHut && !(block instanceof IRSComponentBlock)) {
            IColony colony3 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony3 != null && !colony3.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
                return;
            }
            if (((Boolean)MineColonies.getConfig().getCommon().suggestBuildToolPlacement.get()).booleanValue()) {
                ItemStack stack = new ItemStack((IItemProvider)block);
                if (!stack.func_190926_b() && !world.field_72995_K) {
                    Network.getNetwork().sendToPlayer(new OpenSuggestionWindowMessage((BlockState)block.func_176223_P().func_206870_a((IProperty)AbstractBlockHut.FACING, (Comparable)event.getPlayer().func_174811_aO()), event.getPos().func_177972_a(event.getFace()), stack), (ServerPlayerEntity)player);
                }
                event.setCanceled(true);
            }
            return;
        }
        if (!event.isCanceled() && event.getHand() == Hand.MAIN_HAND && event.getItemStack().func_77973_b() == ModItems.buildTool) {
            if (event.getWorld().field_72995_K && event.getUseBlock() == Event.Result.DEFAULT && event.getFace() != null) {
                IColonyView view = IColonyManager.getInstance().getClosestColonyView(event.getWorld(), event.getPos().func_177972_a(event.getFace()));
                if (view != null && Settings.instance.getStyle().isEmpty()) {
                    Settings.instance.setStyle(view.getStyle());
                }
                MineColonies.proxy.openBuildToolWindow(event.getPos().func_177972_a(event.getFace()));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickItem event) {
        if (event.getHand() == Hand.MAIN_HAND && event.getItemStack().func_77973_b() == ModItems.buildTool && event.getWorld().field_72995_K) {
            IColonyView view = IColonyManager.getInstance().getClosestColonyView(event.getWorld(), event.getPos());
            if (view != null && Settings.instance.getStyle().isEmpty()) {
                Settings.instance.setStyle(view.getStyle());
            }
            MineColonies.proxy.openBuildToolWindow(null);
            event.setCanceled(true);
        }
    }

    private static boolean playerRightClickInteract(@NotNull PlayerEntity player, World world, BlockPos pos) {
        return !player.func_225608_bj_() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IWorldReader)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull PlayerEntity player) {
        Block heldBlock = Block.func_149634_a((Item)event.getItemStack().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockScarecrow) {
            if (event.getWorld().field_72995_K) {
                event.setCanceled(((Boolean)MineColonies.getConfig().getCommon().suggestBuildToolPlacement.get()).booleanValue());
            } else {
                event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
            }
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull PlayerEntity player, Block block, BlockPos pos) {
        if (!((Boolean)MineColonies.getConfig().getCommon().allowOtherDimColonies.get()).booleanValue() && world.func_201675_m().func_186058_p().func_186068_a() != 0) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
            return false;
        }
        return EventHandler.onBlockHutPlaced(world, player, pos, block);
    }

    private static boolean onBlockHutPlaced(World world, @NotNull PlayerEntity player, BlockPos pos, Block block) {
        IColony colony = IColonyManager.getInstance().getIColony(world, pos);
        if (colony == null) {
            if (block instanceof BlockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(world, player) == null) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagenotownhall", (Object[])new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagetoofarfromtownhall", (Object[])new Object[0]);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagenopermission", (Object[])new Object[]{colony.getName()});
            return false;
        }
        return player.func_184812_l_() || colony.getBuildingManager().canPlaceAt(block, pos, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(@NotNull WorldEvent.Load event) {
        if (event.getWorld() instanceof World) {
            IColonyManager.getInstance().onWorldLoad((World)event.getWorld());
        }
        if (event.getWorld().func_201670_d() && ((Boolean)MineColonies.getConfig().getCommon().holidayFeatures.get()).booleanValue() && (LocalDateTime.now().getDayOfMonth() == 31 && LocalDateTime.now().getMonth() == Month.OCTOBER || LocalDateTime.now().getDayOfMonth() == 1 && LocalDateTime.now().getMonth() == Month.NOVEMBER || LocalDateTime.now().getDayOfMonth() == 2 && LocalDateTime.now().getMonth() == Month.NOVEMBER)) {
            RenderBipedCitizen.isItGhostTime = true;
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(@NotNull WorldEvent.Unload event) {
        if (!event.getWorld().func_201670_d() && event.getWorld() instanceof World) {
            IColonyManager.getInstance().onWorldUnload((World)event.getWorld());
        }
        if (event.getWorld().func_201670_d()) {
            IColonyManager.getInstance().resetColonyViews();
            ItemBlockHut.checkResearch(null);
            Log.getLogger().info("Removed all colony views");
        }
    }
}

