/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ItemBannerRallyGuards
extends AbstractItemMinecolonies {
    private static final String TAG_IS_ACTIVE = "isActive";

    public ItemBannerRallyGuards(Item.Properties properties) {
        super("banner_rally_guards", properties.func_200917_a(1).func_200918_c(0).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack banner = context.func_195999_j().func_184586_b(context.func_221531_n());
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(banner);
        if (ItemBannerRallyGuards.isGuardBuilding(context.func_195991_k(), context.func_195995_a())) {
            if (context.func_195991_k().func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            IGuardBuilding building = ItemBannerRallyGuards.getGuardBuilding(context.func_195991_k(), context.func_195995_a());
            if (!building.getColony().getPermissions().hasPermission(player, Action.RALLY_GUARDS)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.permission.no", (Object[])new Object[0]);
                return ActionResultType.FAIL;
            }
            ILocation location = building.getLocation();
            if (ItemBannerRallyGuards.removeGuardTowerAtLocation(banner, location)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)context.func_195999_j(), (String)"com.minecolonies.coremod.item.bannerrallyguards.deselected", (Object[])new Object[]{building.getSchematicName(), location.toString()});
            } else {
                ListNBT guardTowers = compound.func_150295_c("guardtowerpositions", 10);
                guardTowers.add((Object)StandardFactoryController.getInstance().serialize(location));
                LanguageHandler.sendPlayerMessage((PlayerEntity)context.func_195999_j(), (String)"com.minecolonies.coremod.item.bannerrallyguards.selected", (Object[])new Object[]{building.getSchematicName(), location.toString()});
            }
        } else {
            this.handleRightClick(banner, context.func_195999_j());
        }
        return ActionResultType.SUCCESS;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack banner = playerIn.func_184586_b(handIn);
        this.handleRightClick(banner, playerIn);
        return ActionResult.func_226248_a_((Object)banner);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        if (!player.func_130014_f_().func_201670_d()) {
            CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(item);
            compound.func_74757_a(TAG_IS_ACTIVE, false);
            ItemBannerRallyGuards.broadcastPlayerToRally(item, player.func_130014_f_(), null);
        }
        return super.onDroppedByPlayer(item, player);
    }

    private void handleRightClick(ItemStack banner, PlayerEntity playerIn) {
        if (playerIn.func_225608_bj_() && !playerIn.func_130014_f_().func_201670_d()) {
            ItemBannerRallyGuards.toggleBanner(banner, playerIn);
        } else if (!playerIn.func_225608_bj_() && playerIn.func_130014_f_().func_201670_d()) {
            if (ItemBannerRallyGuards.getGuardTowerLocations(banner).isEmpty()) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", (Object[])new Object[0]);
            } else {
                MineColonies.proxy.openBannerRallyGuardsWindow(banner);
            }
        }
    }

    public static void toggleBanner(ItemStack banner, PlayerEntity playerIn) {
        if (playerIn.func_130014_f_().func_201670_d()) {
            Log.getLogger().error("Tried to run server-side function #toggleBanner() on the client-side!");
            return;
        }
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListNBT guardTowers = (ListNBT)compound.func_74781_a("guardtowerpositions");
        if (guardTowers == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return;
        }
        if (guardTowers.isEmpty()) {
            compound.func_74757_a(TAG_IS_ACTIVE, false);
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", (Object[])new Object[0]);
        } else if (compound.func_74767_n(TAG_IS_ACTIVE)) {
            compound.func_74757_a(TAG_IS_ACTIVE, false);
            ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.func_130014_f_(), null);
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"item.minecolonies.banner_rally_guards.deactivated", (Object[])new Object[0]);
        } else {
            compound.func_74757_a(TAG_IS_ACTIVE, true);
            int numGuards = ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.func_130014_f_(), playerIn);
            if (numGuards > 0) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"item.minecolonies.banner_rally_guards.activated", (Object[])new Object[]{numGuards});
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"item.minecolonies.banner_rally_guards.activated.noguards", (Object[])new Object[0]);
            }
        }
    }

    public static int broadcastPlayerToRally(ItemStack banner, World worldIn, @Nullable PlayerEntity playerIn) {
        if (worldIn.func_201670_d()) {
            Log.getLogger().error("Tried to run server-side function #broadcastPlayerToRally() on the client-side!");
            return 0;
        }
        EntityLocation rallyTarget = null;
        rallyTarget = !ItemBannerRallyGuards.isActive(banner) || playerIn == null ? null : new EntityLocation(playerIn.func_110124_au());
        int numGuards = 0;
        for (ILocation guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            IGuardBuilding building = ItemBannerRallyGuards.getGuardBuilding((World)ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.func_186069_a((int)guardTowerLocation.getDimension())), guardTowerLocation.getInDimensionLocation());
            if (building == null || playerIn != null && !building.getColony().getPermissions().hasPermission(playerIn, Action.RALLY_GUARDS)) continue;
            building.setRallyLocation(rallyTarget);
            numGuards += building.getAssignedCitizen().size();
        }
        return numGuards;
    }

    public static ImmutableList<ILocation> getGuardTowerLocations(ItemStack banner) {
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListNBT guardTowersListNBT = compound.func_150295_c("guardtowerpositions", 10);
        if (guardTowersListNBT == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return ImmutableList.of();
        }
        ArrayList resultList = new ArrayList(guardTowersListNBT.size());
        for (INBT guardTowerNBT : guardTowersListNBT) {
            resultList.add(StandardFactoryController.getInstance().deserialize((CompoundNBT)guardTowerNBT));
        }
        return ImmutableList.copyOf(resultList);
    }

    public static boolean isGuardBuilding(World worldIn, BlockPos position) {
        if (worldIn.func_201670_d()) {
            return IColonyManager.getInstance().getBuildingView(worldIn.func_201675_m().func_186058_p().func_186068_a(), position) instanceof AbstractBuildingGuards.View;
        }
        return IColonyManager.getInstance().getBuilding(worldIn, position) instanceof IGuardBuilding;
    }

    @Nullable
    public static AbstractBuildingGuards.View getGuardBuildingView(World worldIn, BlockPos position) {
        if (!worldIn.func_201670_d()) {
            Log.getLogger().error("Tried to run client-side function #getGuardBuildingView() on the server-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (AbstractBuildingGuards.View)IColonyManager.getInstance().getBuildingView(worldIn.func_201675_m().func_186058_p().func_186068_a(), position) : null;
    }

    @Nullable
    public static IGuardBuilding getGuardBuilding(World worldIn, BlockPos position) {
        if (worldIn.func_201670_d()) {
            Log.getLogger().error("Tried to run server-side function #getGuardBuilding() on the client-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (IGuardBuilding)IColonyManager.getInstance().getBuilding(worldIn, position) : null;
    }

    public static List<Pair<ILocation, AbstractBuildingGuards.View>> getGuardTowerViews(ItemStack banner) {
        LinkedList<Pair> result = new LinkedList<Pair>();
        for (ILocation guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            result.add(new Pair((Object)guardTowerLocation, (Object)ItemBannerRallyGuards.getGuardBuildingView(MineColonies.proxy.getWorld(guardTowerLocation.getDimension()), guardTowerLocation.getInDimensionLocation())));
        }
        return ImmutableList.copyOf(result);
    }

    public boolean isActiveForGuardTower(ItemStack banner, IGuardBuilding guardTower) {
        if (!ItemBannerRallyGuards.isActive(banner)) {
            return false;
        }
        for (ILocation existingTower : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            if (!existingTower.equals(guardTower.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean isActive(ItemStack banner) {
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(banner);
        return compound.func_74767_n(TAG_IS_ACTIVE);
    }

    public static boolean removeGuardTowerAtLocation(ItemStack banner, ILocation guardTowerLocation) {
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListNBT guardTowers = compound.func_150295_c("guardtowerpositions", 10);
        for (int i = 0; i < guardTowers.size(); ++i) {
            if (!StandardFactoryController.getInstance().deserialize((CompoundNBT)guardTowers.get(i)).equals(guardTowerLocation)) continue;
            guardTowers.remove(i);
            banner.func_77982_d(compound);
            return true;
        }
        return false;
    }

    public static CompoundNBT checkForCompound(ItemStack banner) {
        CompoundNBT compound;
        if (!banner.func_77942_o()) {
            compound = new CompoundNBT();
            banner.func_77982_d(compound);
        }
        if (!(compound = banner.func_77978_p()).func_74764_b("guardtowerpositions")) {
            compound.func_186854_a("id", UUID.randomUUID());
            compound.func_74757_a(TAG_IS_ACTIVE, false);
            ListNBT guardTowerList = new ListNBT();
            compound.func_218657_a("guardtowerpositions", (INBT)guardTowerList);
        }
        return compound;
    }

    public boolean func_77636_d(@NotNull ItemStack stack) {
        CompoundNBT compound = ItemBannerRallyGuards.checkForCompound(stack);
        return compound.func_74767_n(TAG_IS_ACTIVE);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        ITextComponent guiHint = LanguageHandler.buildChatComponent((String)"com.minecolonies.coremod.item.bannerrallyguards.gui", (Object[])new Object[0]);
        guiHint.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        tooltip.add(guiHint);
        ITextComponent rallyHint = LanguageHandler.buildChatComponent((String)"com.minecolonies.coremod.item.bannerrallyguards.rally", (Object[])new Object[0]);
        rallyHint.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        tooltip.add(rallyHint);
        ImmutableList<ILocation> guardTowerPositions = ItemBannerRallyGuards.getGuardTowerLocations(stack);
        if (guardTowerPositions.isEmpty()) {
            ITextComponent emptyTooltip = LanguageHandler.buildChatComponent((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", (Object[])new Object[0]);
            emptyTooltip.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            tooltip.add(emptyTooltip);
        } else {
            ITextComponent numGuardTowers = LanguageHandler.buildChatComponent((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltip", (Object[])new Object[]{guardTowerPositions.size()});
            numGuardTowers.func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_AQUA));
            tooltip.add(numGuardTowers);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

