/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewCitizenViewMessage
implements IMessage {
    private int colonyId;
    private int citizenId;
    private PacketBuffer citizenBuffer;
    private int dimension;

    public ColonyViewCitizenViewMessage() {
    }

    public ColonyViewCitizenViewMessage(@NotNull Colony colony, @NotNull ICitizenData citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = new PacketBuffer(Unpooled.buffer());
        this.dimension = citizen.getColony().getDimension();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.dimension = buf.readInt();
        this.citizenBuffer = new PacketBuffer(buf.retain());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeInt(this.dimension);
        buf.writeBytes((ByteBuf)this.citizenBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyViewCitizensMessage(this.colonyId, this.citizenId, this.citizenBuffer, this.dimension);
        this.citizenBuffer.release();
    }
}

