/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveWorkOrderMessage
implements IMessage {
    private int colonyId;
    private int workOrderId;

    public ColonyViewRemoveWorkOrderMessage() {
    }

    public ColonyViewRemoveWorkOrderMessage(@NotNull Colony colony, int workOrderId) {
        this.colonyId = colony.getID();
        this.workOrderId = workOrderId;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            IColonyManager.getInstance().handleColonyViewRemoveWorkOrderMessage(this.colonyId, this.workOrderId, Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
        }
    }
}

