/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationControllerUpdateMessage
implements IMessage {
    private BlockPos pos;
    private String name;
    private int level;

    public DecorationControllerUpdateMessage() {
    }

    public DecorationControllerUpdateMessage(@NotNull BlockPos pos, String name, int level) {
        this.pos = pos;
        this.name = name;
        this.level = level;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = buf.func_179259_c();
        this.level = buf.readInt();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.func_179255_a(this.pos);
        buf.writeInt(this.level);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity player = ctxIn.getSender();
        TileEntity tileEntity = player.func_130014_f_().func_175625_s(this.pos);
        if (tileEntity instanceof TileEntityDecorationController) {
            BlockState state = player.func_130014_f_().func_180495_p(this.pos);
            Direction basicFacing = (Direction)state.func_177229_b((IProperty)BlockDecorationController.field_185512_D);
            ((TileEntityDecorationController)tileEntity).setSchematicName(this.name);
            ((TileEntityDecorationController)tileEntity).setLevel(this.level);
            ((TileEntityDecorationController)tileEntity).setBasicFacing(basicFacing);
        }
    }
}

