/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private Mode mode;
    private BlockPos builder;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(@NotNull IBuildingView building, Mode mode, BlockPos builder) {
        super(building);
        this.mode = mode;
        this.builder = builder;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.mode = Mode.values()[buf.readInt()];
        this.builder = buf.func_179259_c();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.mode.ordinal());
        buf.func_179255_a(this.builder);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (building.hasWorkOrder()) {
            building.removeWorkOrder();
        } else {
            switch (this.mode) {
                case BUILD: {
                    building.requestUpgrade((PlayerEntity)player, this.builder);
                    break;
                }
                case REPAIR: {
                    building.requestRepair(this.builder);
                    break;
                }
                case REMOVE: {
                    building.requestRemoval((PlayerEntity)player, this.builder);
                }
            }
        }
    }

    public static enum Mode {
        BUILD,
        REPAIR,
        REMOVE;

    }
}

