/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.ColonyUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BuildingSetStyleMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private String style;

    public BuildingSetStyleMessage() {
    }

    public BuildingSetStyleMessage(@NotNull IBuildingView building, String style) {
        super(building);
        this.style = style;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.style = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.style);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        building.setStyle(this.style);
        if (building.getTileEntity() != null) {
            building.getTileEntity().setStyle(this.style);
            WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, building.getBuildingLevel() + 1);
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(colony.getWorld(), building.getPosition(), workOrder.getStructureName(), new PlacementSettings(), true);
            CompoundNBT teData = structure.getBluePrint().getTileEntityData(building.getTileEntity().func_174877_v(), structure.getBluePrint().getPrimaryBlockOffset());
            if (teData != null && teData.func_74764_b("blueprintDataProvider")) {
                building.getTileEntity().readSchematicDataFromNBT(teData);
                Chunk chunk = (Chunk)building.getTileEntity().func_145831_w().func_217349_x(building.getTileEntity().func_174877_v());
                PacketDistributor.TRACKING_CHUNK.with(() -> chunk).send((IPacket)building.getTileEntity().func_189518_D_());
                building.getTileEntity().func_70296_d();
                building.setHeight(structure.getBluePrint().getSizeY());
                Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getPosition(), colony.getWorld(), structure.getBluePrint(), workOrder.getRotation(colony.getWorld()), workOrder.isMirrored());
                building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
            }
        }
    }
}

