/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.crusher;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class CrusherSetModeMessage
extends AbstractBuildingServerMessage<BuildingCrusher> {
    private int quantity;
    private ItemStack crusherMode;

    public CrusherSetModeMessage() {
    }

    public CrusherSetModeMessage(@NotNull BuildingCrusher.View building, ItemStorage crusherMode, int dailyQuantity) {
        super(building);
        this.quantity = dailyQuantity;
        this.crusherMode = crusherMode.getItemStack();
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.quantity = buf.readInt();
        this.crusherMode = buf.func_150791_c();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.quantity);
        buf.func_150788_a(this.crusherMode);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingCrusher building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        int qty = this.quantity;
        if (qty > building.getMaxDailyQuantity()) {
            qty = building.getMaxDailyQuantity();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.crusher.toomuch", new Object[]{qty}));
        }
        building.setCrusherMode(new ItemStorage(this.crusherMode), qty);
    }
}

