/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.guard;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class GuardTaskMessage
extends AbstractBuildingServerMessage<AbstractBuildingGuards> {
    private ResourceLocation job;
    private boolean assignmentMode;
    private boolean patrollingMode;
    private boolean retrieval;
    private int task;
    private boolean tightGrouping;
    private boolean hireTrainees;

    public GuardTaskMessage() {
    }

    public GuardTaskMessage(@NotNull AbstractBuildingGuards.View building, ResourceLocation job, boolean assignmentMode, boolean patrollingMode, boolean retrieval, int task, boolean tightGrouping, boolean hireTrainees) {
        super(building);
        this.job = job;
        this.assignmentMode = assignmentMode;
        this.patrollingMode = patrollingMode;
        this.retrieval = retrieval;
        this.task = task;
        this.tightGrouping = tightGrouping;
        this.hireTrainees = hireTrainees;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.job = buf.func_192575_l();
        this.assignmentMode = buf.readBoolean();
        this.patrollingMode = buf.readBoolean();
        this.tightGrouping = buf.readBoolean();
        this.retrieval = buf.readBoolean();
        this.task = buf.readInt();
        this.hireTrainees = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_192572_a(this.job);
        buf.writeBoolean(this.assignmentMode);
        buf.writeBoolean(this.patrollingMode);
        buf.writeBoolean(this.tightGrouping);
        buf.writeBoolean(this.retrieval);
        buf.writeInt(this.task);
        buf.writeBoolean(this.hireTrainees);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuildingGuards building) {
        building.setGuardType((GuardType)IGuardTypeRegistry.getInstance().getValue(this.job));
        building.setAssignManually(this.assignmentMode);
        building.setPatrolManually(this.patrollingMode);
        building.setTightGrouping(this.tightGrouping);
        building.setRetrieveOnLowHealth(this.retrieval);
        building.setTask(GuardTask.values()[this.task]);
        building.setHireTrainees(this.hireTrainees);
        if (building.getTask().equals((Object)GuardTask.FOLLOW)) {
            ServerPlayerEntity player = ctxIn.getSender();
            if (player == null) {
                return;
            }
            building.setPlayerToFollow((PlayerEntity)player);
        }
    }
}

