/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.guard;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class MobEntryChangeMessage
extends AbstractBuildingServerMessage<AbstractBuildingGuards> {
    private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();

    public MobEntryChangeMessage() {
    }

    public MobEntryChangeMessage(@NotNull AbstractBuildingGuards.View building, List<MobEntryView> mobsToAttack) {
        super(building);
        this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
    }

    @Override
    public void toBytesOverride(PacketBuffer buf) {
        buf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack) {
            MobEntryView.writeToByteBuf(buf, entry);
        }
    }

    @Override
    public void fromBytesOverride(PacketBuffer buf) {
        int mobSize = buf.readInt();
        for (int i = 0; i < mobSize; ++i) {
            MobEntryView mobEntry = MobEntryView.readFromByteBuf(buf);
            this.mobsToAttack.add(mobEntry);
        }
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuildingGuards building) {
        building.setMobsToAttack(this.mobsToAttack);
    }
}

