/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.university;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TryResearchMessage
extends AbstractBuildingServerMessage<BuildingUniversity> {
    private String researchId;
    private String branch;

    public TryResearchMessage() {
    }

    public TryResearchMessage(IBuildingView building, @NotNull String researchId, String branch) {
        super(building);
        this.researchId = researchId;
        this.branch = branch;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.researchId = buf.func_150789_c(Short.MAX_VALUE);
        this.branch = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.researchId);
        buf.func_180714_a(this.branch);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingUniversity building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        if (colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId) == null) {
            IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, this.researchId);
            if (research.canResearch(building.getBuildingLevel() == building.getMaxBuildingLevel() ? Integer.MAX_VALUE : building.getBuildingLevel(), colony.getResearchManager().getResearchTree()) && research.hasEnoughResources((IItemHandler)new InvWrapper((IInventory)player.field_71071_by)) || player.func_184812_l_()) {
                if (player.func_184812_l_()) {
                    research.startResearch((PlayerEntity)player, colony.getResearchManager().getResearchTree());
                    colony.getResearchManager().getResearchTree().getResearch(this.branch, research.getId()).setProgress((int)(144.0 * Math.pow(2.0, research.getDepth() - 1)));
                } else {
                    if (research.getResearchRequirement() != null && !research.getResearchRequirement().isFulfilled(colony)) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirementnotmet", new Object[0]));
                        return;
                    }
                    for (ItemStorage cost : research.getCostList()) {
                        InventoryUtils.removeStackFromItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), cost.getItemStack(), cost.getAmount());
                    }
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.started", new Object[]{research.getDesc()}));
                    research.startResearch((PlayerEntity)player, colony.getResearchManager().getResearchTree());
                }
                colony.markDirty();
            }
        } else if (player.func_184812_l_() && colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId).getState() == ResearchState.IN_PROGRESS) {
            IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, this.researchId);
            colony.getResearchManager().getResearchTree().getResearch(this.branch, research.getId()).setProgress((int)(144.0 * Math.pow(2.0, research.getDepth() - 1)));
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.alreadystarted", new Object[0]));
        }
    }
}

