/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.interactionhandling.registry.InteractionResponseHandlerEntry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import com.minecolonies.apiimp.initializer.ModBuildingsInitializer;
import com.minecolonies.apiimp.initializer.ModColonyEventDescriptionTypeInitializer;
import com.minecolonies.apiimp.initializer.ModColonyEventTypeInitializer;
import com.minecolonies.apiimp.initializer.ModGuardTypesInitializer;
import com.minecolonies.apiimp.initializer.ModInteractionsInitializer;
import com.minecolonies.apiimp.initializer.ModJobsInitializer;
import com.minecolonies.apiimp.initializer.ModRecipeTypesInitializer;
import com.minecolonies.coremod.proxy.IProxy;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.MOD)
public abstract class CommonProxy
implements IProxy {
    protected static CommonMinecoloniesAPIImpl apiImpl;
    private static final Map<String, CompoundNBT> playerPropertiesData;
    public static IRecipeSerializer<?> SPECIAL_REC;

    public CommonProxy() {
        apiImpl = new CommonMinecoloniesAPIImpl();
    }

    public static void storeEntityData(String name, CompoundNBT compound) {
        playerPropertiesData.put(name, compound);
    }

    public static CompoundNBT getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerGuardTypes(RegistryEvent.Register<GuardType> event) {
        ModGuardTypesInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerNewRegistries(RegistryEvent.NewRegistry event) {
        apiImpl.onRegistryNewRegistry(event);
    }

    @Override
    public void setupApi() {
        MinecoloniesAPIProxy.getInstance().setApiInstance(apiImpl);
    }

    @SubscribeEvent
    public static void registerBuildingTypes(@NotNull RegistryEvent.Register<BuildingEntry> event) {
        ModBuildingsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerInteractionTypes(@NotNull RegistryEvent.Register<InteractionResponseHandlerEntry> event) {
        ModInteractionsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerColonyEventTypes(@NotNull RegistryEvent.Register<ColonyEventTypeRegistryEntry> event) {
        ModColonyEventTypeInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerColonyEventDescriptionTypes(@NotNull RegistryEvent.Register<ColonyEventDescriptionTypeRegistryEntry> event) {
        ModColonyEventDescriptionTypeInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerJobTypes(RegistryEvent.Register<JobEntry> event) {
        ModJobsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerRecipeTypes(RegistryEvent.Register<RecipeTypeEntry> event) {
        ModRecipeTypesInitializer.init(event);
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void showCitizenWindow(ICitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openSuggestionWindow(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation) {
    }

    @Override
    public void openBannerRallyGuardsWindow(ItemStack banner) {
    }

    @Override
    public void openClipBoardWindow(IColonyView colonyView) {
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos pos) {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull PlayerEntity player) {
        return ((ServerPlayerEntity)player).func_192037_E();
    }

    @Override
    public void openDecorationControllerWindow(@NotNull BlockPos pos) {
    }

    static {
        playerPropertiesData = new HashMap<String, CompoundNBT>();
    }
}

