/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.configuration.CommonConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.research.LocalResearch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GlobalResearch
implements IGlobalResearch {
    private final List<ItemStorage> costList = new ArrayList<ItemStorage>();
    private String parent = "";
    private final String id;
    private final String branch;
    private final String desc;
    private final IResearchEffect<?> effect;
    private final int depth;
    private boolean onlyChild;
    private final List<String> childs = new ArrayList<String>();
    private IResearchRequirement requirement;

    public GlobalResearch(String id, String branch, String desc, int universityLevel, IResearchEffect<?> effect) {
        this.id = id;
        this.desc = desc;
        this.effect = effect;
        this.depth = universityLevel;
        this.branch = branch;
    }

    @Override
    public boolean canResearch(int uni_level, @NotNull ILocalResearchTree localTree) {
        IGlobalResearch parentResearch = this.parent.isEmpty() ? null : IGlobalResearchTree.getInstance().getResearch(this.branch, this.parent);
        ILocalResearch localParentResearch = this.parent.isEmpty() ? null : localTree.getResearch(this.branch, parentResearch.getId());
        ILocalResearch localResearch = localTree.getResearch(this.getBranch(), this.getId());
        return !(localResearch != null || !this.canDisplay(uni_level) || parentResearch != null && (localParentResearch == null || localParentResearch.getState() != ResearchState.FINISHED) || parentResearch != null && parentResearch.hasResearchedChild(localTree) && parentResearch.hasOnlyChild() || this.depth >= 6 && localTree.branchFinishedHighestLevel(this.branch));
    }

    @Override
    public boolean canDisplay(int uni_level) {
        return uni_level >= this.depth;
    }

    @Override
    public void loadCostFromConfig() {
        this.costList.clear();
        try {
            CommonConfiguration configuration = MinecoloniesAPIProxy.getInstance().getConfig().getCommon();
            ForgeConfigSpec.ConfigValue researchCost = (ForgeConfigSpec.ConfigValue)configuration.getClass().getDeclaredField(this.id).get(configuration);
            for (String cost : (List)researchCost.get()) {
                String[] tuple = cost.split("\\*");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tuple[0]));
                if (item == null) {
                    Log.getLogger().warn("Couldn't retrieve research costList from config for " + this.branch + "/" + this.id + " for item: " + tuple[0]);
                    return;
                }
                this.costList.add(new ItemStorage(new ItemStack((IItemProvider)item, 1), Integer.parseInt(tuple[1]), false));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NumberFormatException e) {
            Log.getLogger().warn("Couldn't retrieve research costList from config for " + this.branch + "/" + this.id + " !", (Throwable)e);
        }
    }

    @Override
    public boolean hasEnoughResources(IItemHandler inventory) {
        for (ItemStorage cost : this.costList) {
            int count = InventoryUtils.getItemCountInItemHandler(inventory, stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(cost.getItemStack()));
            if (count >= cost.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ItemStorage> getCostList() {
        return ImmutableList.copyOf(this.costList);
    }

    @Override
    public void startResearch(@NotNull PlayerEntity player, @NotNull ILocalResearchTree localResearchTree) {
        if (localResearchTree.getResearch(this.branch, this.id) == null) {
            LocalResearch research = new LocalResearch(this.id, this.branch, this.depth);
            research.setState(ResearchState.IN_PROGRESS);
            localResearchTree.addResearch(this.branch, research);
        }
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean hasOnlyChild() {
        return this.onlyChild;
    }

    @Override
    public void setOnlyChild(boolean onlyChild) {
        this.onlyChild = onlyChild;
    }

    @Override
    public boolean hasResearchedChild(@NotNull ILocalResearchTree localTree) {
        for (String child : this.childs) {
            IGlobalResearch childResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, child);
            ILocalResearch localResearch = localTree.getResearch(childResearch.getBranch(), childResearch.getId());
            if (localResearch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(IGlobalResearch child) {
        this.childs.add(child.getId());
        child.setParent(this.getId());
    }

    @Override
    public void setRequirement(IResearchRequirement requirement) {
        this.requirement = requirement;
    }

    @Override
    public IResearchRequirement getResearchRequirement() {
        return this.requirement;
    }

    @Override
    public void setParent(String id) {
        this.parent = id;
    }

    @Override
    public ImmutableList<String> getChilds() {
        return ImmutableList.copyOf(this.childs);
    }

    @Override
    public IResearchEffect<?> getEffect() {
        return this.effect;
    }
}

