/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.NBTUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class LocalResearchTree
implements ILocalResearchTree {
    private final Map<String, Map<String, ILocalResearch>> researchTree = new HashMap<String, Map<String, ILocalResearch>>();
    private final Map<String, ILocalResearch> inProgress = new HashMap<String, ILocalResearch>();
    private final Map<String, Boolean> levelSixResearchReached = new HashMap<String, Boolean>();

    @Override
    public ILocalResearch getResearch(String branch, String id) {
        if (!this.researchTree.containsKey(branch)) {
            return null;
        }
        return this.researchTree.get(branch).get(id);
    }

    @Override
    public void addResearch(String branch, ILocalResearch research) {
        Map<String, ILocalResearch> branchMap = this.researchTree.containsKey(branch) ? this.researchTree.get(branch) : new HashMap<String, ILocalResearch>();
        branchMap.put(research.getId(), research);
        this.researchTree.put(branch, branchMap);
        if (research.getState() == ResearchState.IN_PROGRESS) {
            this.inProgress.put(research.getId(), research);
        } else if (research.getState() == ResearchState.FINISHED) {
            this.inProgress.remove(research.getId());
        }
        if (research.getDepth() == 6) {
            this.levelSixResearchReached.put(research.getBranch(), true);
        }
    }

    @Override
    public boolean branchFinishedHighestLevel(String branch) {
        return this.levelSixResearchReached.getOrDefault(branch, false);
    }

    @Override
    public List<ILocalResearch> getResearchInProgress() {
        return ImmutableList.copyOf(this.inProgress.values());
    }

    @Override
    public void finishResearch(String id) {
        this.inProgress.remove(id);
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        ListNBT researchList = this.researchTree.values().stream().flatMap(map -> map.values().stream()).map(research -> StandardFactoryController.getInstance().serialize(research)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("researchTree", (INBT)researchList);
    }

    @Override
    public void readFromNBT(CompoundNBT compound, IResearchEffectManager effects) {
        this.researchTree.clear();
        NBTUtils.streamCompound(compound.func_150295_c("researchTree", 10)).map(researchCompound -> (ILocalResearch)StandardFactoryController.getInstance().deserialize((CompoundNBT)researchCompound)).forEach(research -> {
            this.addResearch(research.getBranch(), (ILocalResearch)research);
            if (research.getState() == ResearchState.FINISHED) {
                effects.applyEffect(MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearch(research.getBranch(), research.getId()).getEffect());
            }
        });
    }
}

