/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.BuildingResearchRequirement;
import com.minecolonies.coremod.research.GlobalResearch;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;

public class ResearchInitializer {
    public static final String COMPOSTER_RESEARCH = "Composter";
    public static final String FLORIST_RESEARCH = "Florist";
    public static final String DYER_RESEARCH = "Dyer";
    public static final String CONCRETE_MIXER_RESEARCH = "Concrete Mixer";
    public static final String PLANTATION_RESEARCH = "Plantation";
    public static final String SMELTERY_RESEARCH = "Smeltery";
    public static final String STONESMELTERY_RESEARCH = "Stonesmeltery";
    public static final String CRUSHER_RESEARCH = "Crusher";
    public static final String GLASSBLOWER_RESEARCH = "Glassblower";
    public static final String SAWMILL_RESEARCH = "Sawmill";
    public static final String SIFTER_RESEARCH = "Sifter";
    public static final String FLETCHER_RESEARCH = "Fletcher";
    public static final String BLACKSMITH_RESEARCH = "Blacksmith";
    public static final String STONEMASON_RESEARCH = "Stonemason";
    public static final String MECHANIC_RESEARCH = "Mechanic";
    public static final String MECHANIC_ENHANCED_GATES = "Enhances Gate Durability";
    public static final String SCHOOL_RESEARCH = "School";
    public static final String LIBRARY_RESEARCH = "Library";
    public static final String HOSPITAL_RESEARCH = "Hospital";
    public static final String BARRACKS_RESEARCH = "Barracks";
    public static final String COMBAT_ACADEMY_RESEARCH = "Combat Academy";
    public static final String ARCHERY_RESEARCH = "Archery";

    public static void fillResearchTree(IGlobalResearchTree researchTree) {
        ResearchInitializer.buildCombatTree(researchTree);
        ResearchInitializer.buildCivilianTree(researchTree);
        ResearchInitializer.buildTechnologyTree(researchTree);
    }

    private static void buildTechnologyTree(IGlobalResearchTree researchTree) {
        GlobalResearch biodegradable = new GlobalResearch("biodegradable", "technology", "Biodegradable", 1, new UnlockBuildingResearchEffect(COMPOSTER_RESEARCH, true));
        biodegradable.setRequirement(new BuildingResearchRequirement(3, "farmer"));
        GlobalResearch flowerpower = new GlobalResearch("flowerpower", "technology", "Flower power", 2, new UnlockBuildingResearchEffect(FLORIST_RESEARCH, true));
        flowerpower.setRequirement(new BuildingResearchRequirement(3, "composter"));
        GlobalResearch rainbowheaven = new GlobalResearch("rainbowheaven", "technology", "Rainbow Heaven", 3, new UnlockBuildingResearchEffect(DYER_RESEARCH, true));
        rainbowheaven.setRequirement(new BuildingResearchRequirement(3, "florist"));
        biodegradable.addChild(flowerpower);
        flowerpower.addChild(rainbowheaven);
        GlobalResearch letitgrow = new GlobalResearch("letitgrow", "technology", "Let it Grow", 2, new UnlockBuildingResearchEffect(PLANTATION_RESEARCH, true));
        letitgrow.setRequirement(new BuildingResearchRequirement(3, "farmer"));
        GlobalResearch doubletrouble = new GlobalResearch("doubletrouble", "technology", "Double Trouble", 3, new UnlockAbilityResearchEffect("Plant 2", true));
        doubletrouble.setRequirement(new BuildingResearchRequirement(3, "plantation"));
        biodegradable.addChild(letitgrow);
        letitgrow.addChild(doubletrouble);
        GlobalResearch bonemeal = new GlobalResearch("bonemeal", "technology", "Bonemeal", 2, new MultiplierModifierResearchEffect("Farming", 0.1));
        bonemeal.setRequirement(new BuildingResearchRequirement(4, "farmer"));
        GlobalResearch dung = new GlobalResearch("dung", "technology", "Dung", 3, new MultiplierModifierResearchEffect("Farming", 0.25));
        dung.setRequirement(new BuildingResearchRequirement(8, "farmer"));
        GlobalResearch compost = new GlobalResearch("compost", "technology", "Compost", 4, new MultiplierModifierResearchEffect("Farming", 0.5));
        compost.setRequirement(new BuildingResearchRequirement(12, "farmer"));
        GlobalResearch fertilizer = new GlobalResearch("fertilizer", "technology", "Fertilizer", 5, new MultiplierModifierResearchEffect("Farming", 0.75));
        fertilizer.setRequirement(new BuildingResearchRequirement(5, "composter"));
        GlobalResearch magicCompost = new GlobalResearch("magiccompost", "technology", "Magic Compost", 6, new MultiplierModifierResearchEffect("Farming", 2.0));
        biodegradable.addChild(bonemeal);
        bonemeal.addChild(dung);
        dung.addChild(compost);
        compost.addChild(fertilizer);
        fertilizer.addChild(magicCompost);
        GlobalResearch hot = new GlobalResearch("hot", "technology", "Hot!", 1, new UnlockBuildingResearchEffect(SMELTERY_RESEARCH, true));
        hot.setRequirement(new BuildingResearchRequirement(2, "miner"));
        GlobalResearch isthisredstone = new GlobalResearch("isthisredstone", "technology", "Is this Redstone?", 2, new MultiplierModifierResearchEffect("Block Break Speed", 0.1));
        bonemeal.setRequirement(new BuildingResearchRequirement(3, "miner"));
        GlobalResearch redstonepowered = new GlobalResearch("redstonepowered", "technology", "Redstone powered", 3, new MultiplierModifierResearchEffect("Block Break Speed", 0.25));
        dung.setRequirement(new BuildingResearchRequirement(4, "miner"));
        GlobalResearch heavymachinery = new GlobalResearch("heavymachinery", "technology", "Heavy Machinery", 4, new MultiplierModifierResearchEffect("Block Break Speed", 0.5));
        compost.setRequirement(new BuildingResearchRequirement(5, "miner"));
        GlobalResearch whatisthisspeed = new GlobalResearch("whatisthisspeed", "technology", "What is this speed?", 5, new MultiplierModifierResearchEffect("Block Break Speed", 1.0));
        fertilizer.setRequirement(new BuildingResearchRequirement(3, "smeltery"));
        GlobalResearch lightning = new GlobalResearch("lightning", "technology", "Lightning", 6, new MultiplierModifierResearchEffect("Block Break Speed", 2.0));
        hot.addChild(isthisredstone);
        isthisredstone.addChild(redstonepowered);
        redstonepowered.addChild(heavymachinery);
        heavymachinery.addChild(whatisthisspeed);
        whatisthisspeed.addChild(lightning);
        GlobalResearch theflintstones = new GlobalResearch("theflintstones", "technology", "The Flintstones", 2, new UnlockBuildingResearchEffect(STONESMELTERY_RESEARCH, true));
        theflintstones.setRequirement(new BuildingResearchRequirement(3, "smeltery"));
        hot.addChild(theflintstones);
        GlobalResearch thoselungs = new GlobalResearch("thoselungs", "technology", "Those lungs!", 2, new UnlockBuildingResearchEffect(GLASSBLOWER_RESEARCH, true));
        thoselungs.setRequirement(new BuildingResearchRequirement(3, "smeltery"));
        hot.addChild(thoselungs);
        GlobalResearch woodwork = new GlobalResearch("woodwork", "technology", "Woodwork", 1, new UnlockBuildingResearchEffect(SAWMILL_RESEARCH, true));
        woodwork.setRequirement(new BuildingResearchRequirement(3, "lumberjack"));
        GlobalResearch sieving = new GlobalResearch("sieving", "technology", "Sieving", 2, new UnlockBuildingResearchEffect(SIFTER_RESEARCH, true));
        sieving.setRequirement(new BuildingResearchRequirement(3, "fisherman"));
        GlobalResearch space = new GlobalResearch("space", "technology", "Space", 3, new MultiplierModifierResearchEffect("Minimum Stock", 0.5));
        space.setRequirement(new BuildingResearchRequirement(3, "miner"));
        GlobalResearch capacity = new GlobalResearch("capacity", "technology", "Capacity", 4, new MultiplierModifierResearchEffect("Minimum Stock", 1.0));
        capacity.setRequirement(new BuildingResearchRequirement(4, "miner"));
        GlobalResearch fullstock = new GlobalResearch("fullstock", "technology", "Full Stock!", 5, new MultiplierModifierResearchEffect("Minimum Stock", 2.0));
        fullstock.setRequirement(new BuildingResearchRequirement(5, "miner"));
        GlobalResearch stringwork = new GlobalResearch("stringwork", "technology", "Stringwork", 2, new UnlockBuildingResearchEffect(FLETCHER_RESEARCH, true));
        stringwork.setRequirement(new BuildingResearchRequirement(1, "sawmill"));
        GlobalResearch hotboots = new GlobalResearch("hotboots", "technology", "Hot Boots", 3, new UnlockAbilityResearchEffect("Miner Fire Res", true));
        hotboots.setRequirement(new BuildingResearchRequirement(1, "fletcher"));
        woodwork.addChild(stringwork);
        stringwork.addChild(hotboots);
        woodwork.addChild(sieving);
        sieving.addChild(space);
        space.addChild(capacity);
        capacity.addChild(fullstock);
        GlobalResearch memoryaid = new GlobalResearch("memoryaid", "technology", "Memory Aid", 2, new MultiplierModifierResearchEffect("Recipes", 0.25));
        memoryaid.setRequirement(new BuildingResearchRequirement(1, "sawmill"));
        GlobalResearch cheatsheet = new GlobalResearch("cheatsheet", "technology", "Cheat Sheet", 3, new MultiplierModifierResearchEffect("Recipes", 0.5));
        cheatsheet.setRequirement(new BuildingResearchRequirement(2, "sawmill"));
        GlobalResearch recipebook = new GlobalResearch("recipebook", "technology", "Recipe book", 4, new MultiplierModifierResearchEffect("Recipes", 1.0));
        recipebook.setRequirement(new BuildingResearchRequirement(3, "sawmill"));
        GlobalResearch rtm = new GlobalResearch("rtm", "technology", "RTM", 5, new MultiplierModifierResearchEffect("Recipes", 2.0));
        rtm.setRequirement(new BuildingResearchRequirement(4, "sawmill"));
        GlobalResearch rainman = new GlobalResearch("rainman", "technology", "Rainman", 6, new UnlockAbilityResearchEffect("Working in Rain", true));
        woodwork.addChild(memoryaid);
        memoryaid.addChild(cheatsheet);
        cheatsheet.addChild(recipebook);
        recipebook.addChild(rtm);
        rtm.addChild(rainman);
        GlobalResearch deeppockets = new GlobalResearch("deeppockets", "technology", "Deep Pockets", 4, new AdditionModifierResearchEffect("Citizen Inv Slots", 9.0));
        deeppockets.setRequirement(new BuildingResearchRequirement(4, "library"));
        GlobalResearch loaded = new GlobalResearch("loaded", "technology", "Loaded", 5, new AdditionModifierResearchEffect("Citizen Inv Slots", 18.0));
        loaded.setRequirement(new BuildingResearchRequirement(5, "library"));
        GlobalResearch heavilyloaded = new GlobalResearch("heavilyloaded", "technology", "Heavily Loaded", 6, new AdditionModifierResearchEffect("Citizen Inv Slots", 27.0));
        cheatsheet.addChild(deeppockets);
        deeppockets.addChild(loaded);
        loaded.addChild(heavilyloaded);
        GlobalResearch hittingiron = new GlobalResearch("hittingiron", "technology", "Hitting Iron!", 1, new UnlockBuildingResearchEffect(BLACKSMITH_RESEARCH, true));
        hittingiron.setRequirement(new BuildingResearchRequirement(3, "miner"));
        GlobalResearch strong = new GlobalResearch("strong", "technology", "Strong", 2, new MultiplierModifierResearchEffect("Tool Durability", 0.05));
        strong.setRequirement(new BuildingResearchRequirement(1, "blacksmith"));
        GlobalResearch hardened = new GlobalResearch("hardened", "technology", "Hardened", 3, new MultiplierModifierResearchEffect("Tool Durability", 0.1));
        hardened.setRequirement(new BuildingResearchRequirement(2, "blacksmith"));
        GlobalResearch reinforced = new GlobalResearch("reinforced", "technology", "Reinforced", 4, new MultiplierModifierResearchEffect("Tool Durability", 0.25));
        reinforced.setRequirement(new BuildingResearchRequirement(3, "blacksmith"));
        GlobalResearch steelbracing = new GlobalResearch("steelbracing", "technology", "Steel Bracing", 5, new MultiplierModifierResearchEffect("Tool Durability", 0.5));
        steelbracing.setRequirement(new BuildingResearchRequirement(4, "blacksmith"));
        GlobalResearch diamondcoated = new GlobalResearch("diamondcoated", "technology", "Diamond Coated", 6, new MultiplierModifierResearchEffect("Tool Durability", 0.9));
        steelbracing.setRequirement(new BuildingResearchRequirement(5, "blacksmith"));
        hittingiron.addChild(strong);
        strong.addChild(hardened);
        hardened.addChild(reinforced);
        reinforced.addChild(steelbracing);
        steelbracing.addChild(diamondcoated);
        GlobalResearch stonecake = new GlobalResearch("stonecake", "technology", "Stone Cake", 1, new UnlockBuildingResearchEffect(STONEMASON_RESEARCH, true));
        stonecake.setRequirement(new BuildingResearchRequirement(3, "miner"));
        GlobalResearch rockingroll = new GlobalResearch("rockingroll", "technology", "Rocking Roll", 2, new UnlockBuildingResearchEffect(CRUSHER_RESEARCH, true));
        rockingroll.setRequirement(new BuildingResearchRequirement(1, "stonemason"));
        GlobalResearch gildedhammer = new GlobalResearch("gildedhammer", "technology", "Gilded Hammer", 3, new UnlockAbilityResearchEffect("1:1 Crushing", true));
        gildedhammer.setRequirement(new BuildingResearchRequirement(3, "crusher"));
        GlobalResearch pavetheroad = new GlobalResearch("pavetheroad", "technology", "Pave the Road", 2, new UnlockBuildingResearchEffect(CONCRETE_MIXER_RESEARCH, true));
        pavetheroad.setRequirement(new BuildingResearchRequirement(1, "crusher"));
        stonecake.addChild(rockingroll);
        rockingroll.addChild(gildedhammer);
        rockingroll.addChild(pavetheroad);
        GlobalResearch ability = new GlobalResearch("ability", "technology", "Ability", 2, new MultiplierModifierResearchEffect("Block Place Speed", 0.1));
        ability.setRequirement(new BuildingResearchRequirement(1, "miner"));
        GlobalResearch skills = new GlobalResearch("skills", "technology", "Skills", 3, new MultiplierModifierResearchEffect("Block Place Speed", 0.25));
        skills.setRequirement(new BuildingResearchRequirement(2, "miner"));
        GlobalResearch tools = new GlobalResearch("tools", "technology", "Tools", 4, new MultiplierModifierResearchEffect("Block Place Speed", 0.5));
        tools.setRequirement(new BuildingResearchRequirement(4, "blacksmith"));
        GlobalResearch seemsautomatic = new GlobalResearch("seemsautomatic", "technology", "Seems automatic", 5, new MultiplierModifierResearchEffect("Block Place Speed", 1.0));
        seemsautomatic.setRequirement(new BuildingResearchRequirement(5, "blacksmith"));
        GlobalResearch madness = new GlobalResearch("madness", "technology", "Madness!", 6, new MultiplierModifierResearchEffect("Block Place Speed", 2.0));
        hittingiron.addChild(ability);
        ability.addChild(skills);
        skills.addChild(tools);
        tools.addChild(seemsautomatic);
        seemsautomatic.addChild(madness);
        GlobalResearch veinminer = new GlobalResearch("veinminer", "technology", "Veinminer", 2, new MultiplierModifierResearchEffect("More Ores", 0.1));
        veinminer.setRequirement(new BuildingResearchRequirement(1, "miner"));
        GlobalResearch goodveins = new GlobalResearch("goodveins", "technology", "Good Veins", 3, new MultiplierModifierResearchEffect("More Ores", 0.25));
        goodveins.setRequirement(new BuildingResearchRequirement(2, "miner"));
        GlobalResearch richveins = new GlobalResearch("richveins", "technology", "Rich Veins", 4, new MultiplierModifierResearchEffect("More Ores", 0.5));
        richveins.setRequirement(new BuildingResearchRequirement(4, "blacksmith"));
        GlobalResearch amazingveins = new GlobalResearch("amazingveins", "technology", "Amazing Veins", 5, new MultiplierModifierResearchEffect("More Ores", 1.0));
        amazingveins.setRequirement(new BuildingResearchRequirement(5, "blacksmith"));
        GlobalResearch motherlode = new GlobalResearch("motherlode", "technology", "Motherlode", 6, new MultiplierModifierResearchEffect("More Ores", 2.0));
        hittingiron.addChild(veinminer);
        veinminer.addChild(goodveins);
        goodveins.addChild(richveins);
        richveins.addChild(amazingveins);
        amazingveins.addChild(motherlode);
        GlobalResearch whatyaneed = new GlobalResearch("whatyaneed", "technology", "What ya Need?", 2, new UnlockBuildingResearchEffect(MECHANIC_RESEARCH, true));
        GlobalResearch enhanced_gates1 = new GlobalResearch("enhanced_gates1", "technology", "Enhanced Gates I", 3, new AdditionModifierResearchEffect(MECHANIC_ENHANCED_GATES, 5.0));
        GlobalResearch enhanced_gates2 = new GlobalResearch("enhanced_gates2", "technology", "Enhanced Gates II", 4, new AdditionModifierResearchEffect(MECHANIC_ENHANCED_GATES, 15.0));
        whatyaneed.setRequirement(new BuildingResearchRequirement(3, "blacksmith"));
        hittingiron.addChild(whatyaneed);
        whatyaneed.addChild(enhanced_gates1);
        enhanced_gates1.addChild(enhanced_gates2);
        GlobalResearch knowtheend = new GlobalResearch("knowtheend", "technology", "Know the End?", 3, new UnlockAbilityResearchEffect("Knowledge of The End", true));
        knowtheend.setRequirement(new BuildingResearchRequirement(3, "bakery"));
        theflintstones.addChild(knowtheend);
        researchTree.addResearch(pavetheroad.getBranch(), pavetheroad);
        researchTree.addResearch(gildedhammer.getBranch(), gildedhammer);
        researchTree.addResearch(hotboots.getBranch(), hotboots);
        researchTree.addResearch(doubletrouble.getBranch(), doubletrouble);
        researchTree.addResearch(whatyaneed.getBranch(), whatyaneed);
        researchTree.addResearch(enhanced_gates1.getBranch(), enhanced_gates1);
        researchTree.addResearch(enhanced_gates2.getBranch(), enhanced_gates2);
        researchTree.addResearch(stringwork.getBranch(), stringwork);
        researchTree.addResearch(thoselungs.getBranch(), thoselungs);
        researchTree.addResearch(rainbowheaven.getBranch(), rainbowheaven);
        researchTree.addResearch(deeppockets.getBranch(), deeppockets);
        researchTree.addResearch(loaded.getBranch(), loaded);
        researchTree.addResearch(heavilyloaded.getBranch(), heavilyloaded);
        researchTree.addResearch(veinminer.getBranch(), veinminer);
        researchTree.addResearch(goodveins.getBranch(), goodveins);
        researchTree.addResearch(richveins.getBranch(), richveins);
        researchTree.addResearch(amazingveins.getBranch(), amazingveins);
        researchTree.addResearch(motherlode.getBranch(), motherlode);
        researchTree.addResearch(ability.getBranch(), ability);
        researchTree.addResearch(skills.getBranch(), skills);
        researchTree.addResearch(tools.getBranch(), tools);
        researchTree.addResearch(seemsautomatic.getBranch(), seemsautomatic);
        researchTree.addResearch(madness.getBranch(), madness);
        researchTree.addResearch(hittingiron.getBranch(), hittingiron);
        researchTree.addResearch(stonecake.getBranch(), stonecake);
        researchTree.addResearch(strong.getBranch(), strong);
        researchTree.addResearch(hardened.getBranch(), hardened);
        researchTree.addResearch(reinforced.getBranch(), reinforced);
        researchTree.addResearch(steelbracing.getBranch(), steelbracing);
        researchTree.addResearch(diamondcoated.getBranch(), diamondcoated);
        researchTree.addResearch(memoryaid.getBranch(), memoryaid);
        researchTree.addResearch(cheatsheet.getBranch(), cheatsheet);
        researchTree.addResearch(recipebook.getBranch(), recipebook);
        researchTree.addResearch(rtm.getBranch(), rtm);
        researchTree.addResearch(rainman.getBranch(), rainman);
        researchTree.addResearch(woodwork.getBranch(), woodwork);
        researchTree.addResearch(sieving.getBranch(), sieving);
        researchTree.addResearch(space.getBranch(), space);
        researchTree.addResearch(capacity.getBranch(), capacity);
        researchTree.addResearch(fullstock.getBranch(), fullstock);
        researchTree.addResearch(theflintstones.getBranch(), theflintstones);
        researchTree.addResearch(rockingroll.getBranch(), rockingroll);
        researchTree.addResearch(hot.getBranch(), hot);
        researchTree.addResearch(isthisredstone.getBranch(), isthisredstone);
        researchTree.addResearch(redstonepowered.getBranch(), redstonepowered);
        researchTree.addResearch(heavymachinery.getBranch(), heavymachinery);
        researchTree.addResearch(whatisthisspeed.getBranch(), whatisthisspeed);
        researchTree.addResearch(lightning.getBranch(), lightning);
        researchTree.addResearch(biodegradable.getBranch(), biodegradable);
        researchTree.addResearch(flowerpower.getBranch(), flowerpower);
        researchTree.addResearch(letitgrow.getBranch(), letitgrow);
        researchTree.addResearch(bonemeal.getBranch(), bonemeal);
        researchTree.addResearch(dung.getBranch(), dung);
        researchTree.addResearch(compost.getBranch(), compost);
        researchTree.addResearch(fertilizer.getBranch(), fertilizer);
        researchTree.addResearch(magicCompost.getBranch(), magicCompost);
        researchTree.addResearch(knowtheend.getBranch(), knowtheend);
    }

    private static void buildCivilianTree(IGlobalResearchTree researchTree) {
        GlobalResearch higherlearning = new GlobalResearch("higherlearning", "civilian", "Higher Learning", 1, new UnlockBuildingResearchEffect(SCHOOL_RESEARCH, true));
        higherlearning.setRequirement(new BuildingResearchRequirement(3, "citizen"));
        higherlearning.setOnlyChild(true);
        GlobalResearch morebooks = new GlobalResearch("morebooks", "civilian", "More Books", 2, new MultiplierModifierResearchEffect("Teaching", 0.05));
        morebooks.setRequirement(new BuildingResearchRequirement(1, "school"));
        GlobalResearch bookworm = new GlobalResearch("bookworm", "civilian", "Bookworm", 3, new MultiplierModifierResearchEffect("Teaching", 0.1));
        bookworm.setRequirement(new BuildingResearchRequirement(3, "school"));
        GlobalResearch bachelor = new GlobalResearch("bachelor", "civilian", "Bachelor", 4, new MultiplierModifierResearchEffect("Teaching", 0.25));
        bachelor.setRequirement(new BuildingResearchRequirement(3, "library"));
        GlobalResearch master = new GlobalResearch("master", "civilian", "Master", 5, new MultiplierModifierResearchEffect("Teaching", 0.5));
        master.setRequirement(new BuildingResearchRequirement(5, "library"));
        GlobalResearch phd = new GlobalResearch("phd", "civilian", "P.h.D", 6, new MultiplierModifierResearchEffect("Teaching", 1.0));
        higherlearning.addChild(morebooks);
        morebooks.addChild(bookworm);
        bookworm.addChild(bachelor);
        bachelor.addChild(master);
        master.addChild(phd);
        GlobalResearch nurture = new GlobalResearch("nurture", "civilian", "Nurture", 2, new MultiplierModifierResearchEffect("Growth", 0.05));
        nurture.setRequirement(new BuildingResearchRequirement(1, "school"));
        GlobalResearch hormones = new GlobalResearch("hormones", "civilian", "Hormones", 3, new MultiplierModifierResearchEffect("Growth", 0.1));
        hormones.setRequirement(new BuildingResearchRequirement(3, "school"));
        GlobalResearch puberty = new GlobalResearch("puberty", "civilian", "Puberty", 4, new MultiplierModifierResearchEffect("Growth", 0.25));
        puberty.setRequirement(new BuildingResearchRequirement(3, "library"));
        GlobalResearch growth = new GlobalResearch("growth", "civilian", "Growth", 5, new MultiplierModifierResearchEffect("Growth", 0.5));
        growth.setRequirement(new BuildingResearchRequirement(5, "library"));
        GlobalResearch beanstalk = new GlobalResearch("beanstalk", "civilian", "Beanstalk", 6, new MultiplierModifierResearchEffect("Growth", 1.0));
        higherlearning.addChild(nurture);
        nurture.addChild(hormones);
        hormones.addChild(puberty);
        puberty.addChild(growth);
        growth.addChild(beanstalk);
        GlobalResearch keen = new GlobalResearch("keen", "civilian", "Keen", 1, new UnlockBuildingResearchEffect(LIBRARY_RESEARCH, true));
        keen.setRequirement(new BuildingResearchRequirement(3, "citizen"));
        GlobalResearch outpost = new GlobalResearch("outpost", "civilian", "Outpost", 2, new AdditionModifierResearchEffect("Citizen-Cap", 25.0));
        outpost.setRequirement(new BuildingResearchRequirement(4, "citizen"));
        GlobalResearch hamlet = new GlobalResearch("hamlet", "civilian", "Hamlet", 3, new AdditionModifierResearchEffect("Citizen-Cap", 50.0));
        hamlet.setRequirement(new BuildingResearchRequirement(5, "citizen"));
        GlobalResearch village = new GlobalResearch("village", "civilian", "Village", 4, new AdditionModifierResearchEffect("Citizen-Cap", 75.0));
        village.setRequirement(new BuildingResearchRequirement(4, "townhall"));
        GlobalResearch city = new GlobalResearch("city", "civilian", "City", 5, new AdditionModifierResearchEffect("Citizen-Cap", 175.0));
        city.setRequirement(new BuildingResearchRequirement(5, "townhall"));
        keen.addChild(outpost);
        outpost.addChild(hamlet);
        hamlet.addChild(village);
        village.addChild(city);
        GlobalResearch diligent = new GlobalResearch("diligent", "civilian", "Diligent", 2, new MultiplierModifierResearchEffect("Leveling", 0.05));
        diligent.setRequirement(new BuildingResearchRequirement(2, "library"));
        GlobalResearch studious = new GlobalResearch("studious", "civilian", "Studious", 3, new MultiplierModifierResearchEffect("Leveling", 0.1));
        studious.setRequirement(new BuildingResearchRequirement(3, "library"));
        GlobalResearch scholarly = new GlobalResearch("scholarly", "civilian", "Scholarly", 4, new MultiplierModifierResearchEffect("Leveling", 0.25));
        scholarly.setRequirement(new BuildingResearchRequirement(4, "library"));
        GlobalResearch reflective = new GlobalResearch("reflective", "civilian", "Reflective", 5, new MultiplierModifierResearchEffect("Leveling", 0.5));
        reflective.setRequirement(new BuildingResearchRequirement(5, "library"));
        GlobalResearch academic = new GlobalResearch("academic", "civilian", "Academic", 6, new MultiplierModifierResearchEffect("Leveling", 1.0));
        keen.addChild(diligent);
        diligent.addChild(studious);
        studious.addChild(scholarly);
        scholarly.addChild(reflective);
        reflective.addChild(academic);
        GlobalResearch rails = new GlobalResearch("rails", "civilian", "Rails", 2, new UnlockAbilityResearchEffect("Rails", true));
        rails.setRequirement(new BuildingResearchRequirement(3, "deliveryman"));
        GlobalResearch nimble = new GlobalResearch("nimble", "civilian", "Nimble", 3, new MultiplierModifierResearchEffect("Walking", 0.05));
        nimble.setRequirement(new BuildingResearchRequirement(3, "townhall"));
        GlobalResearch agile = new GlobalResearch("agile", "civilian", "Agile", 4, new MultiplierModifierResearchEffect("Walking", 0.1));
        agile.setRequirement(new BuildingResearchRequirement(4, "townhall"));
        GlobalResearch swift = new GlobalResearch("swift", "civilian", "Swift", 5, new MultiplierModifierResearchEffect("Walking", 0.15));
        swift.setRequirement(new BuildingResearchRequirement(5, "townhall"));
        GlobalResearch athlete = new GlobalResearch("athlete", "civilian", "Athlete", 6, new MultiplierModifierResearchEffect("Walking", 0.25));
        keen.addChild(rails);
        rails.addChild(nimble);
        nimble.addChild(agile);
        agile.addChild(swift);
        swift.addChild(athlete);
        GlobalResearch firstaid = new GlobalResearch("firstaid", "civilian", "First Aid", 1, new AdditionModifierResearchEffect("Health", 2.0));
        firstaid.setRequirement(new BuildingResearchRequirement(1, "townhall"));
        GlobalResearch firstaid2 = new GlobalResearch("firstaid2", "civilian", "First Aid II", 2, new AdditionModifierResearchEffect("Health", 4.0));
        firstaid2.setRequirement(new BuildingResearchRequirement(2, "townhall"));
        GlobalResearch livesaver = new GlobalResearch("livesaver", "civilian", "Livesaver", 3, new AdditionModifierResearchEffect("Health", 6.0));
        livesaver.setRequirement(new BuildingResearchRequirement(3, "townhall"));
        GlobalResearch livesaver2 = new GlobalResearch("livesaver2", "civilian", "Livesaver II", 4, new AdditionModifierResearchEffect("Health", 8.0));
        livesaver2.setRequirement(new BuildingResearchRequirement(4, "townhall"));
        GlobalResearch guardianangel = new GlobalResearch("guardianangel", "civilian", "Guardian Angel", 5, new AdditionModifierResearchEffect("Health", 10.0));
        guardianangel.setRequirement(new BuildingResearchRequirement(5, "townhall"));
        GlobalResearch guardianangel2 = new GlobalResearch("guardianangel2", "civilian", "Guardian Angel II", 6, new AdditionModifierResearchEffect("Health", 20.0));
        firstaid.addChild(firstaid2);
        firstaid2.addChild(livesaver);
        livesaver.addChild(livesaver2);
        livesaver2.addChild(guardianangel);
        guardianangel.addChild(guardianangel2);
        GlobalResearch stamina = new GlobalResearch("stamina", "civilian", "Stamina", 1, new UnlockBuildingResearchEffect(HOSPITAL_RESEARCH, true));
        stamina.setOnlyChild(true);
        GlobalResearch bandaid = new GlobalResearch("bandaid", "civilian", "Band Aid", 2, new MultiplierModifierResearchEffect("Regeneration", 0.1));
        bandaid.setRequirement(new BuildingResearchRequirement(2, "library"));
        GlobalResearch healingcream = new GlobalResearch("healingcream", "civilian", "Healing Cream", 3, new MultiplierModifierResearchEffect("Regeneration", 0.25));
        healingcream.setRequirement(new BuildingResearchRequirement(3, "library"));
        GlobalResearch bandages = new GlobalResearch("bandages", "civilian", "Bandages", 4, new MultiplierModifierResearchEffect("Regeneration", 0.5));
        bandages.setRequirement(new BuildingResearchRequirement(4, "library"));
        GlobalResearch compress = new GlobalResearch("compress", "civilian", "Compress", 5, new MultiplierModifierResearchEffect("Regeneration", 1.0));
        compress.setRequirement(new BuildingResearchRequirement(5, "library"));
        GlobalResearch cast = new GlobalResearch("cast", "civilian", "Cast", 6, new MultiplierModifierResearchEffect("Regeneration", 2.0));
        stamina.addChild(bandaid);
        bandaid.addChild(healingcream);
        healingcream.addChild(bandages);
        bandages.addChild(compress);
        compress.addChild(cast);
        GlobalResearch resistance = new GlobalResearch("resistance", "civilian", "Resistance", 2, new AdditionModifierResearchEffect("Healing Saturation Limit", -0.5));
        resistance.setRequirement(new BuildingResearchRequirement(2, "cook"));
        GlobalResearch resilience = new GlobalResearch("resilience", "civilian", "Resilience", 3, new AdditionModifierResearchEffect("Healing Saturation Limit", -1.0));
        resilience.setRequirement(new BuildingResearchRequirement(3, "cook"));
        GlobalResearch vitality = new GlobalResearch("vitality", "civilian", "Vitality", 4, new AdditionModifierResearchEffect("Healing Saturation Limit", -1.5));
        vitality.setRequirement(new BuildingResearchRequirement(4, "cook"));
        GlobalResearch fortitude = new GlobalResearch("fortitude", "civilian", "Fortitude", 5, new AdditionModifierResearchEffect("Healing Saturation Limit", -2.0));
        fortitude.setRequirement(new BuildingResearchRequirement(5, "cook"));
        GlobalResearch indefatigability = new GlobalResearch("indefatigability", "civilian", "Indefatigability", 6, new AdditionModifierResearchEffect("Healing Saturation Limit", -5.0));
        stamina.addChild(resistance);
        resistance.addChild(resilience);
        resilience.addChild(vitality);
        vitality.addChild(fortitude);
        fortitude.addChild(indefatigability);
        GlobalResearch circus = new GlobalResearch("circus", "civilian", "Circus", 2, new MultiplierModifierResearchEffect("Happiness", 0.05));
        circus.setRequirement(new BuildingResearchRequirement(2, "cook"));
        GlobalResearch festival = new GlobalResearch("festival", "civilian", "Festival", 3, new MultiplierModifierResearchEffect("Happiness", 0.1));
        festival.setRequirement(new BuildingResearchRequirement(3, "cook"));
        GlobalResearch nightowl = new GlobalResearch("nightowl", "civilian", "Nightowl", 3, new AdditionModifierResearchEffect("Working day h", 1.0));
        nightowl.setRequirement(new BuildingResearchRequirement(2, "library"));
        GlobalResearch spectacle = new GlobalResearch("spectacle", "civilian", "Spectacle", 4, new MultiplierModifierResearchEffect("Happiness", 0.15));
        spectacle.setRequirement(new BuildingResearchRequirement(4, "cook"));
        GlobalResearch nightowl2 = new GlobalResearch("nightowl2", "civilian", "Nightowl II", 4, new AdditionModifierResearchEffect("Working day h", 2.0));
        nightowl.setRequirement(new BuildingResearchRequirement(3, "townhall"));
        GlobalResearch opera = new GlobalResearch("opera", "civilian", "Opera", 5, new MultiplierModifierResearchEffect("Happiness", 0.2));
        opera.setRequirement(new BuildingResearchRequirement(5, "cook"));
        GlobalResearch theater = new GlobalResearch("theater", "civilian", "Theater", 6, new MultiplierModifierResearchEffect("Happiness", 0.5));
        firstaid.addChild(circus);
        circus.addChild(festival);
        circus.addChild(nightowl);
        festival.addChild(spectacle);
        festival.addChild(nightowl2);
        spectacle.addChild(opera);
        opera.addChild(theater);
        GlobalResearch gourmand = new GlobalResearch("gourmand", "civilian", "Gourmand", 2, new MultiplierModifierResearchEffect("Saturation", 0.1));
        gourmand.setRequirement(new BuildingResearchRequirement(2, "cook"));
        GlobalResearch gorger = new GlobalResearch("gorger", "civilian", "Gorger", 3, new MultiplierModifierResearchEffect("Saturation", 0.25));
        gorger.setRequirement(new BuildingResearchRequirement(3, "cook"));
        GlobalResearch stuffer = new GlobalResearch("stuffer", "civilian", "Stuffer", 4, new MultiplierModifierResearchEffect("Saturation", 0.5));
        stuffer.setRequirement(new BuildingResearchRequirement(4, "cook"));
        GlobalResearch epicure = new GlobalResearch("epicure", "civilian", "Epicure", 5, new MultiplierModifierResearchEffect("Saturation", 1.0));
        epicure.setRequirement(new BuildingResearchRequirement(5, "cook"));
        GlobalResearch glutton = new GlobalResearch("glutton", "civilian", "Glutton", 6, new MultiplierModifierResearchEffect("Saturation", 2.0));
        firstaid.addChild(gourmand);
        gourmand.addChild(gorger);
        gorger.addChild(stuffer);
        stuffer.addChild(epicure);
        epicure.addChild(glutton);
        researchTree.addResearch(stamina.getBranch(), stamina);
        researchTree.addResearch(resistance.getBranch(), resistance);
        researchTree.addResearch(resilience.getBranch(), resilience);
        researchTree.addResearch(vitality.getBranch(), vitality);
        researchTree.addResearch(fortitude.getBranch(), fortitude);
        researchTree.addResearch(indefatigability.getBranch(), indefatigability);
        researchTree.addResearch(bandaid.getBranch(), bandaid);
        researchTree.addResearch(healingcream.getBranch(), healingcream);
        researchTree.addResearch(bandages.getBranch(), bandages);
        researchTree.addResearch(compress.getBranch(), compress);
        researchTree.addResearch(cast.getBranch(), cast);
        researchTree.addResearch(gourmand.getBranch(), gourmand);
        researchTree.addResearch(gorger.getBranch(), gorger);
        researchTree.addResearch(stuffer.getBranch(), stuffer);
        researchTree.addResearch(epicure.getBranch(), epicure);
        researchTree.addResearch(glutton.getBranch(), glutton);
        researchTree.addResearch(circus.getBranch(), circus);
        researchTree.addResearch(festival.getBranch(), festival);
        researchTree.addResearch(nightowl.getBranch(), nightowl);
        researchTree.addResearch(nightowl2.getBranch(), nightowl2);
        researchTree.addResearch(spectacle.getBranch(), spectacle);
        researchTree.addResearch(opera.getBranch(), opera);
        researchTree.addResearch(theater.getBranch(), theater);
        researchTree.addResearch(firstaid.getBranch(), firstaid);
        researchTree.addResearch(firstaid2.getBranch(), firstaid2);
        researchTree.addResearch(livesaver.getBranch(), livesaver);
        researchTree.addResearch(livesaver2.getBranch(), livesaver2);
        researchTree.addResearch(guardianangel.getBranch(), guardianangel);
        researchTree.addResearch(guardianangel2.getBranch(), guardianangel2);
        researchTree.addResearch(rails.getBranch(), rails);
        researchTree.addResearch(nimble.getBranch(), nimble);
        researchTree.addResearch(agile.getBranch(), agile);
        researchTree.addResearch(swift.getBranch(), swift);
        researchTree.addResearch(athlete.getBranch(), athlete);
        researchTree.addResearch(diligent.getBranch(), diligent);
        researchTree.addResearch(studious.getBranch(), studious);
        researchTree.addResearch(scholarly.getBranch(), scholarly);
        researchTree.addResearch(reflective.getBranch(), reflective);
        researchTree.addResearch(academic.getBranch(), academic);
        researchTree.addResearch(keen.getBranch(), keen);
        researchTree.addResearch(outpost.getBranch(), outpost);
        researchTree.addResearch(hamlet.getBranch(), hamlet);
        researchTree.addResearch(village.getBranch(), village);
        researchTree.addResearch(city.getBranch(), city);
        researchTree.addResearch(nurture.getBranch(), nurture);
        researchTree.addResearch(hormones.getBranch(), hormones);
        researchTree.addResearch(puberty.getBranch(), puberty);
        researchTree.addResearch(growth.getBranch(), growth);
        researchTree.addResearch(beanstalk.getBranch(), beanstalk);
        researchTree.addResearch(higherlearning.getBranch(), higherlearning);
        researchTree.addResearch(morebooks.getBranch(), morebooks);
        researchTree.addResearch(bookworm.getBranch(), bookworm);
        researchTree.addResearch(bachelor.getBranch(), bachelor);
        researchTree.addResearch(master.getBranch(), master);
        researchTree.addResearch(phd.getBranch(), phd);
    }

    private static void buildCombatTree(IGlobalResearchTree researchTree) {
        GlobalResearch tacticTraining = new GlobalResearch("tactictraining", "combat", "Tactic Training", 1, new UnlockBuildingResearchEffect(BARRACKS_RESEARCH, true));
        tacticTraining.setRequirement(new BuildingResearchRequirement(3, "guardtower"));
        GlobalResearch improvedSwords = new GlobalResearch("improvedswords", "combat", "Improved Swords", 2, new UnlockBuildingResearchEffect(COMBAT_ACADEMY_RESEARCH, true));
        improvedSwords.setRequirement(new BuildingResearchRequirement(3, "barracks"));
        GlobalResearch squireTraining = new GlobalResearch("squiretraining", "combat", "Squire Training", 3, new MultiplierModifierResearchEffect("Block Attacks", 0.05));
        squireTraining.setRequirement(new BuildingResearchRequirement(3, "combatacademy"));
        GlobalResearch knightTraining = new GlobalResearch("knighttraining", "combat", "Knight Training", 4, new MultiplierModifierResearchEffect("Block Attacks", 0.1));
        knightTraining.setRequirement(new BuildingResearchRequirement(4, "combatacademy"));
        GlobalResearch captainTraining = new GlobalResearch("captaintraining", "combat", "Captain Training", 5, new MultiplierModifierResearchEffect("Block Attacks", 0.25));
        captainTraining.setRequirement(new BuildingResearchRequirement(5, "combatacademy"));
        GlobalResearch captainOfTheGuard = new GlobalResearch("captainoftheguard", "combat", "Captain of the Guard", 6, new MultiplierModifierResearchEffect("Block Attacks", 0.5));
        tacticTraining.addChild(improvedSwords);
        improvedSwords.addChild(squireTraining);
        squireTraining.addChild(knightTraining);
        knightTraining.addChild(captainTraining);
        captainTraining.addChild(captainOfTheGuard);
        GlobalResearch improvedBows = new GlobalResearch("improvedbows", "combat", "Improved Bows", 2, new UnlockBuildingResearchEffect(ARCHERY_RESEARCH, true));
        improvedBows.setRequirement(new BuildingResearchRequirement(3, "barracks"));
        GlobalResearch tickShot = new GlobalResearch("tickshot", "combat", "Tick Shot", 3, new MultiplierModifierResearchEffect("Double Arrows", 0.05));
        tickShot.setRequirement(new BuildingResearchRequirement(3, "archery"));
        GlobalResearch multiShot = new GlobalResearch("multishot", "combat", "Multi Shot", 4, new MultiplierModifierResearchEffect("Double Arrows", 0.1));
        multiShot.setRequirement(new BuildingResearchRequirement(4, "archery"));
        GlobalResearch rapidShot = new GlobalResearch("rapidshot", "combat", "Rapid Shot", 5, new MultiplierModifierResearchEffect("Double Arrows", 0.25));
        rapidShot.setRequirement(new BuildingResearchRequirement(5, "archery"));
        GlobalResearch masterBowman = new GlobalResearch("masterbowman", "combat", "Master Bowman", 6, new MultiplierModifierResearchEffect("Double Arrows", 0.5));
        tacticTraining.addChild(improvedBows);
        improvedBows.addChild(tickShot);
        tickShot.addChild(multiShot);
        multiShot.addChild(rapidShot);
        rapidShot.addChild(masterBowman);
        GlobalResearch avoidance = new GlobalResearch("avoidance", "combat", "Avoidance", 1, new UnlockAbilityResearchEffect("Shield Usage", true));
        avoidance.setRequirement(new BuildingResearchRequirement(3, "guardtower"));
        avoidance.setOnlyChild(true);
        GlobalResearch taunt = new GlobalResearch("taunt", "combat", "Taunt", 1, new UnlockAbilityResearchEffect("Knight taunt mobs", true));
        taunt.setRequirement(new BuildingResearchRequirement(1, "guardtower"));
        GlobalResearch arrowUsage = new GlobalResearch("arrowuse", "combat", "Arrow usage", 2, new UnlockAbilityResearchEffect("Consume Arrows", true));
        arrowUsage.setRequirement(new BuildingResearchRequirement(2, "guardtower"));
        taunt.addChild(arrowUsage);
        GlobalResearch arrowPiercing = new GlobalResearch("arrowpierce", "combat", "Arrow piercing", 3, new UnlockAbilityResearchEffect("Piercing Arrows", true));
        arrowPiercing.setRequirement(new BuildingResearchRequirement(1, "archery"));
        arrowUsage.addChild(arrowPiercing);
        GlobalResearch knockbackAoe = new GlobalResearch("knockbackaoe", "combat", "Unlock whirlwind ability for knights", 4, new UnlockAbilityResearchEffect("Whirldwind ability", true));
        knockbackAoe.setRequirement(new BuildingResearchRequirement(4, "barracks"));
        arrowPiercing.addChild(knockbackAoe);
        GlobalResearch parry = new GlobalResearch("parry", "combat", "Parry", 2, new MultiplierModifierResearchEffect("Melee Armour", 0.05));
        parry.setRequirement(new BuildingResearchRequirement(1, "smeltery"));
        GlobalResearch repost = new GlobalResearch("repost", "combat", "Repost", 3, new MultiplierModifierResearchEffect("Melee Armour", 0.1));
        repost.setRequirement(new BuildingResearchRequirement(1, "combatacademy"));
        GlobalResearch duelist = new GlobalResearch("duelist", "combat", "Duelist", 4, new MultiplierModifierResearchEffect("Melee Armour", 0.25));
        duelist.setRequirement(new BuildingResearchRequirement(3, "smeltery"));
        GlobalResearch provost = new GlobalResearch("provost", "combat", "Provost", 5, new MultiplierModifierResearchEffect("Melee Armour", 0.5));
        provost.setRequirement(new BuildingResearchRequirement(5, "combatacademy"));
        GlobalResearch masterSwordsman = new GlobalResearch("masterswordsman", "combat", "Master Swordsman", 6, new MultiplierModifierResearchEffect("Melee Armour", 1.0));
        avoidance.addChild(parry);
        parry.addChild(repost);
        repost.addChild(duelist);
        duelist.addChild(provost);
        provost.addChild(masterSwordsman);
        GlobalResearch dodge = new GlobalResearch("dodge", "combat", "Dodge", 2, new MultiplierModifierResearchEffect("Archer Armour", 0.05));
        dodge.setRequirement(new BuildingResearchRequirement(1, "smeltery"));
        GlobalResearch improvedDodge = new GlobalResearch("improveddodge", "combat", "Improved Dodge", 3, new MultiplierModifierResearchEffect("Archer Armour", 0.1));
        improvedDodge.setRequirement(new BuildingResearchRequirement(1, "archery"));
        GlobalResearch evasion = new GlobalResearch("evasion", "combat", "Evasion", 4, new MultiplierModifierResearchEffect("Archer Armour", 0.25));
        evasion.setRequirement(new BuildingResearchRequirement(3, "smeltery"));
        GlobalResearch improvedEvasion = new GlobalResearch("improvedevasion", "combat", "Improved Evasion", 5, new MultiplierModifierResearchEffect("Archer Armour", 0.5));
        improvedEvasion.setRequirement(new BuildingResearchRequirement(5, "archery"));
        GlobalResearch agileArcher = new GlobalResearch("agilearcher", "combat", "Agile Archer", 6, new MultiplierModifierResearchEffect("Archer Armour", 1.0));
        avoidance.addChild(dodge);
        dodge.addChild(improvedDodge);
        improvedDodge.addChild(evasion);
        evasion.addChild(improvedEvasion);
        improvedEvasion.addChild(agileArcher);
        GlobalResearch improvedLeather = new GlobalResearch("improvedleather", "combat", "Improved Leather", 1, new MultiplierModifierResearchEffect("Armor Durability", 0.1));
        improvedLeather.setRequirement(new BuildingResearchRequirement(1, "townhall"));
        GlobalResearch boiledLeather = new GlobalResearch("boiledleather", "combat", "Boiled Leather", 2, new MultiplierModifierResearchEffect("Armor Durability", 0.2));
        boiledLeather.setRequirement(new BuildingResearchRequirement(2, "townhall"));
        GlobalResearch ironSkin = new GlobalResearch("ironskin", "combat", "Iron Skin", 3, new MultiplierModifierResearchEffect("Armor Durability", 0.3));
        ironSkin.setRequirement(new BuildingResearchRequirement(3, "townhall"));
        GlobalResearch ironArmour = new GlobalResearch("ironarmour", "combat", "Iron Armour", 4, new MultiplierModifierResearchEffect("Armor Durability", 0.4));
        ironArmour.setRequirement(new BuildingResearchRequirement(4, "townhall"));
        GlobalResearch steelArmour = new GlobalResearch("steelarmour", "combat", "Steel Armour", 5, new MultiplierModifierResearchEffect("Armor Durability", 0.5));
        steelArmour.setRequirement(new BuildingResearchRequirement(5, "townhall"));
        GlobalResearch diamondSkin = new GlobalResearch("diamondskin", "combat", "Diamond Skin", 6, new MultiplierModifierResearchEffect("Armor Durability", 1.0));
        improvedLeather.addChild(boiledLeather);
        boiledLeather.addChild(ironSkin);
        ironSkin.addChild(ironArmour);
        ironArmour.addChild(steelArmour);
        steelArmour.addChild(diamondSkin);
        GlobalResearch regeneration = new GlobalResearch("regeneration", "combat", "Regeneration", 2, new UnlockAbilityResearchEffect("Retreat", true));
        regeneration.setRequirement(new BuildingResearchRequirement(2, "guardtower"));
        regeneration.setOnlyChild(true);
        GlobalResearch feint = new GlobalResearch("feint", "combat", "Feint", 3, new MultiplierModifierResearchEffect("Fleeing Damage", 0.2));
        feint.setRequirement(new BuildingResearchRequirement(4, "guardtower"));
        GlobalResearch fear = new GlobalResearch("fear", "combat", "Fear", 4, new MultiplierModifierResearchEffect("Fleeing Damage", 0.3));
        fear.setRequirement(new BuildingResearchRequirement(8, "guardtower"));
        GlobalResearch retreat = new GlobalResearch("retreat", "combat", "Retreat", 5, new MultiplierModifierResearchEffect("Fleeing Damage", 0.4));
        retreat.setRequirement(new BuildingResearchRequirement(12, "guardtower"));
        GlobalResearch fullRetreat = new GlobalResearch("fullretreat", "combat", "Full Retreat", 6, new MultiplierModifierResearchEffect("Fleeing Damage", 1.0));
        improvedLeather.addChild(regeneration);
        regeneration.addChild(feint);
        feint.addChild(fear);
        fear.addChild(retreat);
        retreat.addChild(fullRetreat);
        GlobalResearch avoid = new GlobalResearch("avoid", "combat", "Avoid", 3, new AdditionModifierResearchEffect("Fleeing Speed", 1.0));
        avoid.setRequirement(new BuildingResearchRequirement(4, "guardtower"));
        GlobalResearch evade = new GlobalResearch("evade", "combat", "Evade", 4, new AdditionModifierResearchEffect("Fleeing Speed", 2.0));
        evade.setRequirement(new BuildingResearchRequirement(8, "guardtower"));
        GlobalResearch flee = new GlobalResearch("flee", "combat", "Flee", 5, new AdditionModifierResearchEffect("Fleeing Speed", 3.0));
        flee.setRequirement(new BuildingResearchRequirement(12, "guardtower"));
        GlobalResearch hotFoot = new GlobalResearch("hotfoot", "combat", "Hotfoot", 6, new AdditionModifierResearchEffect("Fleeing Speed", 5.0));
        regeneration.addChild(avoid);
        avoid.addChild(evade);
        evade.addChild(flee);
        flee.addChild(hotFoot);
        GlobalResearch accuracy = new GlobalResearch("accuracy", "combat", "Accuracy", 1, new MultiplierModifierResearchEffect("Sleep Less", 0.5));
        accuracy.setRequirement(new BuildingResearchRequirement(1, "guardtower"));
        accuracy.setOnlyChild(true);
        GlobalResearch quickDraw = new GlobalResearch("quickdraw", "combat", "Quick Draw", 2, new AdditionModifierResearchEffect("Melee Damage", 0.5));
        quickDraw.setRequirement(new BuildingResearchRequirement(3, "barracks"));
        GlobalResearch powerAttack = new GlobalResearch("powerattack", "combat", "Power Attack", 3, new AdditionModifierResearchEffect("Melee Damage", 0.5));
        powerAttack.setRequirement(new BuildingResearchRequirement(3, "combatacademy"));
        GlobalResearch cleave = new GlobalResearch("cleave", "combat", "Cleave", 4, new AdditionModifierResearchEffect("Melee Damage", 0.5));
        cleave.setRequirement(new BuildingResearchRequirement(10, "guardtower"));
        GlobalResearch mightyCleave = new GlobalResearch("mightycleave", "combat", "Mightly Cleave", 5, new AdditionModifierResearchEffect("Melee Damage", 0.5));
        mightyCleave.setRequirement(new BuildingResearchRequirement(5, "barracks"));
        GlobalResearch whirlwind = new GlobalResearch("whirlwind", "combat", "Whirlwind", 6, new AdditionModifierResearchEffect("Melee Damage", 2.0));
        accuracy.addChild(quickDraw);
        quickDraw.addChild(powerAttack);
        powerAttack.addChild(cleave);
        cleave.addChild(mightyCleave);
        mightyCleave.addChild(whirlwind);
        GlobalResearch preciseShot = new GlobalResearch("preciseshot", "combat", "Precise Shot", 2, new AdditionModifierResearchEffect("Archer Damage", 0.5));
        preciseShot.setRequirement(new BuildingResearchRequirement(3, "barracks"));
        GlobalResearch penetratingShot = new GlobalResearch("penetratingshot", "combat", "Penetrating Shot", 3, new AdditionModifierResearchEffect("Archer Damage", 0.5));
        penetratingShot.setRequirement(new BuildingResearchRequirement(3, "archery"));
        GlobalResearch piercingShot = new GlobalResearch("piercingshot", "combat", "Piercing Shot", 4, new AdditionModifierResearchEffect("Archer Damage", 0.5));
        piercingShot.setRequirement(new BuildingResearchRequirement(10, "guardtower"));
        GlobalResearch woundingShot = new GlobalResearch("woundingshot", "combat", "Wounding Shot", 5, new AdditionModifierResearchEffect("Archer Damage", 0.5));
        woundingShot.setRequirement(new BuildingResearchRequirement(5, "barracks"));
        GlobalResearch deadlyAim = new GlobalResearch("deadlyaim", "combat", "Deadly Aim", 6, new AdditionModifierResearchEffect("Archer Damage", 2.0));
        accuracy.addChild(preciseShot);
        preciseShot.addChild(penetratingShot);
        penetratingShot.addChild(piercingShot);
        piercingShot.addChild(woundingShot);
        woundingShot.addChild(deadlyAim);
        researchTree.addResearch(tacticTraining.getBranch(), tacticTraining);
        researchTree.addResearch(improvedSwords.getBranch(), improvedSwords);
        researchTree.addResearch(improvedBows.getBranch(), improvedBows);
        researchTree.addResearch(squireTraining.getBranch(), squireTraining);
        researchTree.addResearch(knightTraining.getBranch(), knightTraining);
        researchTree.addResearch(captainTraining.getBranch(), captainTraining);
        researchTree.addResearch(captainOfTheGuard.getBranch(), captainOfTheGuard);
        researchTree.addResearch(tickShot.getBranch(), tickShot);
        researchTree.addResearch(multiShot.getBranch(), multiShot);
        researchTree.addResearch(rapidShot.getBranch(), rapidShot);
        researchTree.addResearch(masterBowman.getBranch(), masterBowman);
        researchTree.addResearch(avoidance.getBranch(), avoidance);
        researchTree.addResearch(taunt.getBranch(), taunt);
        researchTree.addResearch(arrowPiercing.getBranch(), arrowPiercing);
        researchTree.addResearch(arrowUsage.getBranch(), arrowUsage);
        researchTree.addResearch(knockbackAoe.getBranch(), knockbackAoe);
        researchTree.addResearch(parry.getBranch(), parry);
        researchTree.addResearch(repost.getBranch(), repost);
        researchTree.addResearch(duelist.getBranch(), duelist);
        researchTree.addResearch(provost.getBranch(), provost);
        researchTree.addResearch(masterSwordsman.getBranch(), masterSwordsman);
        researchTree.addResearch(dodge.getBranch(), dodge);
        researchTree.addResearch(improvedDodge.getBranch(), improvedDodge);
        researchTree.addResearch(evasion.getBranch(), evasion);
        researchTree.addResearch(improvedEvasion.getBranch(), improvedEvasion);
        researchTree.addResearch(agileArcher.getBranch(), agileArcher);
        researchTree.addResearch(improvedLeather.getBranch(), improvedLeather);
        researchTree.addResearch(boiledLeather.getBranch(), boiledLeather);
        researchTree.addResearch(ironSkin.getBranch(), ironSkin);
        researchTree.addResearch(ironArmour.getBranch(), ironArmour);
        researchTree.addResearch(steelArmour.getBranch(), steelArmour);
        researchTree.addResearch(diamondSkin.getBranch(), diamondSkin);
        researchTree.addResearch(regeneration.getBranch(), regeneration);
        researchTree.addResearch(feint.getBranch(), feint);
        researchTree.addResearch(fear.getBranch(), fear);
        researchTree.addResearch(retreat.getBranch(), retreat);
        researchTree.addResearch(fullRetreat.getBranch(), fullRetreat);
        researchTree.addResearch(avoid.getBranch(), avoid);
        researchTree.addResearch(evade.getBranch(), evade);
        researchTree.addResearch(flee.getBranch(), flee);
        researchTree.addResearch(hotFoot.getBranch(), hotFoot);
        researchTree.addResearch(accuracy.getBranch(), accuracy);
        researchTree.addResearch(quickDraw.getBranch(), quickDraw);
        researchTree.addResearch(powerAttack.getBranch(), powerAttack);
        researchTree.addResearch(cleave.getBranch(), cleave);
        researchTree.addResearch(mightyCleave.getBranch(), mightyCleave);
        researchTree.addResearch(whirlwind.getBranch(), whirlwind);
        researchTree.addResearch(preciseShot.getBranch(), preciseShot);
        researchTree.addResearch(penetratingShot.getBranch(), penetratingShot);
        researchTree.addResearch(piercingShot.getBranch(), piercingShot);
        researchTree.addResearch(woundingShot.getBranch(), woundingShot);
        researchTree.addResearch(deadlyAim.getBranch(), deadlyAim);
    }

    private ResearchInitializer() {
    }
}

